/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Component;
import java.util.Properties;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupExplorePanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class SampleModelPanelStep
extends ViewContainer
implements WizardStep {
    private final PlotViewPanel pvScatter2DDensity;
    private final PlotViewPanel pvContour2D;
    protected DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final ViewClass viewClass;
    private boolean shouldDisabledProgressBar = true;
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private BreezeLabel reducedLabel;

    public SampleModelPanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass) {
        super(breezeMainPanel, false);
        this.viewClass = new ViewClass("Model", "Exclude background and include sample pixels", this, pPClass);
        ModelButtonHelper.addTools(this, this.settingsPanel);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Include / Exclude");
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this.settingsPanel);
        this.pvScatter2DDensity = new PlotViewPanel(breezeMainPanel, "Variance scatter", "Scatter2DDensity", "model"){

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                ModelMatrix modelMatrix = (ModelMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
                if (modelMatrix.getK() < 1000) {
                    abstractPlotLayout.setSize(new Object[]{"fixed", 4.0});
                    abstractPlotLayout.getMainWindow().supportHandSelectionFeature = true;
                } else {
                    abstractPlotLayout.setSize(new Object[]{"fixed", 2.0});
                    abstractPlotLayout.getMainWindow().supportHandSelectionFeature = false;
                }
                GroupExplorePanel.checkAxis(abstractPlotLayout, SampleModelPanelStep.this.componentSectionPanel.updateComponents());
                int n = abstractPlotLayout.getPlotInit().getReduce();
                if (n > 1) {
                    SampleModelPanelStep.this.reducedLabel.setText("Reduced by factor " + n);
                    SampleModelPanelStep.this.reducedLabel.setVisible(true);
                } else {
                    SampleModelPanelStep.this.reducedLabel.setVisible(false);
                }
            }

            @Override
            public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
                PixelExploreInterface.addIncludeExcludeToMenu(this, breezeContextMenu);
                super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
            }
        };
        this.pvScatter2DDensity.setName("densityplot");
        this.componentSectionPanel.initiate(breezeMainPanel, this.pvScatter2DDensity);
        PixelExploreInterface.SpectralPlotViewPanel spectralPlotViewPanel = new PixelExploreInterface.SpectralPlotViewPanel(breezeMainPanel, null);
        spectralPlotViewPanel.setTitle(PixelExplorePanel.getSpectralTitle(analyse.getRecordGroupHolder().getFirstMeasurementWithData()));
        this.addViewPanel((Component)((Object)spectralPlotViewPanel), 0, 1, 1, 1);
        this.addViewPanel((Component)((Object)this.pvScatter2DDensity), 0, 0, 1, 1);
        TabViewContainer tabViewContainer = new TabViewContainer(breezeMainPanel);
        this.pvContour2D = new Contour2DPanel(breezeMainPanel, this.pvScatter2DDensity);
        tabViewContainer.addTab(this.pvContour2D);
        tabViewContainer.addTab(new PixelExploreInterface.ImagePlotViewPanel((PPEntryMainInterface)breezeMainPanel, analyse.getWorkflow(), 3, this.pvScatter2DDensity));
        this.addViewPanel((Component)((Object)tabViewContainer), 1, 0, 1, 2);
        tabViewContainer.setSelectedTab(0, 0);
        sectionPanel.addComponent(ModelButtonHelper.createIncludeButton(breezeMainPanel, this.pvContour2D));
        sectionPanel.addComponent(ModelButtonHelper.createIncludeOnlyButton(breezeMainPanel, this.pvContour2D));
        sectionPanel.addComponentLast(ModelButtonHelper.createExcludeButton(breezeMainPanel, this.pvContour2D));
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.settingsPanel.addSection("Select");
        sectionPanel2.addComponent(ModelButtonHelper.createSelectByDensityButton(breezeMainPanel, this.pvScatter2DDensity));
        sectionPanel2.addComponentLast(ModelButtonHelper.createSelectBorderButton(breezeMainPanel, this.pvScatter2DDensity, true));
        DefaultSettingsPanel.SectionPanel sectionPanel3 = this.settingsPanel.addSection("Other");
        sectionPanel3.addComponentLast(ModelButtonHelper.createResetButton(breezeMainPanel, this.pvContour2D, () -> {}));
        this.reducedLabel = new BreezeLabel("", false, 12);
        sectionPanel3.addComponentVertical(this.reducedLabel);
        this.reducedLabel.setIcon(ImageHelper.getResourceIcon("information"));
        this.reducedLabel.setVisible(false);
        this.reducedLabel.setFontSize(12);
        if (BreezeFrame.isHelpFeature()) {
            DefaultSettingsPanel.SectionPanel sectionPanel4 = this.settingsPanel.addSection("Information");
            sectionPanel4.addComponentLast(EntryMainHelper.createButton("Help", "help", () -> BreezeOptionDialog.showDialog(this.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Help", "1. Select sample pixels or scatter or contour plot\n\n2. Press \"Include\" or \"Exclude\" button to update model")));
        }
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        if (this.shouldDisabledProgressBar) {
            this.shouldDisabledProgressBar = false;
        }
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl && !this.hasExclusion()) {
            BreezeOptionDialog.showDialog(this.getFrame(), this.mainpanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "No pixel excluded?", "The sample model should only contain sample pixels and background pixels must be manually excluded.\n\nPress \"Cancel\"\nSelect sample pixels and press \"Include Only\" or select background pixels and press \"Exclude\".\n\nPress \"OK\" to continue without any excluded pixels", null, breezeActionEvent -> wizardControlCallback.leaveWithControl());
            return WizardStep.LeaveResult.Control;
        }
        return WizardStep.LeaveResult.Ok;
    }

    private boolean hasExclusion() {
        try {
            AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)this.pvContour2D.getVisualization().getMainWindow();
            DataSet dataSet = abstractAxisPlot.getDataSet();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(4);
            int n = innerColumnBoolean.getSize();
            for (int i = 0; i < n; ++i) {
                if (innerColumnBoolean.getValueBool(i)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Error getting exclusion", (Throwable)exception);
        }
        return false;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    private static class Contour2DPanel
    extends PlotViewPanel {
        private static final String maxVarianceImageTitle = "Max variance image";
        private final PlotViewPanel referencePlot;

        public Contour2DPanel(PPEntryMainInterface pPEntryMainInterface, PlotViewPanel plotViewPanel) {
            super(pPEntryMainInterface, maxVarianceImageTitle, "Contour2D", new String[]{"model_ObsDMXpred", "model"});
            this.setName("explorecontour2d");
            this.referencePlot = plotViewPanel;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            Properties properties = new Properties();
            properties.put("colorscheme", "gray");
            if (BreezeTheme.getInstance().isDarkMode()) {
                properties.put("reverse", "true");
            }
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            this.setTitle("Max variance image (Component  " + (abstractAxisLayer.getSettingsBox(Byte.valueOf((byte)9)).getAxisIndex() + 1) + ")");
        }

        @Override
        protected void changeAxis(boolean bl) {
            super.changeAxis(bl);
            this.postSetup(null, this.getVisualization());
        }

        @Override
        public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
            PixelExploreInterface.addIncludeExcludeToMenu(this.referencePlot, breezeContextMenu);
            super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
        }
    }
}

