/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.FloatWindowHistogram;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class SampleOutlierPanelStep
extends ViewContainer
implements WizardStep {
    private final DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final DistanceToModelPlot distanceToModelPlot;
    private final TpredHotellingPlot tpredHotellingPlot;
    private final ViewClass viewClass;
    final SampleModel model;
    private final PlotViewPanel countourPanel;
    private final BreezeCheckBox dcritCheckBox;
    private final BreezeInputField dcritValueInputField = new BreezeInputField.Number("  Value", 0.0, "");
    private final BreezeCheckBox hotellingT2CheckBox;
    private final BreezeInputField hotellingValueInputField = new BreezeInputField.Number("  Value", 0.0, "");
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;

    public SampleOutlierPanelStep(final BreezeMainPanel breezeMainPanel, PPClass pPClass, final SampleModel sampleModel) {
        super(breezeMainPanel, false);
        Serializable serializable;
        Object object;
        this.model = sampleModel;
        this.viewClass = new ViewClass("Critical distance", "Set threshold for critical distance", this, pPClass);
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this.settingsPanel);
        this.distanceToModelPlot = new DistanceToModelPlot(breezeMainPanel, "Drag the red line horizontally", true){

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                SampleOutlierPanelStep.this.componentSectionPanel.updateComponents();
            }
        };
        this.componentSectionPanel.initiate(breezeMainPanel, this.distanceToModelPlot);
        this.tpredHotellingPlot = new TpredHotellingPlot(breezeMainPanel, true);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Method");
        this.dcritCheckBox = new BreezeCheckBox("X Model Distance(Dcrit)", true, bl -> {
            sampleModel.setDcrit(bl);
            this.distanceToModelPlot.repaint();
            this.dcritValueInputField.setEnabled(bl);
        });
        sectionPanel.addComponentVertical(this.dcritCheckBox);
        this.dcritValueInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        sectionPanel.addComponentVertical(this.dcritValueInputField);
        this.dcritValueInputField.addChangeListener(textActionEvent -> {
            sampleModel.getCriticalValues().setDcrit(textActionEvent.getValue());
            this.getMainPanel().repaint();
        });
        this.hotellingT2CheckBox = new BreezeCheckBox("Hotelling T2", false, bl -> {
            sampleModel.setHotellingT2(bl);
            this.tpredHotellingPlot.repaint();
            this.hotellingValueInputField.setEnabled(bl);
        });
        sectionPanel.addComponentVertical(this.hotellingT2CheckBox);
        this.hotellingValueInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        sectionPanel.addComponentVertical(this.hotellingValueInputField);
        this.hotellingValueInputField.addChangeListener(textActionEvent -> {
            sampleModel.getCriticalValues().setHotellingT2(textActionEvent.getValue());
            this.getMainPanel().repaint();
        });
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.settingsPanel.addSection("Other");
        BreezeButton breezeButton = new BreezeButton();
        breezeButton.setIcon(new ImageIcon(this.getClass().getResource("/images/explore/restart.png")));
        breezeButton.setDesc("Reset");
        breezeButton.setDescForeground(new Color(110, 110, 110));
        breezeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SampleOutlierPanelStep.this.resetValues();
            }
        });
        sectionPanel2.addComponentLast(breezeButton);
        if (BreezeFrame.isHelpFeature()) {
            object = this.settingsPanel.addSection("Information");
            serializable = new BreezeButton();
            ((BreezeButton)serializable).setIcon(new ImageIcon(this.getClass().getResource("/images/help.png")));
            ((BreezeButton)serializable).setDesc("Help");
            ((BreezeButton)serializable).setDescForeground(new Color(110, 110, 110));
            ((BreezeButton)serializable).addMouseListener(new MouseAdapter(this){
                final /* synthetic */ SampleOutlierPanelStep this$0;
                {
                    this.this$0 = sampleOutlierPanelStep;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    BreezeOptionDialog.showDialog(this.this$0.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Help", "1. Drag the red line horizontally until Samples are visible below");
                }
            });
            ((DefaultSettingsPanel.SectionPanel)object).addComponent((JComponent)serializable);
        }
        this.addViewPanel((Component)((Object)this.distanceToModelPlot), 0, 0, 1, 1, new Insets(0, 0, 0, 0));
        this.addViewPanel((Component)((Object)this.tpredHotellingPlot), 0, 1, 1, 1, new Insets(0, 0, 0, 0));
        object = BreezeTheme.getInstance();
        serializable = ((BreezeTheme)object).getPanelBackground();
        final Properties properties = new Properties();
        properties.setProperty("colorscheme", "[custom]");
        properties.setProperty("colors", "2");
        properties.setProperty("color1", "rgba(" + ((Color)serializable).getRed() + "," + ((Color)serializable).getGreen() + "," + ((Color)serializable).getBlue() + ",1)");
        properties.setProperty("color2", "rgba(0,0,0,0.01)");
        properties.setProperty("updatecolors", "false");
        this.countourPanel = new PlotViewPanel(this, breezeMainPanel, "until Samples are visible below", "Contour2D", new String[]{"background", "background", "background", "model_ObsDMXpred"}){
            final /* synthetic */ SampleOutlierPanelStep this$0;
            {
                this.this$0 = sampleOutlierPanelStep;
                super(pPEntryMainInterface, string, string2, stringArray);
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                ((FloatWindowContour2D)abstractPlotLayout.getMainWindow()).clearSelectionList();
                int[] nArray = this.calculateDefaultBand(sampleModel);
                for (int i = 0; i < 3; ++i) {
                    AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf((double)i + 2.0));
                    PlotInit plotInit = abstractAxisLayer.getPlotInit();
                    plotInit.ccolorindex = Plot_GUI.getCsh().getRgbIndex(i);
                    abstractAxisLayer.setLayerName(Plot_GUI.RGB_NAMES[i]);
                    Properties properties2 = new Properties();
                    properties2.setProperty("colorscheme", Plot_GUI.RGB_NAMES[i]);
                    properties2.put("forcereflectance", String.valueOf(abstractPlotLayout.isAbsorbanceData()));
                    abstractAxisLayer.setColor(new Object[]{"amplitude", properties2});
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", (double)nArray[i], properties2});
                }
                abstractPlotLayout.getLayer(Double.valueOf(1.0)).setColor(new Object[]{"predictioncategory", 1.0, properties});
            }

            private int[] calculateDefaultBand(SampleModel sampleModel2) {
                int n = sampleModel2.getWavelengthCount();
                int[] nArray = new int[Math.min(n, 3)];
                for (int i = 0; i < nArray.length; ++i) {
                    if (n > 10) {
                        int n2 = n / 4;
                        nArray[i] = n2 * i + n2;
                        continue;
                    }
                    nArray[i] = i;
                }
                return nArray;
            }

            @Override
            public boolean supportChange() {
                return false;
            }

            @Override
            public boolean hasInteraction(boolean bl) {
                return false;
            }
        };
        this.addViewPanel((Component)((Object)this.countourPanel), 1, 0, 1, 2);
    }

    private void resetValues() {
        ProgressAction progressAction = new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                ((ModelMatrix)SampleOutlierPanelStep.this.distanceToModelPlot.getVisualization().getPlotInit().getDataTreeInterface()).getModel().recalculateCriticalValues();
                SampleOutlierPanelStep.this.mainpanel.setDirty(true);
            }
        };
        BreezeProgressDialog.startProgress(this.getFrame(), progressAction, "Resetting critical values", -1);
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public void enterStep() {
        this.countourPanel.getVisualization().setContentReady(false);
        ModelProperties.CriticalValues criticalValues = this.model.getCriticalValues();
        criticalValues.recalculate();
        this.dcritCheckBox.setSelected(criticalValues.isDcrit());
        this.dcritValueInputField.setEnabled(this.dcritCheckBox.isSelected());
        this.hotellingT2CheckBox.setSelected(criticalValues.isHotellingT2());
        this.hotellingValueInputField.setEnabled(this.hotellingT2CheckBox.isSelected());
        criticalValues.setCutOffCallback(this::updateValues);
        this.updateValues();
    }

    private void updateValues() {
        ModelProperties.CriticalValues criticalValues = this.model.getCriticalValues();
        this.dcritValueInputField.setValue(RtDataFormat.toString(criticalValues.getDcrit(), 4));
        this.hotellingValueInputField.setValue(RtDataFormat.toString(criticalValues.getHotellingT2(), 4));
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public static class DistanceToModelPlot
    extends PlotViewPanel {
        private final boolean editable;

        public DistanceToModelPlot(EntryMainPanelInterface entryMainPanelInterface, String string, boolean bl) {
            super((PPEntryMainInterface)entryMainPanelInterface, string, "Histogram", new String[]{"model_ObsDMXpred", "model_ObsDMX"});
            this.editable = bl;
            this.setName("histogram");
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            FloatWindowHistogram floatWindowHistogram = (FloatWindowHistogram)abstractPlotLayout.getMainWindow();
            floatWindowHistogram.setCalculateStatistics(false);
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            ModelMatrix modelMatrix = (ModelMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
            AbstractModel abstractModel = modelMatrix.getModel();
            for (double d = 1.0; d <= 2.0; d += 1.0) {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(d));
                if (d == 1.0) {
                    Properties properties = new Properties();
                    properties.put("editable", Boolean.toString(this.editable));
                    abstractAxisLayer.setStatistics(new Object[]{"dcrit", properties});
                    abstractAxisLayer.setColor(new Object[]{"fixed", "black"});
                    continue;
                }
                abstractAxisLayer.setColor(new Object[]{"fixed", "lightgray"});
            }
            abstractPlotLayout.setDataRange(new Object[]{"x", "value", abstractModel.getComponents()});
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return false;
        }
    }

    public static class TpredHotellingPlot
    extends PlotViewPanel {
        private final boolean editable;

        public TpredHotellingPlot(EntryMainPanelInterface entryMainPanelInterface, boolean bl) {
            super((PPEntryMainInterface)entryMainPanelInterface, "Hotelling T2", "Histogram", new String[]{"model_hotellingt2pred", "model_hotellingt2"});
            this.editable = bl;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            ((FloatWindowHistogram)abstractPlotLayout.getMainWindow()).setCalculateStatistics(false);
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            ModelMatrix modelMatrix = (ModelMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
            AbstractModel abstractModel = modelMatrix.getModel();
            for (double d = 1.0; d <= 2.0; d += 1.0) {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(d));
                if (d == 1.0) {
                    Properties properties = new Properties();
                    properties.put("editable", Boolean.toString(this.editable));
                    abstractAxisLayer.setStatistics(new Object[]{"hotellingt2", properties});
                    abstractAxisLayer.setColor(new Object[]{"fixed", "black"});
                    continue;
                }
                abstractAxisLayer.setColor(new Object[]{"fixed", "lightgray"});
            }
            abstractPlotLayout.setDataRange(new Object[]{"x", "value", abstractModel.getComponents()});
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return false;
        }
    }
}

