/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class SimcaPanelStep
extends ViewContainer
implements WizardStep {
    private final ClassificationModel model;
    private final ViewContainer container = new ViewContainer();
    private final CoomnansPlot scatterPanel;
    private final ModelColumnPlot columnPlot;
    private final DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final ViewClass viewClass;
    private final InteractionPreviewPanel previewPanel;
    private final TabViewContainer tabViewContainer;

    public SimcaPanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass, ClassificationModel classificationModel) {
        super(breezeMainPanel, false);
        this.model = classificationModel;
        this.viewClass = new ViewClass("Model", "Exclude outliers", this, pPClass);
        this.scatterPanel = new CoomnansPlot(breezeMainPanel);
        this.container.addViewPanel((Component)((Object)this.scatterPanel), 0, 0, 1, 1, null, 2.0, 1.0);
        this.columnPlot = new ModelColumnPlot(this.mainpanel);
        this.container.addViewPanel((Component)((Object)this.columnPlot), 1, 0, 1, 1);
        this.addViewPanel((Component)((Object)this.container), 0, 0, 1, 1);
        this.tabViewContainer = new TabViewContainer(this.mainpanel){

            @Override
            public void updateSelected(ViewClass viewClass) {
                SimcaPanelStep.this.scatterPanel.setVariable(this.getSelectedTabIndex() + 1);
                SimcaPanelStep.this.columnPlot.setVariable(this.getSelectedTabIndex() + 1);
                super.updateSelected(viewClass);
            }
        };
        this.addViewPanel((Component)((Object)this.tabViewContainer), 0, 1, 1, 1);
        this.tabViewContainer.addTab(this.container);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Include / Exclude");
        BreezeButton breezeButton = new BreezeButton();
        breezeButton.setIcon(ImageHelper.getResourceIcon("explore/library_add"));
        breezeButton.setDesc("Include");
        breezeButton.setDescForeground(new Color(110, 110, 110));
        breezeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimcaPanelStep.this.setIncludeExclude(true, false);
            }
        });
        sectionPanel.addComponent(breezeButton);
        BreezeButton breezeButton2 = new BreezeButton();
        breezeButton2.setIcon(ImageHelper.getResourceIcon("explore/add_box"));
        breezeButton2.setDesc("Include Only");
        breezeButton2.setDescForeground(new Color(110, 110, 110));
        breezeButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimcaPanelStep.this.setIncludeExclude(true, true);
            }
        });
        sectionPanel.addComponent(breezeButton2);
        BreezeButton breezeButton3 = new BreezeButton();
        breezeButton3.setIcon(ImageHelper.getResourceIcon("explore/disabled_by_default"));
        breezeButton3.setDesc("Exclude");
        breezeButton3.setDescForeground(new Color(110, 110, 110));
        breezeButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimcaPanelStep.this.setIncludeExclude(false, false);
            }
        });
        sectionPanel.addComponentLast(breezeButton3);
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.settingsPanel.addSection("Train / Test");
        BreezeButton breezeButton4 = new BreezeButton();
        breezeButton4.setIcon(ImageHelper.getResourceIcon("trainset"));
        breezeButton4.setDesc("Train");
        breezeButton4.setDescForeground(new Color(110, 110, 110));
        breezeButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimcaPanelStep.this.setTrainTest(true, false);
            }
        });
        sectionPanel2.addComponent(breezeButton4);
        BreezeButton breezeButton5 = new BreezeButton();
        breezeButton5.setIcon(ImageHelper.getResourceIcon("testset"));
        breezeButton5.setDesc("Test");
        breezeButton5.setDescForeground(new Color(110, 110, 110));
        breezeButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimcaPanelStep.this.setTrainTest(false, false);
            }
        });
        sectionPanel2.addComponentLast(breezeButton5);
        this.previewPanel = new InteractionPreviewPanel(analyse.getWorkflow());
        this.setLeftSettingsPanel(this.previewPanel);
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    private void setIncludeExclude(final boolean bl, final boolean bl2) {
        ProgressAction progressAction = new ProgressAction(this){
            final /* synthetic */ SimcaPanelStep this$0;
            {
                this.this$0 = simcaPanelStep;
            }

            @Override
            public void runAction() throws Exception {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)this.this$0.scatterPanel.getVisualization().getMainWindow();
                DataSet dataSet = abstractAxisPlot.getDataSet();
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                if (bl) {
                    if (bl2) {
                        dataSet.exclude((ProgressManager)breezeProgressManager, "obs");
                    }
                    dataSet.include(abstractAxisPlot.getInteractionArray(1));
                } else {
                    dataSet.exclude(abstractAxisPlot.getInteractionArray(1));
                }
                dataSet.applyChanges((ProgressManager)breezeProgressManager);
                abstractAxisPlot.clearSelection();
                this.this$0.mainpanel.setDirty(true);
            }
        };
        BreezeProgressDialog.startProgress(this.getFrame(), progressAction, "Updating", -1);
    }

    private void setTrainTest(final boolean bl, final boolean bl2) {
        ProgressAction progressAction = new ProgressAction(this){
            final /* synthetic */ SimcaPanelStep this$0;
            {
                this.this$0 = simcaPanelStep;
            }

            @Override
            public void runAction() throws Exception {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)this.this$0.scatterPanel.getVisualization().getMainWindow();
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                abstractAxisPlot.setTrainTest((ProgressManager)breezeProgressManager, bl, bl2, false);
                abstractAxisPlot.clearSelection();
                this.this$0.mainpanel.setDirty(true);
            }
        };
        BreezeProgressDialog.startProgress(this.getFrame(), progressAction, "Updating", -1);
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        this.previewPanel.enableInteraction(this.mainpanel);
        this.tabViewContainer.clearTabs();
        for (String string : this.model.getModelVariables()) {
            this.tabViewContainer.addTab(string, this.container);
        }
        SwingUtilities.invokeLater(() -> this.tabViewContainer.setSelectedTab(0, 0));
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        wizardControlCallback.resetText();
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    private class CoomnansPlot
    extends PlotViewPanel {
        public CoomnansPlot(BreezeMainPanel breezeMainPanel) {
            super((PPEntryMainInterface)breezeMainPanel, "Coomans plot", "Scatter2D", new String[]{"model_obsdmx", "model_predicteddistancetomodel"});
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            abstractPlotLayout.addLegend(new Object[]{abstractAxisLayer, "color", "right"});
            AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            abstractAxisLayer2.setShape(new Object[]{"fixed", "hollowcircle"});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            if (abstractAxisLayer != null) {
                abstractAxisLayer.setStatistics(new Object[]{"coomans"});
            }
            abstractPlotLayout.setColor(new Object[]{"category", SimcaPanelStep.this.model.getFactor().getName()});
            ModelMatrix modelMatrix = (ModelMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
            if (modelMatrix.getK() < 100) {
                abstractPlotLayout.setSize(new Object[]{"fixed", 7.0});
            } else if (modelMatrix.getK() < 1000) {
                abstractPlotLayout.setSize(new Object[]{"fixed", 4.0});
            } else {
                abstractPlotLayout.setSize(new Object[]{"fixed", 2.0});
            }
        }

        public void setVariable(int n) {
            AbstractPlotLayout abstractPlotLayout = this.getVisualization();
            if (abstractPlotLayout != null) {
                abstractPlotLayout.setDataRange(new Object[]{"x", "value", (double)n});
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)(n % SimcaPanelStep.this.model.getModelVariables().size() + 1)});
            }
        }

        @Override
        protected boolean supportChange() {
            return false;
        }
    }

    private class ModelColumnPlot
    extends PlotViewPanel {
        public ModelColumnPlot(EntryMainPanelInterface entryMainPanelInterface) {
            super((PPEntryMainInterface)entryMainPanelInterface, "Overview (Total for all Y)", "Column", new String[]{"model_q2x_cum(summary)", "model_r2x_cum(summary)"});
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
            AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(2)});
            abstractPlotLayout.addLegend(new Object[]{"color", "right"});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer;
            AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            if (abstractAxisLayer2 != null) {
                abstractAxisLayer2.setLayerName("R2X_cum");
            }
            if ((abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0))) != null) {
                abstractAxisLayer.setLayerName("Q2X_cum");
            }
        }

        public void setVariable(int n) {
            AbstractPlotLayout abstractPlotLayout = this.getVisualization();
            if (abstractPlotLayout != null) {
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)n});
            }
        }
    }
}

