/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.RuntimeClassificationModel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.RuntimeModelWizard;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class ANNModelPanelStep
extends ViewContainer
implements WizardStep {
    private final WizardStep.WizardControlCallback nextButtonCallback;
    private final ViewClass viewClass;
    private File tempModelFile;
    private final File modelFile;
    private final RuntimeModelWizard.CallBack callBack;

    public ANNModelPanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass, RuntimeClassificationModel runtimeClassificationModel, WizardStep.WizardControlCallback wizardControlCallback, RuntimeModelWizard.CallBack callBack) {
        super(breezeMainPanel, false);
        this.nextButtonCallback = wizardControlCallback;
        this.viewClass = new ViewClass("Model", "Train neural network", this, pPClass);
        this.modelFile = analyse.getModelDataFile();
        this.callBack = callBack;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 5));
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        jPanel.add(EntryMainHelper.createButton("trainButton", "Train", "applychanges", () -> this.trainANN(breezeMainPanel, runtimeClassificationModel, wizardControlCallback)));
        jPanel.add(new BreezeSeparator(1, 4, 60));
    }

    private void trainANN(BreezeMainPanel breezeMainPanel, final RuntimeClassificationModel runtimeClassificationModel, final WizardStep.WizardControlCallback wizardControlCallback) {
        wizardControlCallback.setEnabled(false);
        BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ ANNModelPanelStep this$0;
            {
                this.this$0 = aNNModelPanelStep;
            }

            @Override
            public void runAction() {
                this.this$0.tempModelFile = ANNModelPanelStep.trainModel(this.getProgressManager(), runtimeClassificationModel);
                wizardControlCallback.setEnabled(true);
            }
        }, "Training");
    }

    public static File trainModel(BreezeProgressManager breezeProgressManager, RuntimeClassificationModel runtimeClassificationModel) {
        File file = FileHelper.createTempFileInWorkspace("train.csv");
        runtimeClassificationModel.saveTrainingData(breezeProgressManager, file, false);
        File file2 = FileHelper.createTempFileInWorkspace("test.csv");
        runtimeClassificationModel.saveTestData(breezeProgressManager, file2, false);
        File file3 = FileHelper.createTempFileInWorkspace("model.data");
        breezeProgressManager.setInfoText("Training neural network");
        int n = runtimeClassificationModel.getFactor().getClasses().size() - 1;
        TcpManager.getInstance().trainANN(breezeProgressManager, file, file2, file3, 10, n, new int[]{32, 32, 32});
        return file3;
    }

    @Override
    public void enterStep() {
        this.nextButtonCallback.setNextText("Finish");
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            if (this.tempModelFile == null || !this.tempModelFile.exists() || this.tempModelFile.length() == 0L) {
                BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Model", "No model has been " + (FileHelper.exists(this.modelFile) ? "re-trained" : "trained") + " or imported\n\nPress Train to generate a Machine learning model or import externally trained model");
                return WizardStep.LeaveResult.Failed;
            }
            this.callBack.OnDone(this.tempModelFile);
        } else {
            this.nextButtonCallback.resetText();
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }
}

