/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.RoundedBorder;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.TabPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class ImportExportOnnxPanel
extends AbstractViewPanel
implements TabPanel.Tab {
    private final AbstractRuntimeModel model;

    public ImportExportOnnxPanel(BreezeMainPanel breezeMainPanel, AbstractRuntimeModel abstractRuntimeModel, EntryMainHelper.ClickCallBack clickCallBack) {
        super(breezeMainPanel);
        this.model = abstractRuntimeModel;
        this.setLayout(new GridBagLayout());
        BreezeLabel breezeLabel = new BreezeLabel("Click to select onnx file to import");
        breezeLabel.setResourceIcon("import");
        JPanel jPanel = this.getWrapperPanel(breezeLabel, clickCallBack);
        GridBagConstraints gridBagConstraints = GridBagHelper.createLeft(0, new Insets(10, 10, 10, 10));
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        BreezeLabel breezeLabel2 = new BreezeLabel("Click to export training data");
        breezeLabel2.setResourceIcon("export");
        JPanel jPanel2 = this.getWrapperPanel(breezeLabel2, this::exportTrainingData);
        GridBagConstraints gridBagConstraints2 = GridBagHelper.createLeft(1, new Insets(10, 10, 10, 10));
        gridBagConstraints2.anchor = 18;
        this.add(jPanel2, gridBagConstraints2);
        BreezePanel breezePanel = new BreezePanel();
        breezePanel.setOpaque(false);
        this.add(breezePanel, GridBagHelper.createLast(1, new Insets(10, 0, 0, 0)));
    }

    private JPanel getWrapperPanel(final BreezeLabel breezeLabel, final EntryMainHelper.ClickCallBack clickCallBack) {
        final JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(breezeLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.setBorder(new RoundedBorder(BreezeTheme.getInstance().getSettingPanelBackground(), 8, 2));
        jPanel.setPreferredSize(new Dimension(375, 75));
        jPanel.setMinimumSize(new Dimension(375, 75));
        jPanel.setMaximumSize(new Dimension(375, 75));
        jPanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ImportExportOnnxPanel this$0;
            {
                this.this$0 = importExportOnnxPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                clickCallBack.doClick();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                jPanel.setBorder(new RoundedBorder(BreezeTheme.getInstance().getToggleButtonHoverColor(), 8, 3));
                Font font = breezeLabel.getFont();
                HashMap hashMap = new HashMap(font.getAttributes());
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                breezeLabel.setFont(font.deriveFont(hashMap));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                jPanel.setBorder(new RoundedBorder(BreezeTheme.getInstance().getSettingPanelBackground(), 8, 2));
                Font font = breezeLabel.getFont();
                HashMap hashMap = new HashMap(font.getAttributes());
                hashMap.put(TextAttribute.UNDERLINE, null);
                breezeLabel.setFont(font.deriveFont(hashMap));
            }
        });
        return jPanel;
    }

    public void exportTrainingData() {
        final jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Export training data", (Component)this.mainpanel);
        jopensaveDialog2.setFileSelectionMode(1);
        if (jopensaveDialog2.saveshow()) {
            BreezeProgressDialog.startProgressWithCancel(this.mainpanel.getFrame(), new ProgressAction(this){
                final /* synthetic */ ImportExportOnnxPanel this$0;
                {
                    this.this$0 = importExportOnnxPanel;
                }

                @Override
                public void runAction() {
                    File file = jopensaveDialog2.getSelectedFile();
                    File file2 = new File(file, "train.csv");
                    File file3 = new File(file, "test.csv");
                    if (file2.exists() || file3.exists()) {
                        BreezeOptionDialog.showDialog(this.this$0.mainpanel.getFrame(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Overwrite files", "Train and/or Test files already exist in the selected directory.\n\nOverwrite the existing files?", breezeActionEvent -> this.saveTrainingData(file2, file3));
                    } else {
                        this.saveTrainingData(file2, file3);
                    }
                }

                private void saveTrainingData(File file, File file2) {
                    File file3 = FileHelper.createTempFileInWorkspace("train.csv");
                    File file4 = FileHelper.createTempFileInWorkspace("test.csv");
                    this.this$0.model.saveTrainingData(this.getProgressManager(), file3, false);
                    this.this$0.model.saveTestData(this.getProgressManager(), file4, false);
                    try {
                        Files.copy(file3.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        if (file4.length() > 0L) {
                            Files.copy(file4.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    ToastHandler.getInstance().showToast("Training data exported to " + file.getAbsolutePath(), Toast.IconType.Success);
                }
            }, "Saving");
        }
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    @Override
    public String getName() {
        return "import/export";
    }

    @Override
    public AbstractViewPanel getPanel() {
        return this;
    }

    public String toString() {
        return "Import / Export";
    }
}

