/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONObject;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.PythonHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.TabPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.RuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.ImportExportOnnxPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.PythonModelTrainingPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.RuntimeModelPanel;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class MachineLearningModelPanelStep
extends ViewContainer
implements WizardStep {
    private final Analyse analyse;
    private final AbstractRuntimeModel model;
    private final AbstractRuntimeModel.RuntimeSettings transientSettings;
    private final WizardStep.WizardControlCallback nextButtonCallback;
    private final String algorithmSubSetType;
    private final RuntimeModelWizard.CallBack callBack;
    private final ViewClass viewClass;
    private final BreezeButton trainRtButton;
    private final BreezeButton trainPythonButton;
    private final RuntimeModelPanel runtimeModelPanel;
    private final PythonModelTrainingPanel pythonModelTrainingPanel;
    private final File modelFile;
    private File tempModelFile;

    public MachineLearningModelPanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass, AbstractRuntimeModel abstractRuntimeModel, WizardStep.WizardControlCallback wizardControlCallback, String string, RuntimeModelWizard.CallBack callBack) {
        super(breezeMainPanel, false);
        boolean bl;
        this.analyse = analyse;
        this.model = abstractRuntimeModel;
        this.nextButtonCallback = wizardControlCallback;
        this.algorithmSubSetType = string;
        this.callBack = callBack;
        this.viewClass = new ViewClass("Model", "Train model", this, pPClass);
        TabPanel tabPanel = new TabPanel(breezeMainPanel);
        tabPanel.setName("modeltypes");
        this.transientSettings = abstractRuntimeModel.getRuntimeSettings().clone();
        this.modelFile = analyse.getOnnxFile();
        this.runtimeModelPanel = new RuntimeModelPanel(abstractRuntimeModel, string);
        this.pythonModelTrainingPanel = new PythonModelTrainingPanel(abstractRuntimeModel, this.transientSettings);
        this.trainRtButton = EntryMainHelper.createButton("trainButton", "Train model", "applychanges", () -> this.trainRuntimeModel(this.mainpanel, analyse, abstractRuntimeModel, wizardControlCallback, this.runtimeModelPanel.getTable(), abstractRuntimeModel.getRuntimeSettings()));
        this.trainPythonButton = EntryMainHelper.createButton("trainButton", "Train model", "applychanges", () -> this.trainExternalModel(this.mainpanel, abstractRuntimeModel));
        tabPanel.addTab(this.runtimeModelPanel);
        tabPanel.addTab(this.pythonModelTrainingPanel);
        tabPanel.addTab(new ImportExportOnnxPanel(breezeMainPanel, abstractRuntimeModel, this::importExternalOnnxFile));
        boolean bl2 = bl = !abstractRuntimeModel.getRuntimeResults().results.isEmpty() && abstractRuntimeModel.getRuntimeResults().results.getFirst().algorithmName.equals("External");
        if (bl) {
            tabPanel.setSelectedTab(1);
        } else {
            tabPanel.setSelectedTab(0);
        }
        tabPanel.setTabCallback(this::updateBottomRowButtons);
        this.add((Component)((Object)tabPanel));
        this.updateBottomRowButtons((TabPanel.Tab)((Object)(bl ? this.pythonModelTrainingPanel : this.runtimeModelPanel)));
    }

    private void updateBottomRowButtons(TabPanel.Tab tab) {
        switch (tab.getName()) {
            case "runtime": {
                this.trainRtButton.setVisible(true);
                this.trainPythonButton.setVisible(false);
                break;
            }
            case "python": {
                this.trainRtButton.setVisible(false);
                this.trainPythonButton.setVisible(true);
                break;
            }
            case "import/export": {
                this.trainRtButton.setVisible(false);
                this.trainPythonButton.setVisible(false);
            }
        }
    }

    @Override
    public void enterStep() {
        this.runtimeModelPanel.updateTopKMax();
        this.nextButtonCallback.setNextText("Finish");
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            if (this.tempModelFile == null || !this.tempModelFile.exists() || this.tempModelFile.length() == 0L) {
                BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Model", "No model has been " + (FileHelper.exists(this.modelFile) ? "re-trained" : "trained") + " or imported\n\nPress Train to generate a Machine learning model or import externally trained model");
                return WizardStep.LeaveResult.Failed;
            }
            this.callBack.OnDone(this.tempModelFile);
        } else {
            this.nextButtonCallback.resetText();
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.trainRtButton);
        breezeMainPanel.addRightButton(this.trainPythonButton);
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    private void trainRuntimeModel(final BreezeMainPanel breezeMainPanel, final Analyse analyse, final AbstractRuntimeModel abstractRuntimeModel, final WizardStep.WizardControlCallback wizardControlCallback, final BreezeTablePanel breezeTablePanel, final AbstractRuntimeModel.RuntimeSettings runtimeSettings) {
        wizardControlCallback.setEnabled(false);
        BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ MachineLearningModelPanelStep this$0;
            {
                this.this$0 = machineLearningModelPanelStep;
            }

            @Override
            public void runAction() {
                this.this$0.tempModelFile = RuntimeModelPanel.trainModel(this.getProgressManager(), analyse, abstractRuntimeModel, this.this$0.getFrame());
                List<AbstractRuntimeModel.RuntimeResult> list = abstractRuntimeModel.getRuntimeResults().results;
                breezeTablePanel.initTable(new RuntimeModelPanel.RuntimeTableModel(analyse.getModelMethod().getType().toString(), runtimeSettings.metric), null, false);
                breezeTablePanel.setTableList(list, null);
                breezeTablePanel.setColumnWidth(0);
                wizardControlCallback.setEnabled(true);
            }

            @Override
            public void actionComplete() {
                List<AbstractRuntimeModel.RuntimeResult> list = abstractRuntimeModel.getRuntimeResults().results;
                if (list.getFirst().accuracy.getFirst() == 1.0 && list.getFirst().crossValidationResult != 1.0) {
                    SwingUtilities.invokeLater(() -> BreezeOptionDialog.showDialog(this.this$0.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Model possibly over-fitted", "The model has an apparent accuracy of 100% but the cross-validation indicates that the model will perform with less accuracy on unknown data.\n\nConsider adding additional training and test data."));
                }
            }
        }, "Training");
    }

    public void trainExternalModel(BreezeMainPanel breezeMainPanel, final AbstractRuntimeModel abstractRuntimeModel) {
        if (StringUtils.isEmpty((CharSequence)this.transientSettings.scriptFile) || StringUtils.isEmpty((CharSequence)this.transientSettings.interpreter) && StringUtils.isEmpty((CharSequence)this.transientSettings.customInterpreter)) {
            throw new ErrorHandler.ErrorMessageException("Please select python interpreter and external script file");
        }
        final File[] fileArray = new File[1];
        this.nextButtonCallback.setEnabled(false);
        BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ MachineLearningModelPanelStep this$0;
            {
                this.this$0 = machineLearningModelPanelStep;
            }

            @Override
            public void runAction() {
                Pair<File, File> pair = MachineLearningModelPanelStep.trainUsingExternalScriptFile(this.getProgressManager(), abstractRuntimeModel, this.this$0.transientSettings.scriptFile, this.this$0.transientSettings.interpreter, this.this$0.transientSettings.customInterpreter);
                if (((File)pair.getLeft()).exists()) {
                    this.this$0.tempModelFile = (File)pair.getLeft();
                    fileArray[0] = (File)pair.getRight();
                }
            }

            @Override
            public void actionComplete() {
                this.this$0.nextButtonCallback.setEnabled(true);
                this.getProgressManager().setInfoText("Training done");
                this.this$0.setResultsFromExternalTraining(fileArray[0], this.this$0.analyse, abstractRuntimeModel);
                AbstractRuntimeModel.RuntimeSettings runtimeSettings = abstractRuntimeModel.getRuntimeSettings();
                AbstractRuntimeModel.RuntimeResult runtimeResult = abstractRuntimeModel.getRuntimeResults().results.getFirst();
                runtimeSettings.scriptFile = this.this$0.transientSettings.scriptFile;
                runtimeSettings.interpreter = this.this$0.transientSettings.interpreter;
                runtimeSettings.customInterpreter = this.this$0.transientSettings.customInterpreter;
                runtimeSettings.time = (int)runtimeResult.runtimeInSeconds;
            }

            @Override
            public void onClose() {
                AbstractRuntimeModel.RuntimeResult runtimeResult = abstractRuntimeModel.getRuntimeResults().results.getFirst();
                this.this$0.pythonModelTrainingPanel.showPythonTrainingLog(runtimeResult, this.getProgressManager().getConsoleText());
            }
        }, "Training");
    }

    private void importExternalOnnxFile() {
        final jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select file", (Component)this.mainpanel);
        jopensaveDialog2.setAcceptAllFileFilterUsed(true);
        FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("onnx", "Open Neural Network Exchange (*.onnx)");
        jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
        jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
        if (jopensaveDialog2.openshow()) {
            BreezeProgressDialog.startProgressWithCancel(this.mainpanel.getFrame(), new ProgressAction(this){
                final /* synthetic */ MachineLearningModelPanelStep this$0;
                {
                    this.this$0 = machineLearningModelPanelStep;
                }

                @Override
                public void runAction() {
                    File file = FileHelper.createTempFileInWorkspace("model.onnx");
                    Files.copy(jopensaveDialog2.getSelectedFile().toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    File file2 = FileHelper.createTempFileInWorkspace("csv");
                    this.this$0.model.saveTestData(BreezeProgressManager.createEmpty(), file2, false);
                    if (file2.length() == 0L) {
                        this.this$0.model.saveTrainingData(BreezeProgressManager.createEmpty(), file2, false);
                    }
                    String[] stringArray = TcpManager.getInstance().reshapeImportedOnnxFile(this.getProgressManager(), file, file2, this.this$0.algorithmSubSetType);
                    this.this$0.tempModelFile = file;
                    Object object = "";
                    if (stringArray.length > 1) {
                        object = "\n\nWARNINGS:\n";
                        object = (String)object + " * " + Arrays.stream(stringArray).skip(1L).collect(Collectors.joining("\n * "));
                    }
                    String string = "The models has been imported.\n\nAccuracy according to test data: " + RtDataFormat.toPercent(RtDataFormat.toNumberFloat(stringArray[0])) + "." + (String)object + "\n\nClick `Finish` to complete the import.";
                    BreezeOptionDialog.showDialog(this.this$0.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "ONNX Model Imported", string);
                }
            }, "Importing");
        }
    }

    public static Pair<File, File> trainUsingExternalScriptFile(BreezeProgressManager breezeProgressManager, AbstractRuntimeModel abstractRuntimeModel, String string, String string2, String string3) {
        File file = FileHelper.createTempFileInWorkspace("csv");
        File file2 = FileHelper.createTempFileInWorkspace("csv");
        File file3 = FileHelper.getTempFileWithoutCreation("onnx");
        File file4 = FileHelper.getTempFileWithoutCreation("json");
        abstractRuntimeModel.saveTrainingData(breezeProgressManager, file, false);
        abstractRuntimeModel.saveTestData(breezeProgressManager, file2, false);
        breezeProgressManager.setIndeterminate(true);
        breezeProgressManager.setInfoText("Training using python script");
        PythonHelper.executePythonScriptWithParams(breezeProgressManager, string3, string, string2, file, file2, file3, file4);
        breezeProgressManager.setIndeterminate(false);
        breezeProgressManager.addConsoleText("\nTraining complete!");
        return Pair.of((Object)file3, (Object)file4);
    }

    private void setResultsFromExternalTraining(File file, Analyse analyse, AbstractRuntimeModel abstractRuntimeModel) {
        if (file.exists()) {
            String string;
            try {
                string = Files.readString(file.toPath());
            }
            catch (IOException iOException) {
                Logg.warn((String)"Error reading model training information", (Object[])new Object[]{iOException});
                return;
            }
            BasicAnalyse.ModelType modelType = analyse.getModelMethod().getType();
            AbstractRuntimeModel.RuntimeResultList runtimeResultList = new AbstractRuntimeModel.RuntimeResultList(new JSONObject(string), modelType, true);
            abstractRuntimeModel.setRuntimeResults(runtimeResultList);
        }
    }
}

