/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.PythonHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.TabPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.TrainingDataPanel;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PythonModelTrainingPanel
extends AbstractViewPanel
implements TabPanel.Tab {
    private final AbstractRuntimeModel model;
    private final AbstractRuntimeModel.RuntimeSettings transientSettings;
    private final BreezeComboBoxInputField<String> pythonInterpreterComboBox;
    private final BreezeComboBoxInputField<ListItem> modelSelectorComboBox;
    private BreezeLabel noResultsLabel;
    private TrainingDataPanel trainingDataPanel;

    public PythonModelTrainingPanel(AbstractRuntimeModel abstractRuntimeModel, AbstractRuntimeModel.RuntimeSettings runtimeSettings) {
        this.model = abstractRuntimeModel;
        this.transientSettings = runtimeSettings;
        this.setLayout(new GridBagLayout());
        AbstractRuntimeModel.RuntimeSettings runtimeSettings2 = abstractRuntimeModel.getRuntimeSettings();
        int n = 0;
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, n, new Insets(0, 0, 0, 0));
        List<String> list = PythonHelper.getInstalledPythonVersions();
        String string2 = runtimeSettings2.interpreter;
        if (StringUtils.isNotEmpty((CharSequence)runtimeSettings2.customInterpreter)) {
            string2 = runtimeSettings2.customInterpreter;
            list.add(string2);
        }
        if (StringUtils.isEmpty((CharSequence)string2)) {
            runtimeSettings.interpreter = string2 = (String)list.stream().findFirst().orElse(null);
        }
        this.pythonInterpreterComboBox = new BreezeComboBoxInputField<String>("Python interpreter", list, string2, BreezeInputFieldHelper.Format.OneRow);
        this.pythonInterpreterComboBox.setChangedListener(string -> {
            runtimeSettings.interpreter = string;
        });
        this.pythonInterpreterComboBox.setLabelWidth(120);
        this.add(this.pythonInterpreterComboBox, gridBagConstraints);
        gridBagConstraints = GridBagHelper.create(1, n, new Insets(0, 0, 0, 0));
        this.add(EntryMainHelper.createButton("browse", "", "material/file_open", () -> this.browseInterpreter(this.getFileFromString(runtimeSettings.customInterpreter))), gridBagConstraints);
        gridBagConstraints = GridBagHelper.create(2, n++, new Insets(0, 0, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        BreezePanel breezePanel = new BreezePanel();
        breezePanel.setPreferredSize(new Dimension(800, 0));
        this.add(breezePanel, gridBagConstraints);
        gridBagConstraints = GridBagHelper.create(0, n, new Insets(10, 0, 0, 0));
        this.modelSelectorComboBox = new BreezeComboBoxInputField("Models");
        this.modelSelectorComboBox.setLabelWidth(120);
        this.modelSelectorComboBox.setChangedListener(listItem -> {
            runtimeSettings.scriptFile = listItem.getFile().getAbsolutePath();
        });
        this.setModelFiles(this.modelSelectorComboBox);
        if (StringUtils.isEmpty((CharSequence)runtimeSettings.scriptFile) && this.modelSelectorComboBox.getItemCount() > 0) {
            runtimeSettings.scriptFile = this.modelSelectorComboBox.getSelectedItem().getFile().getAbsolutePath();
        }
        this.add(this.modelSelectorComboBox, gridBagConstraints);
        gridBagConstraints = GridBagHelper.create(1, n++, new Insets(10, 0, 0, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add(EntryMainHelper.createButton("browse", "", "material/file_open", () -> this.browseScriptFile(this.getFileFromString(runtimeSettings.scriptFile))), gridBagConstraints);
        gridBagConstraints = GridBagHelper.create(0, n++, new Insets(10, 0, 0, 0));
        List<AbstractRuntimeModel.RuntimeResult> list2 = abstractRuntimeModel.getRuntimeResults().results;
        if (!list2.isEmpty() && StringHelper.equalsIgnoreCase((String)list2.getFirst().algorithmName, (String)"external")) {
            this.trainingDataPanel = new TrainingDataPanel(list2.getFirst());
            this.add(this.trainingDataPanel, gridBagConstraints);
        } else {
            gridBagConstraints.insets = new Insets(25, 0, 0, 0);
            this.noResultsLabel = new BreezeLabel("Select interpreter and script file and click on the 'Train model' button below to start external python model training script", true, 16);
            this.add(this.noResultsLabel, gridBagConstraints);
        }
        this.add(new BreezePanel(), GridBagHelper.createLast(n, new Insets(0, 0, 0, 0)));
    }

    private File getFileFromString(String string) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            return new File(string);
        }
        return FileHelper.newNonExistingFile();
    }

    private void setModelFiles(BreezeComboBoxInputField<ListItem> breezeComboBoxInputField) {
        String string = this.model.getRuntimeSettings().scriptFile;
        boolean bl = true;
        try {
            for (File file : Objects.requireNonNull(Paths.get(SettingsManager.getBreezeInstallFolder(), "Runtime", "ExampleCode", "TrainPythonModel").toFile().listFiles())) {
                if (StringHelper.startsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)"utils") || !FileHelper.getFileExtension(file).equals("py")) continue;
                ListItem listItem = new ListItem(file.getName() + " [Builtin]", file);
                breezeComboBoxInputField.addItem(listItem);
                if (!file.getAbsolutePath().equals(string)) continue;
                bl = false;
                breezeComboBoxInputField.setSelectedItem(listItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && StringUtils.isNotEmpty((CharSequence)string)) {
            breezeComboBoxInputField.addSeparator();
            File[] fileArray = new File(string);
            ListItem listItem = new ListItem(fileArray.getName(), (File)fileArray);
            breezeComboBoxInputField.addItem(listItem);
            breezeComboBoxInputField.setSelectedItem(listItem);
        }
        if (breezeComboBoxInputField.getSelectedItem() == null && breezeComboBoxInputField.getItemCount() > 0) {
            breezeComboBoxInputField.setSelectedItemWithoutListeners(breezeComboBoxInputField.getItemAt(0));
        }
    }

    private void browseInterpreter(File file) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Open file", (Component)((Object)this));
        if (this.model.getRuntimeSettings().customInterpreter != null) {
            if (file.exists() && file.isFile()) {
                jopensaveDialog2.setSelectedFile(file);
            } else if (file.exists() && file.isDirectory()) {
                jopensaveDialog2.setCurrentDirectory(file);
            } else if (file.getParentFile() != null && file.getParentFile().exists() && file.getParentFile().isDirectory()) {
                jopensaveDialog2.setCurrentDirectory(file.getParentFile());
            }
        }
        jopensaveDialog2.setPreview(null, false);
        jopensaveDialog2.setAcceptAllFileFilterUsed(true);
        if (jopensaveDialog2.openshow()) {
            this.transientSettings.setCustomInterpreter(jopensaveDialog2.getSelectedFile().getAbsolutePath());
            this.pythonInterpreterComboBox.addItem(this.transientSettings.customInterpreter);
            this.pythonInterpreterComboBox.setSelectedItemWithoutListeners(this.transientSettings.customInterpreter);
        }
    }

    private void browseScriptFile(File file) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Open file", (Component)((Object)this));
        if (this.model.getRuntimeSettings().scriptFile != null) {
            if (file.exists() && file.isFile()) {
                jopensaveDialog2.setSelectedFile(file);
            } else if (file.exists() && file.isDirectory()) {
                jopensaveDialog2.setCurrentDirectory(file);
            } else if (file.getParentFile() != null && file.getParentFile().exists() && file.getParentFile().isDirectory()) {
                jopensaveDialog2.setCurrentDirectory(file.getParentFile());
            }
        }
        jopensaveDialog2.setPreview(null, false);
        jopensaveDialog2.addChoosableFileFilter((FileFilter)new FileParameter.ExtensionFilter("py", "Python script file (*.py)"));
        if (jopensaveDialog2.openshow()) {
            this.transientSettings.setScriptFile(jopensaveDialog2.getSelectedFile().getAbsolutePath());
            ListItem listItem = new ListItem(jopensaveDialog2.getSelectedFile().getName(), jopensaveDialog2.getSelectedFile());
            this.modelSelectorComboBox.addItem(listItem);
            this.modelSelectorComboBox.setSelectedItemWithoutListeners(listItem);
        }
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public AbstractViewPanel getPanel() {
        return this;
    }

    @Override
    public String getType() {
        return "pythonTraining";
    }

    public void showPythonTrainingLog(AbstractRuntimeModel.RuntimeResult runtimeResult, JTextPane jTextPane) {
        if (this.trainingDataPanel != null) {
            this.remove(this.trainingDataPanel);
        }
        if (this.noResultsLabel != null) {
            this.remove(this.noResultsLabel);
        }
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, 2, new Insets(10, 0, 0, 0));
        this.trainingDataPanel = new TrainingDataPanel(runtimeResult);
        this.add(this.trainingDataPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jTextPane);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(jPanel, true);
        Dimension dimension = new Dimension(800, 600);
        breezeScrollPane.setPreferredSize(dimension);
        breezeScrollPane.setMaximumSize(dimension);
        breezeScrollPane.setMinimumSize(dimension);
        breezeScrollPane.scrollToBottom();
        gridBagConstraints = GridBagHelper.create(1, 2, new Insets(10, 0, 0, 0));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.add(breezeScrollPane, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public String toString() {
        return "Python";
    }

    public static class ListItem {
        String DisplayName;
        private File file;

        public ListItem(String string, File file) {
            this.setDisplayName(string);
            this.setFile(file);
        }

        public String toString() {
            return this.DisplayName;
        }

        @Generated
        public void setDisplayName(String string) {
            this.DisplayName = string;
        }

        @Generated
        public void setFile(File file) {
            this.file = file;
        }

        @Generated
        public String getDisplayName() {
            return this.DisplayName;
        }

        @Generated
        public File getFile() {
            return this.file;
        }
    }
}

