/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.PythonHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.RuntimeSampleModel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class SampleModelRuntimePanelStep
extends ViewContainer
implements WizardStep {
    private final ViewClass viewClass;

    public SampleModelRuntimePanelStep(BreezeMainPanel breezeMainPanel, PPClass pPClass, Analyse analyse, RuntimeSampleModel runtimeSampleModel, WizardStep.WizardControlCallback wizardControlCallback) {
        super(breezeMainPanel, false);
        this.viewClass = new ViewClass("Model", "Train one class", this, pPClass);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 5));
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        jPanel.add(EntryMainHelper.createButton("trainButton", "Train", "applychanges", () -> this.train(breezeMainPanel, runtimeSampleModel, wizardControlCallback)));
        jPanel.add(new BreezeSeparator(1, 4, 60));
        jPanel.add(new BreezeInputField.Number("Min score value", runtimeSampleModel.getCriticalValues().getDcrit(), "", textActionEvent -> {
            runtimeSampleModel.getCriticalValues().setCutOffLow(textActionEvent.getValueFloat());
            runtimeSampleModel.getCriticalValues().setDcrit(textActionEvent.getValueFloat());
        }));
    }

    private void train(final BreezeMainPanel breezeMainPanel, final RuntimeSampleModel runtimeSampleModel, final WizardStep.WizardControlCallback wizardControlCallback) {
        final File file = FileHelper.createTempFileInWorkspace("csv");
        final File file2 = FileHelper.createTempFileInWorkspace("csv");
        final File file3 = FileHelper.getTempFileWithoutCreation("onnx");
        final File file4 = FileHelper.getTempFileWithoutCreation("json");
        final File[] fileArray = new File[1];
        wizardControlCallback.setEnabled(false);
        BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(this){

            @Override
            public void runAction() {
                Object object;
                Properties properties = new Properties();
                properties.put("obsheader", "false");
                properties.put("header", "false");
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                AbstractDataMatrix abstractDataMatrix = runtimeSampleModel.getTrainingData(breezeProgressManager);
                abstractDataMatrix.save((ProgressManager)breezeProgressManager, file.getAbsolutePath(), "csv", properties);
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select file", (Component)breezeMainPanel);
                jopensaveDialog2.setSelectedFile(runtimeSampleModel.getScriptFile());
                List<String> list = PythonHelper.getInstalledPythonVersions();
                String[] stringArray = new String[1];
                if (!list.isEmpty()) {
                    object = new JPanel(new GridBagLayout());
                    ((JComponent)object).setBorder(EvinceBorderFactory.createEvinceBorder((String)"Python settings"));
                    ((Container)object).add((Component)new JLabel("Interpreter"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
                    JComboBox<Object> jComboBox = new JComboBox<Object>(list.toArray());
                    jComboBox.addActionListener(actionEvent -> {
                        stringArray[0] = (String)jComboBox.getSelectedItem();
                    });
                    jComboBox.setSelectedIndex(0);
                    ((JComponent)object).setPreferredSize(new Dimension(150, 0));
                    ((Container)object).add(jComboBox, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
                    jopensaveDialog2.setAccessory((JComponent)object);
                }
                object = new FileParameter.ExtensionFilter("py", "Python script file (*.py)");
                jopensaveDialog2.addChoosableFileFilter((FileFilter)object);
                jopensaveDialog2.setFileFilter((FileFilter)object);
                if (jopensaveDialog2.openshow()) {
                    fileArray[0] = jopensaveDialog2.getSelectedFile();
                    breezeProgressManager.setIndeterminate(true);
                    breezeProgressManager.setInfoText("Training using python script");
                    PythonHelper.executePythonScriptWithParams(breezeProgressManager, null, fileArray[0].getAbsolutePath(), stringArray[0], file, file2, file3, file4);
                    breezeProgressManager.setIndeterminate(false);
                    breezeProgressManager.getContentPane().getProgressBar().setVisible(false);
                    if (breezeProgressManager.isAborted()) {
                        breezeProgressManager.addConsoleText("\nWARNING: Training aborted");
                    } else {
                        breezeProgressManager.addConsoleText("\nTraining complete!");
                    }
                }
            }

            @Override
            public void actionComplete() {
                if (file3.exists() && file3.length() > 0L) {
                    runtimeSampleModel.setNewOnnxFile(file3);
                    runtimeSampleModel.setScriptFile(fileArray[0]);
                    runtimeSampleModel.setTrainingJsonFile(file4);
                    wizardControlCallback.setEnabled(true);
                }
            }
        }, "Training");
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }
}

