/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.ml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;

public class TrainingDataPanel
extends JPanel {
    public TrainingDataPanel(AbstractRuntimeModel.RuntimeResult runtimeResult) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        BreezeLabel breezeLabel = new BreezeLabel(RtDataFormat.toString(runtimeResult.accuracy.getFirst()), false, 14);
        BreezeLabel breezeLabel2 = new BreezeLabel(RtDataFormat.toString(runtimeResult.accuracyTest), false, 14);
        BreezeLabel breezeLabel3 = new BreezeLabel(RtDataFormat.toString(runtimeResult.crossValidationResult), false, 14);
        String string = runtimeResult.runtimeInSeconds < 1.0 ? " second" : " seconds";
        BreezeLabel breezeLabel4 = new BreezeLabel(RtDataFormat.toString(runtimeResult.runtimeInSeconds) + string, false, 14);
        BreezeLabel breezeLabel5 = new BreezeLabel(runtimeResult.displayName, false, 14);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        BreezeLabel breezeLabel6 = new BreezeLabel("Accuracy:", false, 14);
        breezeLabel6.setPreferredSize(new Dimension(120, breezeLabel.getPreferredSize().height));
        this.add((Component)breezeLabel6, gridBagConstraints);
        this.add((Component)new BreezeLabel("Accuracy Test:", false, 14), gridBagConstraints);
        if (runtimeResult.crossValidationResult > 0.0) {
            this.add((Component)new BreezeLabel("Cross Validation Result:", false, 14), gridBagConstraints);
        }
        this.add((Component)new BreezeLabel("Runtime:", false, 14), gridBagConstraints);
        this.add((Component)new BreezeLabel("Name:", false, 14), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)breezeLabel, gridBagConstraints);
        this.add((Component)breezeLabel2, gridBagConstraints);
        if (runtimeResult.crossValidationResult > 0.0) {
            this.add((Component)breezeLabel3, gridBagConstraints);
        }
        this.add((Component)breezeLabel4, gridBagConstraints);
        this.add((Component)breezeLabel5, gridBagConstraints);
        this.setOpaque(false);
    }

    public static void main(String[] stringArray) {
        JSONObject jSONObject = new JSONObject("{\n    \"AlgorithmName\": \"RandomForest\",\n    \"DisplayName\": \"Random Forest Classifier\",\n    \"ModelType\": \"EXTERNAL\",\n    \"Accuracy\": \"0.95\",\n    \"RuntimeInSeconds\": 25.67,\n    \"AccuracyTest\": 0.96,\n    \"CrossValidationResults\": 0.95\n}\n");
        TrainingDataPanel trainingDataPanel = new TrainingDataPanel(new AbstractRuntimeModel.RuntimeResult(jSONObject));
        JFrame jFrame = new JFrame("Training Data Viewer");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(trainingDataPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

