/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;

public class SelectInformationPanel
extends EntrySettingsPanel.SettingsSidePanel {
    private final InteractionPreviewPanel previewPanel;
    private final boolean trainTest;
    private final JLabel informationLabel = new JLabel("Information");
    private final JPanel informationPanel = new JPanel();
    private final JPanel previewHolderPanel = new JPanel();
    private final BreezeLabelField totalLabel = new BreezeLabelField("Total", 80, "0", 0);
    private final BreezeLabelField includedLabel = new BreezeLabelField("Included", 80, "0", 0);
    private final BreezeLabelField trainLabel = new BreezeLabelField("Train", 80, "0", 0);
    private final BreezeLabelField testLabel = new BreezeLabelField("Test", 80, "0", 0);
    private final BreezeLabelField selectedLabel = new BreezeLabelField("Selected", 80, "0", 0);
    private BreezeTablePanel tablePanel;

    public SelectInformationPanel() {
        this(false, false, null, null);
    }

    public SelectInformationPanel(boolean bl, boolean bl2, Entry entry, Model model) {
        this(bl, bl2, 10, null, entry, model);
    }

    public SelectInformationPanel(boolean bl, boolean bl2, int n, InformationDetailCallback informationDetailCallback, Entry entry, Model model) {
        super(new GridBagLayout());
        this.trainTest = bl2;
        this.initComponents(n, informationDetailCallback);
        this.previewPanel = new InteractionPreviewPanel(Workflow.getWorkflow(entry), model);
        this.previewHolderPanel.add((Component)this.previewPanel, "Center");
        this.previewHolderPanel.setVisible(bl);
        this.trainLabel.setVisible(bl2);
        this.testLabel.setVisible(bl2);
        this.informationPanel.setOpaque(false);
    }

    public void enableInteraction(PPEntryMainInterface pPEntryMainInterface) {
        this.previewPanel.enableInteraction(pPEntryMainInterface);
    }

    public void setData(Measurement measurement, List<Sample> list) {
        this.previewPanel.setData(measurement, list);
    }

    public void setData(List<Sample> list) {
        this.previewPanel.selectSamples(list);
    }

    public void previewSettingsFromWorkflow(Workflow workflow) {
        if (workflow != null) {
            this.previewPanel.setShowObjectBorder(workflow.getObjectBorder());
        }
    }

    public void updateInformation(BreezeTablePanel breezeTablePanel) {
        final BreezeTable breezeTable = breezeTablePanel.getTable();
        if (this.tablePanel != breezeTablePanel) {
            this.tablePanel = breezeTablePanel;
            breezeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                final /* synthetic */ SelectInformationPanel this$0;
                {
                    this.this$0 = selectInformationPanel;
                }

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    this.this$0.selectedLabel.setValue(breezeTable.getSelectedRowCount());
                }
            });
        }
        int n = breezeTable.getRowCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            BreezeIntervalClass breezeIntervalClass = (BreezeIntervalClass)breezeTable.getValueAt(i, 0);
            if (!breezeIntervalClass.isIncluded()) continue;
            ++n2;
            if (!this.trainTest) continue;
            SelectSamplePanelStep.SampleClass sampleClass = (SelectSamplePanelStep.SampleClass)breezeIntervalClass;
            if (sampleClass.getTest().isIncluded()) {
                ++n4;
                continue;
            }
            ++n3;
        }
        this.totalLabel.setValue(n);
        this.includedLabel.setValue(n2);
        this.trainLabel.setValue(n3);
        this.testLabel.setValue(n4);
        this.selectedLabel.setValue(breezeTable.getSelectedRowCount());
    }

    private void initComponents(int n, InformationDetailCallback informationDetailCallback) {
        this.informationPanel.setLayout(new GridBagLayout());
        this.informationLabel.setFont(new Font("Tahoma", 0, 18));
        this.informationLabel.setForeground(new Color(150, 150, 150));
        this.informationLabel.setText("Information");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n, 20, 0, 0);
        this.informationPanel.add((Component)this.informationLabel, gridBagConstraints);
        if (informationDetailCallback != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(n, 0, 0, 10);
            this.informationPanel.add((Component)EntryMainHelper.createSmallTextButton("Details", () -> informationDetailCallback.onClick()), gridBagConstraints);
        }
        this.addLabel(this.totalLabel, 1);
        this.addLabel(this.includedLabel, 2);
        this.addLabel(this.trainLabel, 3);
        this.addLabel(this.testLabel, 4);
        this.addLabel(this.selectedLabel, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.informationPanel.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.informationPanel, gridBagConstraints);
        this.previewHolderPanel.setOpaque(false);
        this.previewHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.previewHolderPanel, gridBagConstraints);
    }

    private void addLabel(BreezeLabelField breezeLabelField, int n) {
        breezeLabelField.setNameHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.informationPanel.add((Component)breezeLabelField, gridBagConstraints);
    }

    public void setInformationDimension(Dimension dimension) {
        this.informationPanel.setPreferredSize(dimension);
    }

    public void setSegmentationLevel(int n, String string) {
        this.previewPanel.setSegmentationLevel(n, string);
    }

    public static interface InformationDetailCallback {
        public void onClick();
    }
}

