/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailFile;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectInformationPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.map.common.error.ErrorHandler;

public class SelectMeasurementPanelStep
extends AbstractViewPanel
implements WizardStep {
    final int includeColumn = 0;
    private BreezeTablePanel measurementTablePanel;
    private JLabel propertiesLabel;
    private JPanel propertiesPanel;
    private JTextArea textArea;
    private final SelectInformationPanel selectInformationPanel;
    private final ViewClass viewClass;
    private final Analyse analyse;
    private final SampleModel model;

    public SelectMeasurementPanelStep(AbstractModelWizard abstractModelWizard, Analyse analyse, SampleModel sampleModel) {
        super(abstractModelWizard);
        this.analyse = analyse;
        this.model = sampleModel;
        this.initComponents();
        this.viewClass = new ViewClass("Measurements", "Select representative measurements", this);
        this.textArea.setText("Select representative measurements for segmentation");
        this.propertiesLabel.setVisible(false);
        this.measurementTablePanel.getTable().setSelectionMode(2);
        this.measurementTablePanel.initTable(new SelectMeasurementTableModel(), null, false);
        this.measurementTablePanel.addRowHeader();
        this.measurementTablePanel.addIntervalListener(new int[]{0}, () -> this.updateIncludedInformation());
        this.selectInformationPanel = new SelectInformationPanel(true, false, analyse, sampleModel);
        this.selectInformationPanel.previewSettingsFromWorkflow(Workflow.getWorkflow(analyse));
        this.setLeftSettingsPanel(this.selectInformationPanel);
        this.setRightSettingsPanel(new SelectSamplePanelStep.VariableSettingsPanel(abstractModelWizard, this.measurementTablePanel, analyse, sampleModel));
        ArrayList<MeasurementClass> arrayList = new ArrayList<MeasurementClass>();
        for (AnalyseSpectralGroup analyseSpectralGroup : MeasurementDataSource.getSortedGroups(analyse.getGroups())) {
            for (Measurement measurement : MeasurementDataSource.getSortedMeasurements(analyseSpectralGroup)) {
                if (!measurement.hasData()) continue;
                arrayList.add(new MeasurementClass(measurement));
            }
        }
        this.measurementTablePanel.setTableList(arrayList, arrayList.isEmpty() ? null : arrayList.get(0));
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        if (this.measurementTablePanel.getTable().getRowCount() == 0) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No measurement", "No measurements are available");
            return WizardStep.LeaveResult.Failed;
        }
        if (!this.hasIncluded()) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No measurements included", "At least one measurement must be included");
            return WizardStep.LeaveResult.Failed;
        }
        return WizardStep.LeaveResult.Ok;
    }

    private boolean hasIncluded() {
        BreezeTable breezeTable = this.measurementTablePanel.getTable();
        for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
            BreezeIntervalClass breezeIntervalClass = (BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
            if (!breezeIntervalClass.isIncluded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getType() {
        return "PPSelectMeasurementPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    private void initComponents() {
        this.textArea = new JTextArea();
        this.propertiesPanel = new JPanel();
        this.propertiesLabel = new JLabel();
        this.measurementTablePanel = new BreezeTablePanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Description");
        jLabel.setFont(new Font("Tahoma", 0, 18));
        jLabel.setForeground(new Color(150, 150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Tahoma", 0, 18));
        this.textArea.setLineWrap(true);
        this.textArea.setRows(1);
        this.textArea.setText("Text");
        this.textArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.textArea, gridBagConstraints);
        this.propertiesPanel.setOpaque(false);
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.propertiesLabel.setFont(new Font("Tahoma", 0, 18));
        this.propertiesLabel.setForeground(new Color(150, 150, 150));
        this.propertiesLabel.setText("Measurements");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.propertiesPanel.add((Component)this.propertiesLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(EntryMainHelper.createButton("Include", "include", () -> this.changedIncluded(true)));
        jPanel.add(EntryMainHelper.createButton("Exclude", "exclude", () -> this.changedIncluded(false)));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("Evenly Spread", "checklist_rtl", () -> BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), this.mainpanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Select evenly spread", "Enter number of measurements to include", String.valueOf(Math.min(this.analyse.getDefaultNumberOfSamples(), this.measurementTablePanel.getTable().getRowCount())), breezeActionEvent -> {
            int n = Integer.parseInt(breezeActionEvent.result().toString());
            this.selectEvenly(n);
        })));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("Select all", "selectall", () -> this.measurementTablePanel.getTable().setRowSelectionInterval(0, this.measurementTablePanel.getTable().getRowCount() - 1)));
        jPanel.add(EntryMainHelper.createButton("Deselect all", "deselectall", () -> this.measurementTablePanel.getTable().clearSelection()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.propertiesPanel.add((Component)jPanel, gridBagConstraints);
        this.measurementTablePanel.setName("measurementTable");
        this.measurementTablePanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.propertiesPanel.add((Component)((Object)this.measurementTablePanel), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.propertiesPanel, gridBagConstraints);
    }

    private void changedIncluded(boolean bl) {
        for (Object e : this.measurementTablePanel.getSelectedValues()) {
            ((BreezeIntervalClass)e).setIncluded(bl);
        }
        this.measurementTablePanel.repaint();
        this.updateIncludedInformation();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    private void selectEvenly(int n) {
        int n2;
        BreezeTable breezeTable = this.measurementTablePanel.getTable();
        int n3 = ((JTable)((Object)breezeTable)).getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ((BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(n2, 0)).setIncluded(false);
        }
        n2 = Math.min(n3, n);
        double d = (double)n3 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            int n4 = (int)((double)i * d);
            ((BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(n4, 0)).setIncluded(true);
        }
        this.updateIncludedInformation();
    }

    private void updateIncludedInformation() {
        this.selectInformationPanel.updateInformation(this.measurementTablePanel);
    }

    public ArrayList<Measurement> getIncludedMeasurements() {
        BreezeTable breezeTable = this.measurementTablePanel.getTable();
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
            MeasurementClass measurementClass = (MeasurementClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
            if (!measurementClass.isIncluded()) continue;
            arrayList.add(measurementClass.measurement);
        }
        return arrayList;
    }

    @Override
    public void settingsToggled(boolean bl, boolean bl2) {
        List list = this.measurementTablePanel.getSelectedValues();
        if (list.size() > 0) {
            this.selectInformationPanel.setData(((MeasurementClass)list.get((int)0)).measurement, new ArrayList<Sample>());
        }
        SwingUtilities.invokeLater(() -> this.measurementTablePanel.updateColumnWidth());
    }

    @Override
    public boolean showRightSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        if (this.model.hasIncludedMeasurements()) {
            BreezeTable breezeTable = this.measurementTablePanel.getTable();
            for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
                MeasurementClass measurementClass = (MeasurementClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
                measurementClass.setIncluded(this.model.isMeasurementIncluded(measurementClass.getMeasurement()));
            }
        } else {
            this.selectEvenly(this.analyse.getDefaultNumberOfSamples());
        }
        this.updateIncludedInformation();
        SwingUtilities.invokeLater(() -> this.settingsToggled(true, true));
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            return WizardPanel.LeaveProgressAction.createWithCancel(this.getFrame(), wizardControlCallback, breezeProgressManager -> {
                ArrayList<Measurement> arrayList = this.getIncludedMeasurements();
                if (arrayList.isEmpty()) {
                    throw new ErrorHandler.InformationMessageException("At least one measurement must be included");
                }
                this.model.loadDatasetWithMeasurements(breezeProgressManager, arrayList);
            }, "Loading measurements");
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    private class SelectMeasurementTableModel
    extends DefaultBreezeTableImpl {
        private SelectMeasurementTableModel() {
        }

        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            MeasurementClass measurementClass = (MeasurementClass)object;
            Measurement measurement = measurementClass.measurement;
            Group group = measurement.getParent();
            vector.add(measurementClass);
            vector.add((Object)new ThumbnailFile(measurement.getCustomImageFile(), measurement));
            vector.add(group);
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            return Arrays.asList("Measurement", "Thumbnail", "Group");
        }

        @Override
        public void putVOIntoFields(Object object) {
            SelectMeasurementPanelStep.this.selectInformationPanel.setData(((MeasurementClass)object).measurement, new ArrayList<Sample>());
        }
    }

    public static class MeasurementClass
    extends BreezeIntervalClass {
        public Measurement measurement;

        public MeasurementClass(Measurement measurement) {
            this.measurement = measurement;
        }

        @Override
        public String toString() {
            return this.measurement.toString();
        }

        public Measurement getMeasurement() {
            return this.measurement;
        }
    }
}

