/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.SampleVariableOrIdentifier;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeHtmlPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.main.model.table.SummaryViewContainer;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.SelectBinningPanel;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.BreezeIndexIntervalClass;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectHelper;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectInformationPanel;

public class SelectSamplePanelStep
extends AbstractViewPanel
implements WizardStep {
    private final int includeColumn = 0;
    private final int testColumn = 1;
    private final BreezeTablePanel sampleTablePanel = new BreezeTablePanel();
    private final SelectInformationPanel selectInformationPanel;
    private final ViewClass viewClass;
    private final Model.ModelWithSample model;
    private int segmentationLevel = -1;
    private SegmentationNodeList segmentationNodes;
    private String segmentationHashId;

    public SelectSamplePanelStep(AbstractModelWizard abstractModelWizard, Analyse analyse, Model.ModelWithSample modelWithSample) {
        super(abstractModelWizard);
        this.model = modelWithSample;
        this.initComponents();
        this.viewClass = new ViewClass("Samples", "Select samples", this);
        BreezeTable breezeTable = this.sampleTablePanel.getTable();
        ((JTable)((Object)breezeTable)).setSelectionMode(2);
        this.sampleTablePanel.initTable(new SampleTableModel(analyse), null, false);
        this.sampleTablePanel.setSortable(true);
        this.sampleTablePanel.addRowHeader();
        if (modelWithSample instanceof Model.IClassificationModel) {
            Model.IClassificationModel iClassificationModel = (Model.IClassificationModel)((Object)modelWithSample);
            this.selectInformationPanel = new SelectInformationPanel(true, true, 10, () -> this.lambda$new$0(iClassificationModel, (JTable)((Object)breezeTable), abstractModelWizard), analyse, modelWithSample);
        } else {
            this.selectInformationPanel = new SelectInformationPanel(true, true, analyse, modelWithSample);
        }
        this.selectInformationPanel.previewSettingsFromWorkflow(Workflow.getWorkflow(analyse));
        this.sampleTablePanel.addIntervalListener(new int[]{0, 1}, () -> this.selectInformationPanel.updateInformation(this.sampleTablePanel));
        ((JTable)((Object)breezeTable)).setDefaultRenderer(ClassificationFactor.class, new ClassificationFactorCellRenderer());
        this.setLeftSettingsPanel(this.selectInformationPanel);
        this.setRightSettingsPanel(new VariableSettingsPanel(abstractModelWizard, this.sampleTablePanel, analyse, modelWithSample));
        this.setSegmentationLevel(analyse, new SegmentationIdentifier(modelWithSample.getSegmentationLevel(), modelWithSample.getSegmentationHashId()));
    }

    private int[][] getClassSummary(JTable jTable, CategoryFactor categoryFactor) {
        int[][] nArray = new int[categoryFactor.getMaxIndex() + 1][3];
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            SampleClass sampleClass = (SampleClass)jTable.getValueAt(i, 0);
            Sample sample = sampleClass.getSample();
            Float f = sample.getVariableValue(categoryFactor);
            if (f == null) continue;
            if (sampleClass.isIncluded()) {
                if (sampleClass.getTest().isIncluded()) {
                    int[] nArray2 = nArray[f.intValue()];
                    nArray2[1] = nArray2[1] + 1;
                    continue;
                }
                int[] nArray3 = nArray[f.intValue()];
                nArray3[0] = nArray3[0] + 1;
                continue;
            }
            int[] nArray4 = nArray[f.intValue()];
            nArray4[2] = nArray4[2] + 1;
        }
        return nArray;
    }

    private void setSegmentationLevel(Analyse analyse, SegmentationIdentifier segmentationIdentifier) {
        if (this.segmentationLevel != segmentationIdentifier.Level || this.segmentationHashId != segmentationIdentifier.HashId) {
            this.segmentationLevel = segmentationIdentifier.Level;
            this.segmentationHashId = segmentationIdentifier.HashId;
            this.selectInformationPanel.setSegmentationLevel(this.segmentationLevel, this.segmentationHashId);
            Group group = analyse.getFirstGroup();
            if (group != null) {
                this.segmentationNodes = group.getParent().getSegmentationNodes(this.segmentationLevel, this.segmentationHashId);
            } else {
                this.segmentationNode = null;
            }
            ArrayList<SampleClass> arrayList = new ArrayList<SampleClass>();
            int n = 0;
            for (AnalyseSpectralGroup analyseSpectralGroup : MeasurementDataSource.getSortedGroups(analyse.getGroups())) {
                for (Measurement measurement : MeasurementDataSource.getSortedMeasurements(analyseSpectralGroup)) {
                    if (!measurement.hasData()) continue;
                    for (Sample sample : measurement.getSamples(new SegmentationIdentifier(this.segmentationLevel, this.segmentationHashId))) {
                        arrayList.add(new SampleClass(sample, n++));
                    }
                }
            }
            this.sampleTablePanel.setTableList(arrayList, arrayList.isEmpty() ? null : arrayList.get(0));
        } else {
            this.sampleTablePanel.updateTable();
        }
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        if (this.sampleTablePanel.getTable().getRowCount() == 0) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No samples", "No samples are available");
            return WizardStep.LeaveResult.Failed;
        }
        if (!this.hasIncluded()) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No samples included", "At least one sample must be included");
            return WizardStep.LeaveResult.Failed;
        }
        return WizardStep.LeaveResult.Ok;
    }

    private boolean hasIncluded() {
        BreezeTable breezeTable = this.sampleTablePanel.getTable();
        for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
            BreezeIntervalClass breezeIntervalClass = (BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
            if (!breezeIntervalClass.isIncluded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getType() {
        return "PPSelectSamplePanel";
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(EntryMainHelper.createButton("Include", "include", () -> this.changeIncluded(true, false)));
        jPanel.add(EntryMainHelper.createButton("Include Only", "include_only", () -> this.changeIncluded(true, true)));
        jPanel.add(EntryMainHelper.createButton("Exclude", "exclude", () -> this.changeIncluded(false, false)));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("includeTestButton", "Test", "testset", () -> this.changedTrainTest(true)));
        jPanel.add(EntryMainHelper.createButton("includeTrainButton", "Train", "trainset", () -> this.changedTrainTest(false)));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("Select all", "selectall", () -> this.sampleTablePanel.getTable().setRowSelectionInterval(0, this.sampleTablePanel.getTable().getRowCount() - 1)));
        jPanel.add(EntryMainHelper.createButton("Deselect all", "deselectall", () -> this.sampleTablePanel.getTable().clearSelection()));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("Balance Train", "open_modal", this::balanceModelTrainData));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.sampleTablePanel.setName("sampleTable");
        this.sampleTablePanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)((Object)this.sampleTablePanel), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(jPanel2, gridBagConstraints);
    }

    public static JComponent createSeparatorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.setMinimumSize(new Dimension(10, 35));
        jPanel.setPreferredSize(new Dimension(10, 35));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new BreezeSeparator.Vertical(), gridBagConstraints);
        return jPanel;
    }

    private void balanceModelTrainData() {
        BreezeOptionDialog.showDialog(this.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Balance", "", (AbstractBreezeCustomPanel)new BalancePanel(), null, breezeActionEvent -> {
            final BalancePanel balancePanel = (BalancePanel)breezeActionEvent.getBreezeCustomPanel();
            BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
                final /* synthetic */ SelectSamplePanelStep this$0;
                {
                    this.this$0 = selectSamplePanelStep;
                }

                @Override
                public void runAction() throws Exception {
                    this.this$0.model.updateSampleInclusionAndTestFlags(this.getProgressManager(), this.this$0.getSampleIndex(), this.this$0.getTestIndex());
                    this.this$0.model.balanceTrainData(this.getProgressManager(), balancePanel.isIncludedOnly(), balancePanel.isRandom());
                    this.this$0.updateTableAndInformation();
                    this.this$0.repaint();
                }
            }, "Balancing model", 0);
        });
    }

    private void changedTrainTest(boolean bl) {
        for (Object e : this.sampleTablePanel.getSelectedValues()) {
            ((SampleClass)e).test.setIncluded(bl);
        }
        this.sampleTablePanel.repaint();
        this.selectInformationPanel.updateInformation(this.sampleTablePanel);
    }

    private void changeIncluded(boolean bl, boolean bl2) {
        if (bl2) {
            BreezeTable breezeTable = this.sampleTablePanel.getTable();
            for (int i = 0; i < breezeTable.getRowCount(); ++i) {
                ((BreezeIntervalClass)breezeTable.getValueAt(i, 0)).setIncluded(false);
            }
        }
        for (Object e : this.sampleTablePanel.getSelectedValues()) {
            ((BreezeIntervalClass)e).setIncluded(bl);
        }
        this.sampleTablePanel.repaint();
        this.selectInformationPanel.updateInformation(this.sampleTablePanel);
    }

    @Override
    public void settingsToggled(boolean bl, boolean bl2) {
        this.showPreviewOnSelected();
        SwingUtilities.invokeLater(this.sampleTablePanel::updateColumnWidth);
    }

    private void showPreviewOnSelected() {
        List list = this.sampleTablePanel.getSelectedValues();
        if (list.size() > 0) {
            ArrayList<Sample> arrayList = new ArrayList<Sample>();
            for (Object e : list) {
                Sample sample = ((SampleClass)e).sample;
                arrayList.add(sample);
            }
            this.selectInformationPanel.setData(arrayList);
        }
    }

    @Override
    public boolean showRightSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        this.setSegmentationLevel(this.model.getAnalyse(), this.model.getSegmentationIdentifier());
        this.updateTableAndInformation();
        SwingUtilities.invokeLater(() -> this.settingsToggled(true, true));
    }

    private void updateTableAndInformation() {
        BreezeTable breezeTable = this.sampleTablePanel.getTable();
        for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
            SampleClass sampleClass = (SampleClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
            sampleClass.setIncluded(this.model.sampleIsIncluded(sampleClass.getIndex()));
            sampleClass.getTest().setIncluded(this.model.sampleIsIncludedForTest(sampleClass.getIndex()));
        }
        this.selectInformationPanel.updateInformation(this.sampleTablePanel);
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            return WizardPanel.LeaveProgressAction.create(this.getFrame(), wizardControlCallback, breezeProgressManager -> {
                this.model.updateSampleInclusionAndTestFlags(breezeProgressManager, this.getSampleIndex(), this.getTestIndex());
                this.model.applyChanges(breezeProgressManager);
            }, "Applying changes");
        }
        return WizardStep.LeaveResult.Ok;
    }

    private boolean[] getSampleIndex() {
        return SelectHelper.getIndex((JTable)((Object)this.sampleTablePanel.getTable()), 0);
    }

    private boolean[] getTestIndex() {
        return SelectHelper.getIndex((JTable)((Object)this.sampleTablePanel.getTable()), 1);
    }

    protected boolean anyTestObjects() {
        for (boolean bl : this.getTestIndex()) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    private /* synthetic */ void lambda$new$0(Model.IClassificationModel iClassificationModel, JTable jTable, AbstractModelWizard abstractModelWizard) {
        CategoryFactor categoryFactor = iClassificationModel.getFactor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table style=\"width:100%\"><tr>");
        stringBuffer.append("<th style=\"width:20%\" align=\"left\">Name</th><th align=\"right\">Train</th><th align=\"right\">Test</th><th align=\"right\">Excluded</th></tr>");
        int[][] nArray = this.getClassSummary(jTable, categoryFactor);
        int[] nArray2 = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                int n = j;
                nArray2[n] = nArray2[n] + nArray[i][j];
            }
        }
        for (CatClass catClass : categoryFactor.getAllClasses()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(catClass.getName());
            stringBuffer.append("</td>");
            int n = categoryFactor.getClassIndex(catClass);
            for (int i = 0; i < 3; ++i) {
                stringBuffer.append("<td align=\"right\">");
                int n2 = nArray[n][i];
                if (n2 > 0) {
                    stringBuffer.append(n2);
                    stringBuffer.append(" (" + RtDataFormat.toPercent((float)n2 / (float)nArray2[i]) + ")");
                }
                stringBuffer.append("</td >");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("<tr></tr><tr><th align=\"left\">Total</th>");
        for (int i = 0; i < nArray2.length; ++i) {
            stringBuffer.append("<th align=\"right\">");
            stringBuffer.append(nArray2[i]);
            stringBuffer.append("</th>");
        }
        stringBuffer.append("</tr></table>");
        BreezeOptionDialog.showDialog(abstractModelWizard.getFrame(), abstractModelWizard.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, categoryFactor.getName() + " summary", "", (AbstractBreezeCustomPanel)new BreezeHtmlPanel(stringBuffer.toString()), null, null);
    }

    private class SampleTableModel
    extends DefaultBreezeTableImpl {
        private final Analyse analyse;

        public SampleTableModel(Analyse analyse) {
            this.analyse = analyse;
        }

        @Override
        public Vector createVOVector(Object object) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            SampleClass sampleClass = (SampleClass)object;
            Sample sample = sampleClass.sample;
            Measurement measurement = sample.measurement();
            Group group = measurement.getParent();
            vector.add(sampleClass);
            vector.add(sampleClass.test);
            if (this.analyse.getModelMethod().isClassification()) {
                vector.add(new ClassificationFactor((Model.IClassificationModel)((Object)SelectSamplePanelStep.this.model)));
            }
            vector.add(measurement);
            vector.add((Object)new ThumbnailSample(measurement.getCustomImageFile(), measurement, sample));
            vector.add(group);
            if (SelectSamplePanelStep.this.segmentationNodes != null && SelectSamplePanelStep.this.segmentationNodes.size() > 1) {
                object2 = SelectSamplePanelStep.this.segmentationNodes.getSegmentation(sample.getSegmentationHashId());
                if (object2 != null) {
                    vector.add(object2);
                } else {
                    vector.add("N/A");
                }
            }
            for (ThingWithName thingWithName : group.getIdentifiers()) {
                vector.add(thingWithName);
            }
            for (ThingWithName thingWithName : group.getCategoryFactors()) {
                vector.add(thingWithName);
            }
            for (ThingWithName thingWithName : group.getPropertyFactors()) {
                vector.add(thingWithName);
            }
            object2 = this.analyse.getSegmentationIdentifier();
            MeasurementTableModel.addSampleDescriptors(vector, sample, false, measurement, group, MeasurementTableModel.TableSource.Table, (SegmentationIdentifier)object2);
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList("Sample", "Type"));
            if (this.analyse.getModelMethod().isClassification()) {
                arrayList.add("Model classes");
            }
            arrayList.addAll(Arrays.asList("Measurement", "Thumbnail", "Group"));
            if (SelectSamplePanelStep.this.segmentationNodes != null && SelectSamplePanelStep.this.segmentationNodes.size() > 1) {
                arrayList.add("Segmentation");
            }
            Group group = this.analyse.getFirstGroup();
            for (Object object : group.getIdentifiers()) {
                arrayList.add(((Identifier)object).getName());
            }
            for (Object object : group.getCategoryFactors()) {
                arrayList.add(((Factor)object).toString());
            }
            for (Object object : group.getPropertyFactors()) {
                arrayList.add(((PropertyFactor)object).toString());
            }
            SegmentationIdentifier segmentationIdentifier = this.analyse.getSegmentationIdentifier();
            for (Object e : MeasurementTableModel.getDescriptorNodes(group.getParent(), false, MeasurementTableModel.TableSource.Table, segmentationIdentifier)) {
                arrayList.add(ReportUtils.serializeHeader(e));
            }
            return arrayList;
        }

        @Override
        public void valueChanged() {
            SelectSamplePanelStep.this.showPreviewOnSelected();
        }
    }

    public static class ClassificationFactor {
        private final Model.IClassificationModel model;

        public ClassificationFactor(Model.IClassificationModel iClassificationModel) {
            this.model = iClassificationModel;
        }

        public CatClass getRootClass(Sample sample) {
            CategoryFactor categoryFactor = this.model.getFactor();
            if (sample != null && categoryFactor != null) {
                CategoryFactor categoryFactor2;
                SampleValues sampleValues = sample.getSampleValues();
                CatClass catClass = this.getCatClass(sampleValues, categoryFactor);
                if (catClass == null && (categoryFactor2 = sample.measurement().getWorkflow().getCategoryFactors().getByName(categoryFactor.getName())) != null) {
                    catClass = this.getCatClass(sampleValues, categoryFactor2);
                }
                return catClass;
            }
            return null;
        }

        private CatClass getCatClass(SampleValues sampleValues, CategoryFactor categoryFactor) {
            CatClass catClass;
            Float f = sampleValues.getValue(categoryFactor);
            if (f != null && (catClass = categoryFactor.getClassByValueIdx(f.intValue())) != null) {
                return categoryFactor.getRootClass(catClass);
            }
            return null;
        }

        public int compare(Sample sample, Sample sample2) {
            CategoryFactor categoryFactor = this.model.getFactor();
            if (categoryFactor != null) {
                CatClass catClass = this.getRootClass(sample);
                CatClass catClass2 = this.getRootClass(sample2);
                return Float.compare(categoryFactor.getClassIndex(catClass), categoryFactor.getClassIndex(catClass2));
            }
            return 0;
        }
    }

    public static class ClassificationFactorCellRenderer
    extends BreezeTableCellRenderer {
        private Sample sample;
        private CatClass rootClass = null;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CatClass catClass;
            this.sample = ClassificationFactorCellRenderer.getSampleAt(jTable, n);
            this.rootClass = null;
            String string = "-";
            if (object instanceof ClassificationFactor && (catClass = ((ClassificationFactor)object).getRootClass(this.sample)) != null && catClass.isIncluded()) {
                this.rootClass = catClass;
                string = this.rootClass.getName();
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            CatClass.render(graphics, this.rootClass, this.getHeight());
            this.getUI().paint(graphics, this);
        }
    }

    public static class VariableSettingsPanel
    extends DefaultSettingsPanel {
        public VariableSettingsPanel(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, Analyse analyse, Model model) {
            DefaultSettingsPanel.SectionCollapsePanel sectionCollapsePanel = this.addCollapseSection("Selection", false);
            JPanel jPanel = sectionCollapsePanel.getPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By interval", "selectby/Select_By_Interval", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByInterval(breezeMainPanel, breezeTablePanel)), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By class", "selectby/Select_By_Class", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByClass(breezeMainPanel, breezeTablePanel, analyse.getWorkflow())), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By value", "selectby/Select_By_Value", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByValue(breezeMainPanel, breezeTablePanel, analyse.getWorkflow())), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By random", "selectby/Select_By_Random", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByRandom(breezeMainPanel, breezeTablePanel)), gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By binning", "selectby/Select_By_Random", () -> BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Selection by binning", "", (AbstractBreezeCustomPanel)new SelectBinningPanel(), null, breezeActionEvent -> ((SelectBinningPanel)breezeActionEvent.getBreezeCustomPanel()).apply(model, breezeTablePanel.getTable()))), gridBagConstraints5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("Included", "selectby/Select_By_Included", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectIncExc(breezeMainPanel, breezeTablePanel, true)), gridBagConstraints6);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("Excluded", "selectby/Select_By_Excluded", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectIncExc(breezeMainPanel, breezeTablePanel, false)), gridBagConstraints7);
        }
    }

    public static class SampleClass
    extends BreezeIndexIntervalClass {
        public final Sample sample;
        public final TrainTestClass test;

        public SampleClass(Sample sample, int n) {
            super(n);
            this.sample = sample;
            this.test = new TrainTestClass(this, n);
            this.test.setIncluded(false);
        }

        @Override
        public String toString() {
            return this.sample.getRecursiveName(Sample.DefaultSampleLabel.IDX);
        }

        public TrainTestClass getTest() {
            return this.test;
        }

        public Sample getSample() {
            return this.sample;
        }

        public Measurement getMeasurement() {
            return this.sample.measurement();
        }
    }

    public static class TrainTestClass
    extends BreezeIndexIntervalClass {
        public static final Color trainColor = RtPerfectSpread.getColorFromString("#00AE7E");
        public static final Color testColor = new Color(0, 155, 255, 100);
        private final BreezeIntervalClass parent;

        public TrainTestClass(BreezeIntervalClass breezeIntervalClass, int n) {
            super(n);
            this.parent = breezeIntervalClass;
        }

        @Override
        public String toString() {
            return this.isIncluded() ? "Test" : "Train";
        }

        @Override
        public BreezeIntervalClass getParent() {
            return this.parent;
        }

        @Override
        public Color getIntervalColor() {
            return testColor;
        }
    }

    public static class BalancePanel
    extends AbstractBreezeCustomPanel {
        private final BreezeRadioButton includeOnly;
        private final BreezeRadioButton includeAll;
        private final BreezeRadioButton intervalSelection;
        private final BreezeRadioButton randomSelection;

        public BalancePanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)new BreezeLabel("Balance train data:", false, 16), GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(10, 0, 0, 0)));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.includeOnly = new BreezeRadioButton("Only included", buttonGroup, true);
            this.add((Component)this.includeOnly, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 20, 0, 0)));
            this.includeAll = new BreezeRadioButton("All", buttonGroup, false);
            this.add((Component)this.includeAll, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 20, 0, 0)));
            this.add((Component)new BreezeLabel("Selection:", false, 16), GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(10, 0, 0, 0)));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.intervalSelection = new BreezeRadioButton("Interval", buttonGroup2, true);
            this.add((Component)this.intervalSelection, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 20, 0, 0)));
            this.randomSelection = new BreezeRadioButton("Random", buttonGroup2, false);
            this.add((Component)this.randomSelection, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 20, 0, 0)));
        }

        public boolean isIncludedOnly() {
            return this.includeOnly.isSelected();
        }

        public boolean isRandom() {
            return this.randomSelection.isSelected();
        }

        @Override
        public Object getResult() {
            return null;
        }
    }

    public static class SampleTablePopup
    extends MouseAdapter {
        private final EntryMainPanel mainPanel;
        private final BreezeTablePanel tablePanel;

        public SampleTablePopup(EntryMainPanel entryMainPanel, BreezeTablePanel breezeTablePanel) {
            this.mainPanel = entryMainPanel;
            this.tablePanel = breezeTablePanel;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n;
                BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.mainPanel.getFrame(), BreezeType.Analyse.getColor());
                BreezeFrame breezeFrame = this.mainPanel.getFrame();
                BreezeTable breezeTable = this.tablePanel.getTable();
                Object object = ((JTable)((Object)breezeTable)).getValueAt(0, n = ((JTable)((Object)breezeTable)).columnAtPoint(mouseEvent.getPoint()));
                if (object instanceof SampleVariableOrIdentifier) {
                    SampleVariableOrIdentifier sampleVariableOrIdentifier = (SampleVariableOrIdentifier)object;
                    if (sampleVariableOrIdentifier instanceof PropertyFactor) {
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Show summary", () -> BreezeOptionDialog.showDialog(breezeFrame, this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Summary", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new SummaryViewContainer(this.mainPanel, object, this.tablePanel.getEntry(), "Property"), this.tablePanel.getEntry(), 0.85), null, null));
                    }
                    if (sampleVariableOrIdentifier instanceof CategoryFactor) {
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Summary", () -> this.lambda$mousePressed$1(sampleVariableOrIdentifier, (JTable)((Object)breezeTable), breezeFrame));
                    }
                }
                if (breezeContextMenu.resize()) {
                    breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                    breezeContextMenu.setPositionLater(mouseEvent);
                }
            }
        }

        private int[] getClassSummary(JTable jTable, CategoryFactor categoryFactor) {
            int[] nArray = new int[categoryFactor.getMaxIndex() + 1];
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                Sample sample = ((SampleClass)jTable.getValueAt(i, 0)).getSample();
                Float f = sample.getVariableValue(categoryFactor);
                if (f == null) continue;
                int n = f.intValue();
                nArray[n] = nArray[n] + 1;
            }
            return nArray;
        }

        private /* synthetic */ void lambda$mousePressed$1(SampleVariableOrIdentifier sampleVariableOrIdentifier, JTable jTable, BreezeFrame breezeFrame) {
            CategoryFactor categoryFactor = (CategoryFactor)sampleVariableOrIdentifier;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<table style=\"width:100%\"><tr>");
            stringBuffer.append("<th style=\"width:40%\" align=\"left\">Name</th><th align=\"right\">Number</th>");
            stringBuffer.append("<th align=\"right\">Percent</th></tr>");
            int[] nArray = this.getClassSummary(jTable, categoryFactor);
            for (CatClass catClass : categoryFactor.getAllClasses()) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append(catClass.getName());
                stringBuffer.append("</td><td align=\"right\">");
                int n = nArray[categoryFactor.getClassIndex(catClass)];
                stringBuffer.append(n);
                stringBuffer.append("</td ><td align=\"right\">");
                stringBuffer.append(RtDataFormat.toPercent((float)n / (float)jTable.getRowCount()));
                stringBuffer.append("</td></tr>");
            }
            stringBuffer.append("<tr></tr><tr><th align=\"left\">Total</th><th align=\"right\">");
            stringBuffer.append(jTable.getRowCount());
            stringBuffer.append("</th></tr></table>");
            BreezeOptionDialog.showDialog(breezeFrame, this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, categoryFactor.getName() + " summary", "", (AbstractBreezeCustomPanel)new BreezeHtmlPanel(stringBuffer.toString()), null, null);
        }
    }
}

