/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.function.FunctionDescriptor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeColorChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.SegmentationPanel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.test.stubs.AnalyseWithoutIO;

public class SelectVariablePanelStep
extends AbstractViewPanel
implements WizardStep {
    private boolean multipleselection = true;
    private Model.ModelStatus modelStatus = Model.ModelStatus.Normal;
    private JLabel categoryLabel;
    private BreezeList categoryList;
    private JPanel categoryPanel;
    private BreezeButton selectAllButton;
    private BreezeButton deselectAllButton;
    private JPanel emptyPanel;
    private BreezeScrollPane propertiesListScrollPane;
    private BreezeScrollPane categoryListScrollPane;
    private JLabel optionsLabel;
    private JPanel optionsPanel;
    private JLabel propertiesLabel;
    private BreezeList propertiesList;
    private JPanel propertiesPanel;
    private JTextArea textArea;
    private JPanel toolBarPanel;
    private JPanel toolBarPanel1;
    private final ViewClass viewClass;
    private final Analyse analyse;
    private final Model.ModelWithSample model;
    private final SegmentationPanel segmentationPanel;

    public SelectVariablePanelStep(AbstractModelWizard abstractModelWizard, Analyse analyse, Model.ModelWithSample modelWithSample, String string) {
        super(abstractModelWizard);
        Cloneable cloneable;
        boolean bl2;
        Object object;
        this.analyse = analyse;
        this.model = modelWithSample;
        this.initComponents();
        this.viewClass = new ViewClass("Variables", "Select segmentation and variable(s)", this);
        this.propertiesLabel.setText(string);
        this.optionsLabel.setVisible(false);
        this.optionsPanel.setVisible(false);
        this.textArea.setText("Make sure to have at least three measurements before starting model calibration (data in " + analyse.getConvertTo().format().toLowerCase() + ")");
        Workflow workflow = analyse.getWorkflow();
        this.segmentationPanel = new SegmentationPanel(BreezeInputFieldHelper.Format.OneRow, bl -> {
            this.updatePropertiesListWithDescriptorNodes(workflow, new SegmentationIdentifier(this.getSegmentationLevel(), this.getSegmentationHashId()));
            this.selectVariablesFromModel();
            this.propertiesList.repaint();
        });
        this.addOption(this.segmentationPanel);
        this.segmentationPanel.updateSegmentations(workflow);
        this.segmentationPanel.setSegmentationLevel(modelWithSample.getSegmentationLevel());
        this.segmentationPanel.setSegmentationHashId(modelWithSample.getSegmentationHashId());
        if (analyse.hasModel()) {
            object = analyse.getWorkflow().getAnalyseTree().getSegmentationNodes(analyse.getSegmentationIdentifier());
            bl2 = object.stream().anyMatch(FunctionTreeNode::isEnabled);
            if (object.isEmpty() || !bl2) {
                cloneable = new GridBagConstraints();
                ((GridBagConstraints)cloneable).gridy = 1;
                ((GridBagConstraints)cloneable).gridwidth = 0;
                ((GridBagConstraints)cloneable).fill = 2;
                ((GridBagConstraints)cloneable).insets = new Insets(5, 100, 0, 0);
                this.segmentationPanel.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Warning, "Previous segmentations for the model is " + (object.isEmpty() ? "missing" : "disabled"), "Warning"), cloneable);
            }
        }
        if (analyse.getModelMethod().hasCrossvalidation()) {
            this.addOption(CrossvalidationConfigPanel.create(analyse));
        }
        this.propertiesLabel.setText("Properties or Descriptors");
        this.propertiesList.setCellRenderer(new LabelEntry(200, 14){

            @Override
            protected String getText(Object object) {
                if (object instanceof DescriptorTreeNode) {
                    return "D: " + ((DescriptorTreeNode)object).getAliasOrNodeString();
                }
                return super.getText(object);
            }
        });
        object = analyse.getModelMethod();
        bl2 = ((BasicAnalyse.ModelMethod)((Object)object)).isClassification();
        this.multipleselection = ((BasicAnalyse.ModelMethod)((Object)object)).supportMultipleVariables();
        this.propertiesList.setToggle(this.multipleselection);
        this.selectAllButton.setVisible(this.multipleselection);
        this.deselectAllButton.setVisible(this.multipleselection);
        if (bl2) {
            this.updateModelStatus(Model.ModelStatus.Reload);
        }
        cloneable = new ArrayList();
        for (FactorOrDescriptor factorOrDescriptor : modelWithSample.getAllVariables(this.getSegmentationLevel(), this.getSegmentationHashId())) {
            if (!(factorOrDescriptor instanceof Factor)) continue;
            cloneable.add(analyse.cloneForModel(workflow, (Factor)factorOrDescriptor, this.getSegmentationLevel()));
        }
        this.propertiesList.setModel((List)((Object)cloneable));
        this.updatePropertiesListWithDescriptorNodes(workflow, new SegmentationIdentifier(this.getSegmentationLevel(), this.getSegmentationHashId()));
        this.propertiesListScrollPane.setLineBorder();
        this.categoryLabel.setText("Classes");
        this.categoryList.setName("categorylist");
        this.categoryList.setMinimumSize(new Dimension(300, 0));
        this.categoryList.setCellRenderer(new LabelEntry(200, 32, 16, true));
        this.categoryList.setLayoutOrientation(0);
        this.categoryPanel.setVisible(bl2);
        this.categoryListScrollPane.setLineBorder();
    }

    private void updatePropertiesListWithDescriptorNodes(Workflow workflow, SegmentationIdentifier segmentationIdentifier) {
        Object object = this.propertiesList.getModel();
        if (object instanceof ArrayListModel) {
            ArrayListModel arrayListModel = (ArrayListModel)object;
            object = arrayListModel.getList().iterator();
            while (object.hasNext()) {
                if (!(object.next() instanceof DescriptorTreeNode)) continue;
                object.remove();
            }
            object = workflow.getSegmentationLevelDescriptorNodes(segmentationIdentifier, false);
            if (this.analyse.getModelMethod().isQuantification()) {
                Iterator<DescriptorTreeNode> iterator = object.iterator();
                while (iterator.hasNext()) {
                    DescriptorTreeNode descriptorTreeNode = iterator.next();
                    if (!SelectVariablePanelStep.supportDescriptorAsProperty(descriptorTreeNode)) continue;
                    arrayListModel.addElement(descriptorTreeNode);
                }
                this.propertiesList.setModel(arrayListModel);
            } else if (this.analyse.getModelMethod().isClassification()) {
                Iterator<DescriptorTreeNode> iterator = object.iterator();
                while (iterator.hasNext()) {
                    DescriptorTreeNode descriptorTreeNode = iterator.next();
                    if (!SelectVariablePanelStep.supportDescriptorAsCategory(descriptorTreeNode)) continue;
                    arrayListModel.addElement(descriptorTreeNode);
                }
                this.propertiesList.setModel(arrayListModel);
            }
        }
    }

    public static boolean supportDescriptorAsCategory(DescriptorTreeNode descriptorTreeNode) {
        return false;
    }

    public static boolean supportDescriptorAsProperty(DescriptorTreeNode descriptorTreeNode) {
        return descriptorTreeNode.getFunction() instanceof FunctionDescriptor;
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        String string;
        boolean bl = this.analyse.getModelMethod().isClassification();
        String string2 = bl ? "classes" : "values";
        String string3 = bl ? "category" : "property";
        String string4 = string = bl ? "categories" : "properties";
        if (this.propertiesList.getItemCount() == 0) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No " + string, "No " + string + " are available");
            return WizardStep.LeaveResult.Failed;
        }
        if (this.propertiesList.getSelectedIndex() < 0) {
            if (this.multipleselection) {
                BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No " + string + " selected", "At least one " + string3 + " must be selected");
            } else {
                BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No " + string3 + " selected", "One " + string3 + " must be selected");
            }
            return WizardStep.LeaveResult.Failed;
        }
        List list = this.propertiesList.getSelectedValuesList();
        if (!this.multipleselection && list.size() > 1) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "One " + string3, "Only one " + string3 + " must be selected");
            return WizardStep.LeaveResult.Failed;
        }
        for (Object e : list) {
            if (!(e instanceof Factor) || SelectVariablePanelStep.checkVariance(this.analyse, (FactorOrDescriptor)e, new SegmentationIdentifier(this.getSegmentationLevel(), this.getSegmentationHashId()))) continue;
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, String.valueOf(e) + " has no variance", "You must assign samples to different " + string2 + " in this " + string3 + " before you can continue");
            return WizardStep.LeaveResult.Failed;
        }
        return WizardStep.LeaveResult.Ok;
    }

    private static boolean checkVariance(Analyse analyse, FactorOrDescriptor factorOrDescriptor, SegmentationIdentifier segmentationIdentifier) {
        Float f = null;
        for (AnalyseSpectralGroup analyseSpectralGroup : analyse.getGroups()) {
            Group group = analyseSpectralGroup.getGroup();
            if (group == null) continue;
            for (Measurement measurement : group.getChildList()) {
                for (Sample sample : measurement.getSamples(segmentationIdentifier)) {
                    Float f2 = factorOrDescriptor.getValue(sample);
                    if (f2 == null) {
                        Factor factor = measurement.getWorkflow().getFactorHolder().getFactorByName(factorOrDescriptor.getName());
                        if (factor != null) {
                            f2 = factor.getValue(sample);
                        }
                        if (f2 == null) continue;
                    }
                    if (f == null) {
                        f = f2;
                        continue;
                    }
                    if (f.equals(f2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int[] getSelectedIndecies() {
        return this.propertiesList.getSelectedIndices();
    }

    public List<FactorOrDescriptor> getSelectedList() {
        return this.propertiesList.getSelectedValuesList();
    }

    public void addOption(JComponent jComponent) {
        this.optionsLabel.setVisible(true);
        this.optionsPanel.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.optionsPanel.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.optionsPanel.add((Component)jComponent, gridBagConstraints);
    }

    @Override
    public String getType() {
        return "SelectVariablePanelStep";
    }

    private void initComponents() {
        this.textArea = new JTextArea();
        this.propertiesPanel = new JPanel();
        this.propertiesLabel = new JLabel();
        this.toolBarPanel = new JPanel();
        this.propertiesListScrollPane = new BreezeScrollPane();
        this.propertiesList = new BreezeList();
        this.optionsPanel = new JPanel();
        this.emptyPanel = new JPanel();
        this.optionsLabel = new JLabel();
        this.categoryPanel = new JPanel();
        this.categoryLabel = new JLabel();
        this.toolBarPanel1 = new JPanel();
        this.categoryListScrollPane = new BreezeScrollPane();
        this.categoryList = new BreezeList();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Tahoma", 0, 16));
        this.textArea.setLineWrap(true);
        this.textArea.setRows(1);
        this.textArea.setText("Text");
        this.textArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.textArea, gridBagConstraints);
        this.propertiesPanel.setOpaque(false);
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.propertiesLabel.setFont(new Font("Tahoma", 0, 16));
        this.propertiesLabel.setForeground(new Color(150, 150, 150));
        this.propertiesLabel.setText("Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.propertiesPanel.add((Component)this.propertiesLabel, gridBagConstraints);
        this.toolBarPanel.setOpaque(false);
        this.selectAllButton = EntryMainHelper.createButton("Select all", "selectall", () -> this.propertiesList.selectAll());
        this.toolBarPanel.add(this.selectAllButton);
        this.deselectAllButton = EntryMainHelper.createButton("Deselect all", "deselectall", () -> this.propertiesList.clearSelection());
        this.toolBarPanel.add(this.deselectAllButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.propertiesPanel.add((Component)this.toolBarPanel, gridBagConstraints);
        this.propertiesList.setLayoutOrientation(2);
        this.propertiesList.setVisibleRowCount(0);
        this.propertiesList.addListSelectionListener(listSelectionEvent -> this.propertiesListValueChanged(listSelectionEvent));
        this.propertiesListScrollPane.setViewportView((Component)((Object)this.propertiesList));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.propertiesPanel.add((Component)this.propertiesListScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.propertiesPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.emptyPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.emptyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 20, 0);
        this.add(this.optionsPanel, gridBagConstraints);
        this.optionsLabel.setFont(new Font("Tahoma", 0, 16));
        this.optionsLabel.setForeground(new Color(150, 150, 150));
        this.optionsLabel.setText("Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add(this.optionsLabel, gridBagConstraints);
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryLabel.setFont(new Font("Tahoma", 0, 16));
        this.categoryLabel.setForeground(new Color(150, 150, 150));
        this.categoryLabel.setText("Category");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.categoryPanel.add((Component)this.categoryLabel, gridBagConstraints);
        this.toolBarPanel1.setOpaque(false);
        this.toolBarPanel1.add(EntryMainHelper.createButton("Include", "include", () -> {
            for (CatClass catClass : this.getSelectedClasses()) {
                catClass.setIncluded(true);
            }
            this.categoryList.repaint();
            this.updateModelStatus(Model.ModelStatus.Reset);
        }));
        this.toolBarPanel1.add(EntryMainHelper.createButton("excludeclass", "Exclude", "exclude", () -> {
            for (CatClass catClass : this.getSelectedClasses()) {
                if (catClass.isNoClass()) continue;
                catClass.setIncluded(false);
            }
            this.categoryList.repaint();
            this.updateModelStatus(Model.ModelStatus.Reload);
        }));
        this.toolBarPanel1.add(SelectSamplePanelStep.createSeparatorPanel());
        this.toolBarPanel1.add(EntryMainHelper.createButton("Group", "tab_group", () -> {
            CategoryFactor categoryFactor = (CategoryFactor)this.propertiesList.getSelectedValue();
            List<CatClass> list = this.getSelectedClasses();
            if (list.size() > 1) {
                BreezeOptionDialog.showDialog(this.getFrame(), this.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Group", "", (AbstractBreezeCustomPanel)new GroupPanel(categoryFactor, list), null, breezeActionEvent -> {
                    GroupPanel groupPanel = (GroupPanel)breezeActionEvent.getBreezeCustomPanel();
                    CatClass catClass = categoryFactor.group(list, breezeActionEvent.getInputText());
                    catClass.setColor(groupPanel.getColor());
                    this.categoryList.setModel(categoryFactor.getClasses());
                    this.updateModelStatus(Model.ModelStatus.Reload);
                });
            }
        }));
        this.toolBarPanel1.add(EntryMainHelper.createButton("Ungroup", "ungroup", () -> {
            CategoryFactor categoryFactor = (CategoryFactor)this.propertiesList.getSelectedValue();
            boolean bl = false;
            for (CatClass catClass : this.getSelectedClasses()) {
                if (!catClass.isGrouped()) continue;
                categoryFactor.ungroup(catClass);
                bl = true;
            }
            if (bl) {
                this.categoryList.setModel(categoryFactor.getClasses());
                this.updateModelStatus(Model.ModelStatus.Reset);
            }
        }));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.categoryPanel.add((Component)this.toolBarPanel1, gridBagConstraints);
        this.categoryList.setVisibleRowCount(0);
        this.categoryListScrollPane.setViewportView((Component)((Object)this.categoryList));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.categoryPanel.add((Component)this.categoryListScrollPane, gridBagConstraints);
        jPanel.add((Component)this.categoryPanel, "East");
    }

    private void updateModelStatus(Model.ModelStatus modelStatus) {
        if (modelStatus.ordinal() > this.modelStatus.ordinal()) {
            this.modelStatus = modelStatus;
        }
    }

    private List<CatClass> getSelectedClasses() {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        for (Object e : this.categoryList.getSelectedValuesList()) {
            CatClass catClass = (CatClass)e;
            if (catClass.isNoClass()) continue;
            arrayList.add(catClass);
        }
        return arrayList;
    }

    private void propertiesListValueChanged(ListSelectionEvent listSelectionEvent) {
        FactorOrDescriptor factorOrDescriptor = (FactorOrDescriptor)this.propertiesList.getSelectedValue();
        if (factorOrDescriptor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factorOrDescriptor;
            this.categoryList.setModel(categoryFactor.getClasses());
        }
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public void enterStep() {
        this.selectVariablesFromModel();
    }

    private void selectVariablesFromModel() {
        this.propertiesList.clearSelection();
        block0: for (int i = 0; i < this.propertiesList.getItemCount(); ++i) {
            FactorOrDescriptor factorOrDescriptor = (FactorOrDescriptor)this.propertiesList.getItemAt(i);
            for (FactorOrDescriptor factorOrDescriptor2 : this.model.getSelectedVariables()) {
                if (!factorOrDescriptor.getOrigUid().equals(factorOrDescriptor2.getOrigUid())) continue;
                this.propertiesList.addSelectionInterval(i, i);
                continue block0;
            }
        }
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            if (this.checkValidContent(wizardControlCallback).failed()) {
                return WizardStep.LeaveResult.Failed;
            }
            wizardControlCallback.setEnabled(false);
            return WizardPanel.LeaveProgressAction.create(this.getFrame(), wizardControlCallback, breezeProgressManager -> {
                try {
                    this.model.setVariables(this.getSelectedList());
                    this.model.setSegmentationLevel(breezeProgressManager, this.getSegmentationLevel(), this.getSegmentationHashId(), this.modelStatus);
                    this.model.createModel(breezeProgressManager);
                    this.modelStatus = Model.ModelStatus.Normal;
                }
                catch (Exception exception) {
                    this.modelStatus = Model.ModelStatus.Reset;
                    throw new RuntimeException("Failed to create model\n\nCause: " + exception.getMessage() + "\n\nStored model settings has been reset, please try again", exception);
                }
            }, "Loading measurements");
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public int getSegmentationLevel() {
        return this.segmentationPanel.getSegmentationLevel();
    }

    @Override
    public String getSegmentationHashId() {
        return this.segmentationPanel.getSegmentationHashId();
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Pixel Explore");
        jFrame.setDefaultCloseOperation(3);
        Breeze.setFrameIcons(jFrame);
        AnalyseWithoutIO analyseWithoutIO = new AnalyseWithoutIO("Test");
        analyseWithoutIO.getProperties().setPropertyLocal("modelling/cvFull", "true");
        analyseWithoutIO.getProperties().setPropertyLocal("modelling/cvType", "Leave-One-Out");
        analyseWithoutIO.getProperties().setPropertyLocal("modelling/cvGroups", "10");
        jFrame.getContentPane().setBackground(Color.black);
        jFrame.getContentPane().add(CrossvalidationConfigPanel.create(analyseWithoutIO));
        jFrame.setSize(1024, 768);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static class CrossvalidationConfigPanel
    extends JPanel {
        private final BreezeComboBoxInputField full;
        private final BreezeComboBoxInputField<CrossvalidationEnum> type;
        private final BreezeInputField.Number groups;
        private final BreezeComboBoxInputField<CategoryFactor> category;

        public CrossvalidationConfigPanel(Analyse analyse) {
            super(new GridBagLayout());
            this.setOpaque(false);
            XmlProperties xmlProperties = analyse.getProperties();
            this.full = new BreezeComboBoxInputField("Type", " ", BreezeInputFieldHelper.Format.OneRow);
            this.full.setLabelWidth(80);
            this.full.addItem("Partial");
            this.full.addItem("Full");
            this.full.setSelectedIndex(xmlProperties.getPropertyBoolLocal("modelling/cvFull", false) ? 1 : 0);
            this.full.setChangedListener(object -> xmlProperties.setPropertyLocal("modelling/cvFull", this.full.getSelectedIndex() == 0 ? "false" : "true"));
            this.groups = new BreezeInputField.Number("Groups", (double)xmlProperties.getPropertyIntLocal("modelling/cvGroups", 7), " ", textActionEvent -> xmlProperties.setPropertyLocal("modelling/cvGroups", String.valueOf(textActionEvent.getValueInt())));
            this.groups.addValidator(new NumericMinMaxValidator(1.0, 20.0));
            this.groups.setDefaultValue("7");
            this.groups.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.groups.setLabelWidth(80);
            this.category = new BreezeComboBoxInputField("Category", " ", BreezeInputFieldHelper.Format.OneRow);
            this.category.setLabelWidth(80);
            CategoryList categoryList = analyse.getWorkflow().getCategoryFactors();
            for (CategoryFactor object22 : categoryList) {
                this.category.addItem(object22);
            }
            this.category.setChangedListener(categoryFactor -> xmlProperties.setPropertyLocal("modelling/cvCategory", categoryFactor.getName()));
            CategoryFactor categoryFactor2 = categoryList.getByName(xmlProperties.getPropertyLocal("modelling/cvCategory", ""));
            if (categoryFactor2 != null) {
                this.category.setSelectedItem(categoryFactor2);
            } else if (this.category.getItemCount() > 0) {
                this.category.setSelectedIndex(0);
            }
            this.add((Component)this.full, GridBagHelper.create(this.getComponentCount(), new Insets(0, 0, 0, 0)));
            this.type = new BreezeComboBoxInputField("Exclusion by", " ", BreezeInputFieldHelper.Format.OneRow);
            this.type.setLabelWidth(80);
            for (CrossvalidationEnum crossvalidationEnum2 : CrossvalidationEnum.values()) {
                this.type.addItem(crossvalidationEnum2);
            }
            CrossvalidationEnum crossvalidationEnum3 = CrossvalidationEnum.fromEvinceName(xmlProperties.getPropertyLocal("modelling/cvType", "EvenlySpread"));
            this.type.setSelectedItem(crossvalidationEnum3);
            this.type.setChangedListener(crossvalidationEnum -> {
                this.updateVisible((CrossvalidationEnum)((Object)((Object)crossvalidationEnum)));
                xmlProperties.setPropertyLocal("modelling/cvType", crossvalidationEnum.getEvinceName());
            });
            GridBagConstraints gridBagConstraints = GridBagHelper.createLast(this.getComponentCount(), new Insets(12, 0, 0, 0));
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            this.add(this.type, gridBagConstraints);
            this.add((Component)this.groups, GridBagHelper.create(this.getComponentCount(), new Insets(12, 0, 0, 0)));
            this.add(this.category, GridBagHelper.create(this.getComponentCount(), new Insets(12, 0, 0, 0)));
            this.updateVisible(crossvalidationEnum3);
        }

        private void updateVisible(CrossvalidationEnum crossvalidationEnum) {
            this.groups.setVisible(crossvalidationEnum.showGroups());
            this.category.setVisible(crossvalidationEnum.equals((Object)CrossvalidationEnum.Category));
        }

        public static CollapsePanel create(Analyse analyse) {
            CollapsePanel collapsePanel = new CollapsePanel("");
            CrossvalidationConfigPanel crossvalidationConfigPanel = new CrossvalidationConfigPanel(analyse);
            collapsePanel.addPanel(new BreezeExternalLinkPanel((JComponent)crossvalidationConfigPanel, "cross-validation", false, true));
            collapsePanel.setCollapseCallback(bl -> collapsePanel.setTitle(crossvalidationConfigPanel.getTitle(bl)));
            collapsePanel.setTitle(crossvalidationConfigPanel.getTitle(collapsePanel.isExpanded()));
            return collapsePanel;
        }

        private String getTitle(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Crossvalidation");
            if (!bl) {
                stringBuffer.append(" (");
                stringBuffer.append(this.full.getSelectedItem());
                stringBuffer.append(", ");
                stringBuffer.append(this.groups.getValue());
                stringBuffer.append(" groups, ");
                stringBuffer.append(StringHelper.formatLabel(this.type.getSelectedItem().toString()));
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }

        public static enum CrossvalidationEnum {
            EvenlySpread,
            SequentialGroup("Group"),
            Category,
            Random,
            LeaveOneOut("Leave-one-out"),
            Stratified;

            private final String evinceName;

            private CrossvalidationEnum() {
                this.evinceName = this.name();
            }

            private CrossvalidationEnum(String string2) {
                this.evinceName = string2;
            }

            public String getEvinceName() {
                return this.evinceName;
            }

            public boolean showGroups() {
                return !this.equals((Object)Category) && !this.equals((Object)LeaveOneOut);
            }

            public String toString() {
                return StringHelper.formatLabel(this.name());
            }

            public static CrossvalidationEnum fromEvinceName(String string) {
                for (CrossvalidationEnum crossvalidationEnum : CrossvalidationEnum.values()) {
                    if (!crossvalidationEnum.getEvinceName().equalsIgnoreCase(string)) continue;
                    return crossvalidationEnum;
                }
                return EvenlySpread;
            }
        }
    }

    public static class GroupPanel
    extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
        private final BreezeInputField nameInputField = new BreezeInputField("Enter group name:", "", "");
        private final BreezeColorChooser colorInputField = new BreezeColorChooser(true);

        public GroupPanel(CategoryFactor categoryFactor, List<CatClass> list) {
            this.nameInputField.setValue(CategoryFactor.suggestName(list, ","));
            this.add((Component)this.nameInputField, GridBagHelper.create(this.getComponentCount(), new Insets(48, 24, 0, 24)));
            this.colorInputField.setSelectedItem(RtPerfectSpread.generateColor(categoryFactor.getMaxSize()));
            this.colorInputField.setMinimumSize(new Dimension(120, 30));
            this.colorInputField.setPreferredSize(new Dimension(120, 30));
            this.add((Component)this.colorInputField, GridBagHelper.createLeft(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.addEndBlock();
        }

        @Override
        public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
            breezeButton2.setText("Group");
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.nameInputField::requestFocusAndSelectAll);
        }

        @Override
        public String getResult() {
            return this.nameInputField.getValue();
        }

        public Color getColor() {
            return this.colorInputField.getSelectedColor();
        }
    }
}

