/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import lombok.Generated;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.SignalNoiseRatio;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.WavelengthSettingsPanel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.BreezeIndexIntervalClass;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectHelper;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectInformationPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.TransformationPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.WavelenghtPreviewPanel;

public class SelectWavelengthPanelStep
extends AbstractViewPanel
implements WizardStep {
    private final JPanel previewInnerPanel = new JPanel(new BorderLayout());
    private final TransformationPanel pretreatmentPanel;
    private final SelectInformationPanel selectInformationPanel;
    private final WavelenghtPreviewPanel.WavelengthBreezeTable wavelengthTablePanel = new WavelenghtPreviewPanel.WavelengthBreezeTable();
    private final WavelenghtPreviewPanel wavelenghtPreviewPanel;
    private final ViewClass viewClass;
    private final Model model;
    private final BreezeButton applyChangesButton;
    private final WavelengthTableModel tableModel;
    private final BreezeCheckBox snrCheckBox;
    private final BreezeButton saveButton;
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;

    public SelectWavelengthPanelStep(AbstractModelWizard abstractModelWizard, Analyse analyse, final Model model) {
        super(abstractModelWizard);
        Object object;
        this.model = model;
        Measurement measurement = analyse.getRecordGroupHolder().getFirstMeasurementWithData();
        if (measurement == null) {
            throw new RuntimeException("No measurement found in any configured Record Groups");
        }
        this.pretreatmentPanel = new TransformationPanel(!model.getAnalyse().getModelMethod().isRuntime(), true, false);
        this.wavelenghtPreviewPanel = new WavelenghtPreviewPanel(this, this.wavelengthTablePanel, analyse, model, this.pretreatmentPanel, measurement);
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        boolean bl2 = modelMethod.supportImportance();
        this.initComponents();
        this.viewClass = new ViewClass("Wavelengths", "Select wavelength and pretreatment", this);
        this.selectInformationPanel = new SelectInformationPanel(false, false, 6, null, analyse, model);
        this.selectInformationPanel.setInformationDimension(null);
        this.tableModel = new WavelengthTableModel(bl2, model::getWavelengthImportance);
        this.wavelengthTablePanel.initTable(this.tableModel, null, false);
        this.wavelengthTablePanel.addIntervalListener(new int[]{0}, () -> {
            this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
            this.wavelenghtPreviewPanel.repaint();
        });
        this.previewInnerPanel.setOpaque(false);
        this.previewInnerPanel.add((Component)this.wavelenghtPreviewPanel, "Center");
        ArrayList<WavelengthClass> arrayList = new ArrayList<WavelengthClass>();
        RawHeader rawHeader = measurement.rawFile().header();
        for (int i = 0; i < rawHeader.bandCount().value; ++i) {
            object = new WavelengthClass(rawHeader.bandNames().getFormated(i), i);
            ((BreezeIntervalClass)object).setIncluded(false);
            arrayList.add((WavelengthClass)object);
        }
        this.wavelengthTablePanel.setTableList(arrayList, arrayList.isEmpty() ? null : arrayList.getFirst());
        this.wavelengthTablePanel.getTable().addMouseListener(new WavelengthSettingsPanel.TableCellPopupAdapter(this.mainpanel.getFrame(), this.wavelengthTablePanel));
        this.applyChangesButton = EntryMainHelper.createApplyButton(abstractModelWizard, new ProgressAction(){

            @Override
            public void runAction() {
                SelectWavelengthPanelStep.this.applyChanges(this.getProgressManager());
                SelectWavelengthPanelStep.this.wavelengthTablePanel.repaint();
                SelectWavelengthPanelStep.this.wavelenghtPreviewPanel.update();
            }
        });
        this.saveButton = EntryMainHelper.createButton("Save", "file_save", () -> this.wavelengthTablePanel.save(analyse.getWorkflow().getName() + " - Wavelength"));
        this.snrCheckBox = new BreezeCheckBox("Show SNR", false, bl -> {
            if (bl) {
                BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
                    final /* synthetic */ SelectWavelengthPanelStep this$0;
                    {
                        this.this$0 = selectWavelengthPanelStep;
                    }

                    @Override
                    public void runAction() {
                        this.setInfoText("Calculating Signal-to-noise ratio");
                        this.this$0.tableModel.setSnr(SignalNoiseRatio.calculateMinSnr(model.getIncludedSampleList()));
                        this.this$0.wavelengthTablePanel.setTableList(this.this$0.wavelengthTablePanel.getTableList(), null, true);
                        this.this$0.wavelenghtPreviewPanel.update();
                    }
                }, "SNR");
            } else {
                this.tableModel.setSnr(null);
                this.wavelengthTablePanel.setTableList(this.wavelengthTablePanel.getTableList(), null, true);
                this.wavelenghtPreviewPanel.update();
            }
        });
        this.snrCheckBox.setToolTipText("Show Signal-to-noise ratio in table");
        WavelengthSettingsPanel wavelengthSettingsPanel = new WavelengthSettingsPanel(abstractModelWizard, this.wavelengthTablePanel, analyse);
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(wavelengthSettingsPanel);
        this.componentSectionPanel.initiate(this.mainpanel, model);
        this.componentSectionPanel.setVisible(!modelMethod.isRuntime() && modelMethod != BasicAnalyse.ModelMethod.SimcaClassification);
        object = wavelengthSettingsPanel.addSection(null);
        ((DefaultSettingsPanel.SectionPanel)object).addComponentHorizontal(this.selectInformationPanel);
        this.setRightSettingsPanel(wavelengthSettingsPanel);
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.applyChangesButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.saveButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.snrCheckBox);
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        if (this.wavelengthTablePanel.getTable().getRowCount() == 0) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No wavelength", "No wavelength are available");
            return WizardStep.LeaveResult.Failed;
        }
        if (!this.hasIncluded()) {
            BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No wavelength selected", "At least one wavelength must be included");
            return WizardStep.LeaveResult.Failed;
        }
        return WizardStep.LeaveResult.Ok;
    }

    private boolean hasIncluded() {
        return SelectHelper.hasIncluded((JTable)((Object)this.wavelengthTablePanel.getTable()));
    }

    @Override
    public String getType() {
        return "PPSelectSamplePanel";
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(EntryMainHelper.createButton("Include", "include", () -> this.changeIncluded(true, false)));
        jPanel.add(EntryMainHelper.createButton("Include Only", "include_only", () -> this.changeIncluded(true, true)));
        jPanel.add(EntryMainHelper.createButton("Exclude", "exclude", () -> this.changeIncluded(false, false)));
        jPanel.add(SelectSamplePanelStep.createSeparatorPanel());
        jPanel.add(EntryMainHelper.createButton("Select all", "selectall", () -> this.wavelengthTablePanel.getTable().setRowSelectionInterval(0, this.wavelengthTablePanel.getTable().getRowCount() - 1)));
        jPanel.add(EntryMainHelper.createButton("Deselect all", "deselectall", () -> this.wavelengthTablePanel.getTable().clearSelection()));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.wavelengthTablePanel.setName("wavelengthTable");
        this.wavelengthTablePanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)((Object)this.wavelengthTablePanel), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.pretreatmentPanel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        this.previewInnerPanel.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel3.add((Component)this.previewInnerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(jPanel3, gridBagConstraints);
    }

    private void changeIncluded(boolean bl, boolean bl2) {
        if (bl2) {
            BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
            for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
                ((BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(i, 0)).setIncluded(false);
            }
        }
        for (Object e : this.wavelengthTablePanel.getSelectedValues()) {
            ((BreezeIntervalClass)e).setIncluded(bl);
        }
        this.wavelengthTablePanel.repaint();
        this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
        this.wavelenghtPreviewPanel.repaint();
    }

    public boolean[] getWavelengthIndex() {
        BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
        int n = ((JTable)((Object)breezeTable)).getRowCount();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            WavelengthClass wavelengthClass = (WavelengthClass)((JTable)((Object)breezeTable)).getValueAt(i, 0);
            blArray[wavelengthClass.getIndex()] = wavelengthClass.isIncluded();
        }
        return blArray;
    }

    public Color getSelectionColor() {
        BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
        return ((JTable)((Object)breezeTable)).getSelectionBackground();
    }

    @Override
    public void enterStep() {
        BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
        for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
            WavelengthClass wavelengthClass = (WavelengthClass)((JTable)((Object)breezeTable)).getValueAt(i, this.wavelengthTablePanel.includeColumn);
            wavelengthClass.setIncluded(this.model.isWavelengthIndexIncluded(wavelengthClass.getIndex()));
        }
        this.pretreatmentPanel.setValues(this.model.getTransformations(), this.calculateIncluded(this.getWavelengthIndex()));
        this.wavelenghtPreviewPanel.update();
        this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
        this.componentSectionPanel.updateComponents();
    }

    private int calculateIncluded(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            ++n;
        }
        return n;
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            wizardControlCallback.setEnabled(false);
            return WizardPanel.LeaveProgressAction.create(this.getFrame(), wizardControlCallback, this::applyChanges, "Applying changes");
        }
        return WizardStep.LeaveResult.Ok;
    }

    private void applyChanges(BreezeProgressManager breezeProgressManager) {
        boolean[] blArray = this.getWavelengthIndex();
        this.model.updateIncludedWavelengths(blArray);
        for (ModelProperties.TransformationProperties transformationProperties : this.pretreatmentPanel.getTransformations()) {
            this.model.updateTransformation(transformationProperties);
        }
        this.model.applyChanges(breezeProgressManager);
        this.componentSectionPanel.updateComponents();
    }

    public void calculateSnr() {
        float[] fArray = null;
        HashMap<Measurement, SignalNoiseRatio> hashMap = new HashMap<Measurement, SignalNoiseRatio>();
        for (Sample sample : this.model.getIncludedSampleList()) {
            int n;
            Measurement measurement = sample.measurement();
            SignalNoiseRatio signalNoiseRatio = (SignalNoiseRatio)hashMap.get(measurement);
            if (signalNoiseRatio == null) {
                signalNoiseRatio = new SignalNoiseRatio(measurement);
                hashMap.put(measurement, signalNoiseRatio);
            }
            float[] fArray2 = sample.getSamplePath().getAverageProfile();
            FloatMatrix floatMatrix = signalNoiseRatio.calculate(fArray2);
            if (fArray == null) {
                fArray = new float[fArray2.length];
                for (n = 0; n < fArray2.length; ++n) {
                    fArray[n] = floatMatrix.get(n);
                }
                continue;
            }
            for (n = 0; n < fArray2.length; ++n) {
                fArray[n] = Math.min(fArray[n], floatMatrix.get(n));
            }
        }
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.componentSectionPanel.updateComponents();
        this.wavelenghtPreviewPanel.update();
        this.wavelengthTablePanel.updateTable();
    }

    @Generated
    public BreezeCheckBox getSnrCheckBox() {
        return this.snrCheckBox;
    }

    public static class WavelengthTableModel
    extends DefaultBreezeTableImpl {
        private final boolean showWavelengthImportance;
        private final ImportanceValue.WavelengthImportanceCallback callback;
        private SignalNoiseRatio.Snr snr;

        public WavelengthTableModel(boolean bl, ImportanceValue.WavelengthImportanceCallback wavelengthImportanceCallback) {
            this.showWavelengthImportance = bl;
            this.callback = wavelengthImportanceCallback;
        }

        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            WavelengthClass wavelengthClass = (WavelengthClass)object;
            vector.add(wavelengthClass);
            int n = wavelengthClass.getIndex();
            if (this.showWavelengthImportance) {
                vector.add(new ImportanceValue(this.callback, n));
            }
            if (this.snr != null) {
                vector.add(new SnrValue(this.snr, n));
            }
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Wavelength");
            if (this.showWavelengthImportance) {
                arrayList.add("Importance");
            }
            if (this.snr != null) {
                arrayList.add("SNR");
            }
            return arrayList;
        }

        @Override
        public int[] getColumnWidth() {
            if (this.showWavelengthImportance) {
                if (this.snr != null) {
                    return new int[]{50, 25, 25};
                }
                return new int[]{60, 40};
            }
            if (this.snr != null) {
                return new int[]{60, 40};
            }
            return new int[]{100};
        }

        @Generated
        public void setSnr(SignalNoiseRatio.Snr snr) {
            this.snr = snr;
        }
    }

    public static class ImportanceValue
    extends FunctionResultNoFactor {
        private final int index;
        private final WavelengthImportanceCallback callback;

        public ImportanceValue(WavelengthImportanceCallback wavelengthImportanceCallback, int n) {
            super(new DescriptorTreeNode(), new MinMax(0.0f, 100.0f));
            this.callback = wavelengthImportanceCallback;
            this.index = n;
        }

        @Override
        public float getValue() {
            return this.callback.getValue(this.index);
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        public static interface WavelengthImportanceCallback {
            public float getValue(int var1);
        }
    }

    public static class WavelengthClass
    extends BreezeIndexIntervalClass {
        public String name;

        public WavelengthClass(String string, int n) {
            super(n);
            this.name = string;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public float getValue() {
            return RtDataFormat.toNumberFloat(this.name);
        }
    }

    private static class WavelengthSettingsPanel
    extends DefaultSettingsPanel {
        public WavelengthSettingsPanel(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, Analyse analyse) {
            DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Selection");
            JPanel jPanel = sectionPanel.getPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By interval", "selectby/Select_By_Interval", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByInterval(breezeMainPanel, breezeTablePanel)), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("By random", "selectby/Select_By_Random", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectByRandom(breezeMainPanel, breezeTablePanel)), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("Included", "selectby/Select_By_Included", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectIncExc(breezeMainPanel, breezeTablePanel, true)), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(12, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("Excluded", "selectby/Select_By_Excluded", () -> EditMeasurementTableInteraction.TableSettingsPanel.selectIncExc(breezeMainPanel, breezeTablePanel, false)), gridBagConstraints4);
        }
    }

    public static class FunctionResultNoFactor
    extends FunctionResult {
        private final MinMax minMax;

        public FunctionResultNoFactor(DescriptorTreeNode descriptorTreeNode, MinMax minMax) {
            super(descriptorTreeNode);
            this.minMax = minMax;
        }

        @Override
        public String getStringValueWithUnit() {
            float f = this.getValue();
            if (f > 0.0f) {
                return RtDataFormat.toString(f, 3);
            }
            return "";
        }

        @Override
        public MinMax getMinMax() {
            return this.minMax;
        }

        @Override
        public Factor getFactor() {
            return null;
        }
    }

    public static class SnrValue
    extends FunctionResultNoFactor {
        public SnrValue(SignalNoiseRatio.Snr snr, int n) {
            super(new DescriptorTreeNode(), snr.minMax);
            this.setValue(snr.values.get(n));
        }
    }
}

