/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.map.main.script.ScriptHelper;

public class TransformationPanel
extends JPanel {
    private final AdvancedInputField savGolPolyOrder = new AdvancedInputField("Polynomial order");
    private final AdvancedInputField savGolLeft = new AdvancedInputField("Left window");
    private final AdvancedInputField savGolRight = new AdvancedInputField("Right window");
    private final BreezeCheckBox logarithmCheckBox = new BreezeCheckBox();
    private final BreezeCheckBox centerCheckBox = new BreezeCheckBox();
    private final BreezeCheckBox derivativeCheckBox = new BreezeCheckBox();
    private final BreezeCheckBox uvScaleCheckBox = new BreezeCheckBox();
    private final CollapsePanel crAdvancedPanel = new CollapsePanel();
    private final AdvancedInputField crStart = new AdvancedInputField("Left offset");
    private final AdvancedInputField crEnd = new AdvancedInputField("Right offset");
    private final BreezeCheckBox continuumRemovalCheckBox = new BreezeCheckBox();
    private final BreezeLabel derivativeEndLabel = new BreezeLabel();
    private final JPanel derivativeOrderPanel = new JPanel();
    private final JPanel derivativeOrderPanel1 = new JPanel();
    private final JPanel derivativeSettingsPanel = new JPanel();
    private final BreezeLabel derivativeStartLabel = new BreezeLabel();
    private final BreezeRadioButton zeroOrderRadioButton = new BreezeRadioButton();
    private final BreezeRadioButton firstOrderRadioButton = new BreezeRadioButton();
    private final BreezeRadioButton thirdOrderRadioButton = new BreezeRadioButton();
    private final ButtonGroup orderButtonGroup = new ButtonGroup();
    private final CollapsePanel savGolAdvancedPanel = new CollapsePanel();
    private final BreezeCheckBox savGolCheckBox = new BreezeCheckBox();
    private final JPanel savGolSettingsPanel = new JPanel();
    private final BreezeRadioButton secondOrderRadioButton = new BreezeRadioButton();
    private final BreezeCheckBox snvCheckBox = new BreezeCheckBox();
    private final BreezeRadioButton type1RadioButton = new BreezeRadioButton();
    private final BreezeRadioButton type2RadioButton = new BreezeRadioButton();
    private final ButtonGroup typeButtonGroup = new ButtonGroup();
    private int preTreatmentIndex = 0;

    public TransformationPanel(boolean bl2, boolean bl3, boolean bl4) {
        super(new GridBagLayout());
        this.setOpaque(false);
        int n = bl3 ? 6 : 18;
        BreezeLabel breezeLabel = new BreezeLabel("Pretreatments (applied in top-down order)");
        breezeLabel.setFont(new Font("Tahoma", 0, 18));
        breezeLabel.setForeground(new Color(150, 150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.anchor = 18;
        this.add((Component)breezeLabel, gridBagConstraints);
        this.snvCheckBox.setSelected(true);
        this.centerCheckBox.setSelected(bl2);
        this.savGolAdvancedPanel.getLabel().setFontSize(BreezeLabel.FontSize.H3);
        this.savGolAdvancedPanel.setCollapsed(!bl4);
        this.savGolAdvancedPanel.getPanel().add((Component)this.savGolPolyOrder, GridBagHelper.createWithWeigthX1(0, new Insets(5, 0, 0, 0)));
        this.savGolAdvancedPanel.getPanel().add((Component)this.savGolLeft, GridBagHelper.createWithWeigthX1(1, new Insets(5, 0, 0, 0)));
        this.savGolAdvancedPanel.getPanel().add((Component)this.savGolRight, GridBagHelper.createWithWeigthX1(2, new Insets(5, 0, 0, 0)));
        this.savGolAdvancedPanel.setCollapseCallback(bl -> this.savGolAdvancedPanel.setTitle("Settings" + (String)(!bl ? " (" + this.savGolPolyOrder.getValueInt() + ", " + this.savGolLeft.getValueInt() + ", " + this.savGolRight.getValueInt() + ")" : "")));
        this.addSavGolSettings(n, bl4);
        if (!bl4) {
            this.continuumRemovalCheckBox.setText("Continuum Removal");
            this.continuumRemovalCheckBox.setName("continummremoval");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.preTreatmentIndex++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(n, 20, 0, 0);
            this.add((Component)this.continuumRemovalCheckBox, gridBagConstraints);
            this.crAdvancedPanel.getLabel().setFontSize(BreezeLabel.FontSize.H3);
            this.crAdvancedPanel.getPanel().add((Component)this.crStart, GridBagHelper.createWithWeigthX1(0, new Insets(5, 0, 0, 0)));
            this.crAdvancedPanel.getPanel().add((Component)this.crEnd, GridBagHelper.createWithWeigthX1(1, new Insets(5, 0, 0, 0)));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.preTreatmentIndex++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 40, 0, 0);
            this.add((Component)this.crAdvancedPanel, gridBagConstraints);
            this.crAdvancedPanel.setCollapseCallback(bl -> this.crAdvancedPanel.setTitle("Settings" + (String)(!bl ? " (" + this.crStart.getValueInt() + ", " + this.crEnd.getValueInt() + ")" : "")));
            this.addDerivativeSettings(n);
            this.snvCheckBox.setText("SNV (Standard Normal Variate correction)");
            this.snvCheckBox.setName("snv");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.preTreatmentIndex++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(n, 20, 0, 0);
            this.add((Component)this.snvCheckBox, gridBagConstraints);
            this.logarithmCheckBox.setText("Logarithm");
            this.logarithmCheckBox.setName("logarithm");
            this.logarithmCheckBox.addItemListener(this::derivativeCheckBoxItemStateChanged);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.preTreatmentIndex++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(n, 20, 0, 0);
            this.add((Component)this.logarithmCheckBox, gridBagConstraints);
            if (bl3) {
                if (bl2) {
                    this.centerCheckBox.setText("Center (Always applied)");
                    this.centerCheckBox.setEnabled(false);
                } else {
                    this.centerCheckBox.setText("Center");
                    this.centerCheckBox.setName("center");
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.preTreatmentIndex++;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(n, 20, 0, 0);
                this.add((Component)this.centerCheckBox, gridBagConstraints);
                this.uvScaleCheckBox.setText("UV (Unit Variance) scaling");
                this.uvScaleCheckBox.setName("uvscale");
                this.uvScaleCheckBox.addItemListener(this::derivativeCheckBoxItemStateChanged);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.preTreatmentIndex++;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(n, 20, 0, 0);
                this.add((Component)this.uvScaleCheckBox, gridBagConstraints);
            }
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new BreezeLabel(""), gridBagConstraints);
    }

    public void setValues(HashMap<Model.Transformation, ModelProperties.TransformationProperties> hashMap, int n) {
        this.snvCheckBox.setSelected(hashMap.get((Object)Model.Transformation.SNV).enabled());
        this.centerCheckBox.setSelected(hashMap.get((Object)Model.Transformation.Center).enabled());
        this.logarithmCheckBox.setSelected(hashMap.get((Object)Model.Transformation.Logarithm).enabled());
        this.uvScaleCheckBox.setSelected(hashMap.get((Object)Model.Transformation.UvScale).enabled());
        ModelProperties.TransformationProperties transformationProperties = hashMap.get((Object)Model.Transformation.SavitzkyGolay);
        this.savGolCheckBox.setSelected(transformationProperties.enabled());
        Properties properties = transformationProperties.getProperties();
        if (ScriptHelper.hasKey((Properties)properties, (String)"derivativeOrder")) {
            int n2 = ScriptHelper.getPropertyInt((Properties)properties, (String)"derivativeOrder");
            if (n2 == 0) {
                this.zeroOrderRadioButton.setSelected(true);
            } else if (n2 == 1) {
                this.firstOrderRadioButton.setSelected(true);
            } else if (n2 == 2) {
                this.secondOrderRadioButton.setSelected(true);
            } else {
                this.thirdOrderRadioButton.setSelected(true);
            }
        } else {
            this.zeroOrderRadioButton.setSelected(true);
        }
        if (ScriptHelper.hasKey((Properties)properties, (String)"polynomialorder")) {
            this.savGolPolyOrder.setValue(ScriptHelper.getPropertyInt((Properties)properties, (String)"polynomialorder"));
        } else {
            this.savGolPolyOrder.setValue(2);
        }
        if (ScriptHelper.hasKey((Properties)properties, (String)"leftpoints")) {
            this.savGolLeft.setValue(ScriptHelper.getPropertyInt((Properties)properties, (String)"leftpoints"));
        } else {
            this.savGolLeft.setValue(Math.min(3, n / 3));
        }
        if (ScriptHelper.hasKey((Properties)properties, (String)"rightpoints")) {
            this.savGolRight.setValue(ScriptHelper.getPropertyInt((Properties)properties, (String)"rightpoints"));
        } else {
            this.savGolRight.setValue(Math.min(3, n / 3));
        }
        this.enableOrder(this.savGolCheckBox.isSelected());
        this.savGolAdvancedPanel.triggerCollapseCallback();
        this.enableDerivative(this.derivativeCheckBox.isSelected());
        ModelProperties.TransformationProperties transformationProperties2 = hashMap.get((Object)Model.Transformation.Derivative);
        this.derivativeCheckBox.setSelected(transformationProperties2.enabled());
        Properties properties2 = transformationProperties2.getProperties();
        if (ScriptHelper.hasKey((Properties)properties2, (String)"type")) {
            int n3 = ScriptHelper.getPropertyInt((Properties)properties2, (String)"type");
            if (n3 == 2) {
                this.type2RadioButton.setSelected(true);
            } else {
                this.type1RadioButton.setSelected(true);
            }
        } else {
            this.type1RadioButton.setSelected(true);
        }
        ModelProperties.TransformationProperties transformationProperties3 = hashMap.get((Object)Model.Transformation.ContinuumRemoval);
        this.continuumRemovalCheckBox.setSelected(transformationProperties3.enabled());
        Properties properties3 = transformationProperties3.getProperties();
        if (ScriptHelper.hasKey((Properties)properties3, (String)"leftoffset")) {
            this.crStart.setValue(ScriptHelper.getPropertyInt((Properties)properties3, (String)"leftoffset"));
        } else {
            this.crStart.setValue(0);
        }
        if (ScriptHelper.hasKey((Properties)properties3, (String)"rightoffset")) {
            this.crEnd.setValue(ScriptHelper.getPropertyInt((Properties)properties3, (String)"rightoffset"));
        } else {
            this.crEnd.setValue(0);
        }
        this.crAdvancedPanel.triggerCollapseCallback();
    }

    public List<RtModule> getTransformationModules(int n) {
        ArrayList<RtModule> arrayList = new ArrayList<RtModule>();
        for (ModelProperties.TransformationProperties transformationProperties : this.getTransformations()) {
            if (!transformationProperties.enabled()) continue;
            try {
                arrayList.add(TransformationParameter.createModule(transformationProperties, n));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public List<ModelProperties.TransformationProperties> getTransformations() {
        ArrayList<ModelProperties.TransformationProperties> arrayList = new ArrayList<ModelProperties.TransformationProperties>();
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.SavitzkyGolay, this.savGolCheckBox.isSelected(), this.getSavitzkyProperties()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.ContinuumRemoval, this.continuumRemovalCheckBox.isSelected(), this.getContinuumRemovalProperties()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.Derivative, this.derivativeCheckBox.isSelected(), this.getDerivativeProperties()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.SNV, this.snvCheckBox.isSelected()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.Logarithm, this.logarithmCheckBox.isSelected()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.Center, this.centerCheckBox.isSelected()));
        arrayList.add(new ModelProperties.TransformationProperties(Model.Transformation.UvScale, this.uvScaleCheckBox.isSelected()));
        return arrayList;
    }

    private void derivativeCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.enableDerivative(this.derivativeCheckBox.isSelected());
    }

    private void enableDerivative(boolean bl) {
        this.type1RadioButton.setEnabled(bl);
        this.type2RadioButton.setEnabled(bl);
    }

    private void addSavGolSettings(int n, boolean bl) {
        this.savGolCheckBox.setText("Savitzky Golay");
        this.savGolCheckBox.setName("savitzky");
        this.savGolCheckBox.addItemListener(this::savGolCheckBoxItemStateChanged);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n, 20, 0, 0);
        this.add((Component)this.savGolCheckBox, gridBagConstraints);
        this.savGolSettingsPanel.setOpaque(false);
        this.savGolSettingsPanel.setLayout(new GridBagLayout());
        this.derivativeOrderPanel.setOpaque(false);
        this.derivativeOrderPanel.setLayout(new GridBagLayout());
        this.orderButtonGroup.add(this.zeroOrderRadioButton);
        this.zeroOrderRadioButton.setText("Smoothing");
        this.zeroOrderRadioButton.setFont(new Font("Tahoma", 0, 12));
        if (bl) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            this.derivativeOrderPanel.add((Component)this.zeroOrderRadioButton, gridBagConstraints2);
        } else {
            this.derivativeOrderPanel.add((Component)this.zeroOrderRadioButton, new GridBagConstraints());
        }
        if (!bl) {
            this.derivativeStartLabel.setText("(");
            this.derivativeStartLabel.setFont(new Font("Tahoma", 0, 12));
            this.derivativeOrderPanel.add((Component)this.derivativeStartLabel, new GridBagConstraints());
            this.orderButtonGroup.add(this.firstOrderRadioButton);
            this.firstOrderRadioButton.setText("1st");
            this.firstOrderRadioButton.setFont(new Font("Tahoma", 0, 12));
            this.derivativeOrderPanel.add((Component)this.firstOrderRadioButton, new GridBagConstraints());
            this.orderButtonGroup.add(this.secondOrderRadioButton);
            this.secondOrderRadioButton.setText("2nd");
            this.secondOrderRadioButton.setFont(new Font("Tahoma", 0, 12));
            this.derivativeOrderPanel.add((Component)this.secondOrderRadioButton, new GridBagConstraints());
            this.orderButtonGroup.add(this.thirdOrderRadioButton);
            this.thirdOrderRadioButton.setText("3rd");
            this.thirdOrderRadioButton.setFont(new Font("Tahoma", 0, 12));
            this.derivativeOrderPanel.add((Component)this.thirdOrderRadioButton, new GridBagConstraints());
            this.derivativeEndLabel.setText("derivative)");
            this.derivativeEndLabel.setFont(new Font("Tahoma", 0, 12));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.derivativeOrderPanel.add((Component)this.derivativeEndLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.savGolSettingsPanel.add((Component)this.derivativeOrderPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 40, 0, 0);
        this.savGolSettingsPanel.add((Component)this.savGolAdvancedPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.fill = 1;
        this.add((Component)this.savGolSettingsPanel, gridBagConstraints);
    }

    private void savGolCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.enableOrder(this.savGolCheckBox.isSelected());
    }

    private void addDerivativeSettings(int n) {
        this.derivativeCheckBox.setText("Derivative");
        this.derivativeCheckBox.setName("derivative");
        this.derivativeCheckBox.addItemListener(this::derivativeCheckBoxItemStateChanged);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n, 20, 0, 0);
        this.add((Component)this.derivativeCheckBox, gridBagConstraints);
        this.derivativeSettingsPanel.setOpaque(false);
        this.derivativeSettingsPanel.setLayout(new GridBagLayout());
        this.derivativeOrderPanel1.setOpaque(false);
        this.derivativeOrderPanel1.setLayout(new GridBagLayout());
        this.typeButtonGroup.add(this.type1RadioButton);
        this.type1RadioButton.setSelected(true);
        this.type1RadioButton.setText("Type 1");
        this.type1RadioButton.setToolTipText("X(i)=X(i + 1) - X(i)");
        this.type1RadioButton.setFont(new Font("Tahoma", 0, 12));
        this.derivativeOrderPanel1.add((Component)this.type1RadioButton, new GridBagConstraints());
        this.typeButtonGroup.add(this.type2RadioButton);
        this.type2RadioButton.setText("Type 2");
        this.type2RadioButton.setToolTipText("X(i)=(X(i + 1) - X(i - 1)) / 2");
        this.type2RadioButton.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.derivativeOrderPanel1.add((Component)this.type2RadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.derivativeSettingsPanel.add((Component)this.derivativeOrderPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.preTreatmentIndex++;
        gridBagConstraints.fill = 1;
        this.add((Component)this.derivativeSettingsPanel, gridBagConstraints);
    }

    public void enableOrder(boolean bl) {
        this.zeroOrderRadioButton.setEnabled(bl);
        this.derivativeStartLabel.setEnabled(bl);
        this.firstOrderRadioButton.setEnabled(bl);
        this.secondOrderRadioButton.setEnabled(bl);
        this.thirdOrderRadioButton.setEnabled(bl);
        this.derivativeEndLabel.setEnabled(bl);
    }

    public boolean hasSNV() {
        return this.snvCheckBox.isSelected();
    }

    public Properties getSavitzkyProperties() {
        Properties properties = new Properties();
        properties.put("polynomialorder", String.valueOf(this.savGolPolyOrder.getValueInt()));
        properties.put("derivativeorder", String.valueOf(this.getOrder()));
        properties.put("leftpoints", String.valueOf(this.savGolLeft.getValueInt()));
        properties.put("rightpoints", String.valueOf(this.savGolRight.getValueInt()));
        properties.put("version", "2");
        return properties;
    }

    public Properties getDerivativeProperties() {
        Properties properties = new Properties();
        properties.put("type", String.valueOf(this.getDerivativeType()));
        return properties;
    }

    public Properties getContinuumRemovalProperties() {
        Properties properties = new Properties();
        properties.put("leftoffset", String.valueOf(this.crStart.getValueInt()));
        properties.put("rightoffset", String.valueOf(this.crEnd.getValueInt()));
        return properties;
    }

    private int getDerivativeType() {
        if (this.type2RadioButton.isSelected()) {
            return 2;
        }
        return 1;
    }

    private int getOrder() {
        if (this.zeroOrderRadioButton.isSelected()) {
            return 0;
        }
        if (this.firstOrderRadioButton.isSelected()) {
            return 1;
        }
        if (this.secondOrderRadioButton.isSelected()) {
            return 2;
        }
        if (this.thirdOrderRadioButton.isSelected()) {
            return 3;
        }
        return 0;
    }

    private static class AdvancedInputField
    extends BreezeSpinnerInputPanel {
        public AdvancedInputField(String string) {
            super(string, "", 0.0f, 2.1474836E9f, 1.0f, 1.0f, BreezeInputFieldHelper.Format.OneRow, BreezeSpinner.NumberInputLocation.LEFT, "");
            this.setLabelWidth(150);
            this.setValueWidth(200);
        }
    }
}

