/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel.selectstep;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lombok.Generated;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableSorter;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.BreezeIndexIntervalClass;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectHelper;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.TransformationPanel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;
import se.prediktera.map.simpletableeditor.CellIdentifier;

public class WavelenghtPreviewPanel
extends JPanel
implements CellIdentifier {
    private final WavelengthSpectralPlot spectralPlot;
    private final LegendPanel legendPanel = new LegendPanel();
    private final BreezeLabel previewLabel = new BreezeLabel("Preview");
    private final SelectWavelengthPanelStep imagePanel;
    private final Model model;
    private final TransformationPanel pretreatmentPanel;
    private final BreezeTablePanel tablePanel;
    private int tabIndex;
    private final String spectrumTitle;

    public WavelenghtPreviewPanel(SelectWavelengthPanelStep selectWavelengthPanelStep, WavelengthBreezeTable wavelengthBreezeTable, Analyse analyse, Model model, TransformationPanel transformationPanel, Measurement measurement) {
        super(new GridBagLayout());
        this.imagePanel = selectWavelengthPanelStep;
        this.tablePanel = wavelengthBreezeTable;
        this.model = model;
        this.pretreatmentPanel = transformationPanel;
        this.spectralPlot = new WavelengthSpectralPlot(wavelengthBreezeTable, selectWavelengthPanelStep.getSelectionColor());
        wavelengthBreezeTable.addSpectralPlotInteraction(this.spectralPlot);
        this.previewLabel.setPreferredSize(new Dimension(100, 20));
        this.spectrumTitle = PixelExplorePanel.getSpectralTitle(measurement) + " with pretreatments";
        this.add((Component)this.previewLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
        this.add((Component)((Object)this.spectralPlot), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
        this.add((Component)this.legendPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.legendPanel.setPreferredSize(new Dimension(100, 0));
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.add(new PlotToggleButton("Spectrum", buttonGroup, true, () -> this.setTabIndex(0)));
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        if (!modelMethod.isRuntime() && modelMethod != BasicAnalyse.ModelMethod.SimcaClassification) {
            if (model instanceof Model.ModelWithSample || model instanceof SampleModel) {
                jPanel.add(new PlotToggleButton("Loadings", buttonGroup, false, () -> this.setTabIndex(1)));
            }
            if (modelMethod.supportImportance()) {
                jPanel.add(new PlotToggleButton("Weights", buttonGroup, false, () -> this.setTabIndex(2)));
                jPanel.add(new PlotToggleButton("Importance", buttonGroup, false, () -> this.setTabIndex(3)));
            }
        }
        jPanel.add(new PlotToggleButton("SNR", buttonGroup, false, () -> this.setTabIndex(4)));
        this.add((Component)jPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
    }

    private void setTabIndex(int n) {
        this.tabIndex = n;
        this.update();
    }

    public void update() {
        if (this.tabIndex == 0) {
            this.previewLabel.setText(this.spectrumTitle);
            this.setBySamples();
        } else if (this.tabIndex == 1) {
            this.previewLabel.setText("Model loadings");
            this.setByLoadingOrWeights("P");
        } else if (this.tabIndex == 2) {
            this.previewLabel.setText("Model weights");
            this.setByLoadingOrWeights("W");
        } else if (this.tabIndex == 3) {
            this.previewLabel.setText("Importance");
            this.setByType("Importance");
        } else if (this.tabIndex == 4) {
            this.previewLabel.setText("Signal-to-noise ratio");
            if (!this.imagePanel.getSnrCheckBox().isSelected()) {
                this.imagePanel.getSnrCheckBox().setSelectedAndTrigger(true);
            }
            this.setByType("SNR");
        }
    }

    private void setBySamples() {
        ArrayList<SampleDataWrapper> arrayList = new ArrayList<SampleDataWrapper>();
        List<Sample> list = this.model.getIncludedSampleList();
        if (!list.isEmpty()) {
            Model.ModelWithSample modelWithSample;
            Object object;
            List<RtModule> list2 = this.pretreatmentPanel.getTransformationModules(1);
            double d = Math.max(1.0, (double)list.size() / 100.0);
            Object object2 = null;
            Object object3 = this.model;
            if (object3 instanceof Model.ModelWithSample && (object = (modelWithSample = (Model.ModelWithSample)object3).getSelectedVariables().getFirst()) instanceof CategoryFactor) {
                object2 = object3 = (CategoryFactor)object;
            }
            for (double d2 = 0.0; d2 < (double)list.size(); d2 += d) {
                CatClass catClass;
                Float f;
                object = list.get((int)d2);
                float[] fArray = ((Sample)object).getPath().getAverageProfile();
                if (fArray == null) continue;
                float[] fArray2 = TransformationParameter.getData(list2, fArray);
                float[] fArray3 = this.spectralPlot.getWavelengthOrSetValues(fArray2.length);
                Measurement measurement = ((Sample)object).measurement();
                boolean bl = measurement.hasReferences();
                for (int i = 0; i < fArray2.length; ++i) {
                    if (!bl) continue;
                    fArray2[i] = Math.min(10.0f, fArray2[i]);
                }
                SampleDataWrapper sampleDataWrapper = new SampleDataWrapper(fArray3, fArray2, (Sample)object);
                sampleDataWrapper.setColor(BreezeTheme.getInstance().getLabelForeground());
                if (object2 != null && (f = ((BasicSample)object).getSampleValues().getValue((Factor)object2)) != null && (catClass = ((CategoryFactor)object2).getClassByValueIdx(f.intValue())) != null) {
                    sampleDataWrapper.setColor(catClass.getColor());
                }
                arrayList.add(sampleDataWrapper);
            }
            this.setLegend((CategoryFactor)object2);
        }
        this.spectralPlot.setData(arrayList);
    }

    private void setByLoadingOrWeights(String string) {
        ArrayList<1> arrayList = new ArrayList<1>();
        AbstractModel abstractModel = Model.getEvinceModel(this.model);
        if (abstractModel != null) {
            AbstractDataMatrix abstractDataMatrix = abstractModel.getMatrixByName(string);
            int n = abstractDataMatrix.getN();
            int[] nArray = abstractDataMatrix.getKref();
            CommonModelSettings.EvinceWavelengthIndex evinceWavelengthIndex = new CommonModelSettings.EvinceWavelengthIndex(abstractModel.getDataSet());
            int n2 = evinceWavelengthIndex.getIndex(0);
            int n3 = evinceWavelengthIndex.getWavelengthCount();
            CategoryFactor categoryFactor = new CategoryFactor("Component", "ID");
            for (int i = 0; i < n; ++i) {
                float[] fArray = this.spectralPlot.getWavelengthOrSetValues(n3);
                float[] fArray2 = new float[n3];
                int n4 = 0;
                for (int j = 0; j < n3; ++j) {
                    if (n4 >= nArray.length || nArray[n4] - n2 != j) continue;
                    fArray2[j] = (float)abstractDataMatrix.getValue(i, n4);
                    ++n4;
                }
                DataWrapper dataWrapper = new DataWrapper(this, fArray, fArray2, string.toLowerCase() + (i + 1)){

                    public boolean isGap(int n) {
                        return this.getYvalueAt(n) == 0.0f;
                    }
                };
                CatClass catClass = categoryFactor.addClass(dataWrapper.toString());
                dataWrapper.setColor(catClass.getColor());
                dataWrapper.setStroke((Stroke)new BasicStroke(2.0f, 1, 0, 10.0f));
                arrayList.add(dataWrapper);
            }
            this.setLegend(categoryFactor);
        }
        this.spectralPlot.setData(arrayList);
    }

    private void setByType(String string) {
        ArrayList<2> arrayList = new ArrayList<2>();
        BreezeTable breezeTable = this.tablePanel.getTable();
        try {
            int n = breezeTable.getColumnModel().getColumnIndex(string);
            int n2 = breezeTable.getRowCount();
            int[] nArray = ((BreezeTableSorter)breezeTable.getModel()).getIndexes();
            for (int i = 0; i < 1; ++i) {
                float[] fArray = this.spectralPlot.getWavelengthOrSetValues(n2);
                float[] fArray2 = new float[n2];
                for (int j = 0; j < n2; ++j) {
                    Object object = breezeTable.getValueAt(j, n);
                    if (!(object instanceof SelectWavelengthPanelStep.FunctionResultNoFactor)) continue;
                    SelectWavelengthPanelStep.FunctionResultNoFactor functionResultNoFactor = (SelectWavelengthPanelStep.FunctionResultNoFactor)object;
                    fArray2[nArray[j]] = functionResultNoFactor.getValue();
                }
                DataWrapper dataWrapper = new DataWrapper(this, fArray, fArray2, string){

                    public boolean isGap(int n) {
                        return this.getYvalueAt(n) == 0.0f;
                    }
                };
                dataWrapper.setColor(RtPerfectSpread.generateColor(i + 1));
                dataWrapper.setStroke((Stroke)new BasicStroke(4.0f, 1, 0, 10.0f));
                arrayList.add(dataWrapper);
            }
            this.setLegend(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.spectralPlot.setData(arrayList);
    }

    private void setLegend(CategoryFactor categoryFactor) {
        this.legendPanel.setVisible(categoryFactor != null);
        if (categoryFactor != null) {
            this.legendPanel.setTitle(categoryFactor.getName());
            this.legendPanel.setClassTypes(null, categoryFactor, null);
            this.legendPanel.repaint();
        }
    }

    public static class WavelengthSpectralPlot
    extends SpectralPlot {
        private Point startPoint;
        private Point endPoint;
        private boolean[] selband;
        private final WavelengthBreezeTable tablePanel;
        private final Color selectionColor;
        private static final float[] dash1 = new float[]{10.0f};
        private static final BasicStroke robberStroke = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);

        public WavelengthSpectralPlot(WavelengthBreezeTable wavelengthBreezeTable, Color color) {
            this.tablePanel = wavelengthBreezeTable;
            this.selectionColor = new BreezeColor(color, 100);
            this.setXdesc("Wavelength");
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
            this.setGridColor(breezeTheme.getPlotGridColor());
            this.setZeroColor(breezeTheme.getLabelForeground());
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            DataWrapper dataWrapper;
            double[] dArray = new double[2];
            this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
            if (dArray[0] > 0.0 && (dataWrapper = this.getWrapperClosestTo(dArray[0], dArray[1])) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
                if (dataWrapper instanceof SampleDataWrapper) {
                    SampleDataWrapper sampleDataWrapper = (SampleDataWrapper)dataWrapper;
                    Sample sample = sampleDataWrapper.getSample();
                    stringBuilder.append("<tr><td>").append("Measurement:").append("</td>");
                    stringBuilder.append("<td>").append(sample.measurement().toString()).append("</td></tr>");
                    stringBuilder.append("<tr><td>").append("Sample:").append("</td>");
                    stringBuilder.append("<td>").append(sample.getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE)).append("</td></tr>");
                }
                stringBuilder.append("<tr><td>").append("Wavelength:").append("</td>");
                stringBuilder.append("<td>").append(RtDataFormat.toString(dArray[0])).append("</td></tr>");
                stringBuilder.append("</table></html>");
                return stringBuilder.toString();
            }
            return super.getToolTipText(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.selband = null;
                this.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.hasData()) {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                BreezeTheme breezeTheme = BreezeTheme.getInstance();
                graphics2D.setColor(breezeTheme.getLabelForeground());
                graphics2D.setXORMode(breezeTheme.getPanelBackground());
                if (this.startPoint != null && this.endPoint != null) {
                    this.drawSelection(graphics2D, this.startPoint, this.endPoint);
                }
                this.endPoint = mouseEvent.getPoint();
                this.drawSelection(graphics2D, this.startPoint, this.endPoint);
                graphics2D.dispose();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.startPoint = mouseEvent.getPoint();
                this.endPoint = null;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.startPoint != null && this.endPoint != null) {
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                if (this.startPoint.x < this.endPoint.x) {
                    this.Screen2Index(dArray, this.startPoint.x, 0.0);
                    this.Screen2Index(dArray2, this.endPoint.x, 0.0);
                } else {
                    this.Screen2Index(dArray, this.endPoint.x, 0.0);
                    this.Screen2Index(dArray2, this.startPoint.x, 0.0);
                }
                this.setBand(mouseEvent, dArray[0], dArray2[0], 0.0, this.getNumberOfValues());
                this.repaint();
                this.tablePanel.spectralSelectionChanged(this.selband);
            } else {
                this.selband = null;
                this.tablePanel.spectralSelectionChanged(null);
            }
            this.startPoint = null;
            this.endPoint = null;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hasData()) {
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                this.Real2Screen(dArray, this.getXmin(), 0.0);
                this.Real2Screen(dArray2, this.getXmax(), 0.0);
                this.drawIncludedBands(graphics, (int)dArray[0], (int)dArray2[0]);
                if (this.selband != null) {
                    this.drawSelectedBands(graphics, (int)dArray[0], (int)dArray2[0]);
                }
            }
        }

        private void drawSelectedBands(Graphics graphics, int n, int n2) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            for (int i = 0; i < this.selband.length; ++i) {
                int n3;
                if (!this.selband[i] || i != 0 && this.selband[i] == this.selband[i - 1]) continue;
                for (n3 = i + 1; n3 < this.selband.length && this.selband[n3] == this.selband[n3 - 1]; ++n3) {
                }
                this.Index2Screen(dArray, (double)i - 0.5);
                this.Index2Screen(dArray2, (double)n3 - 0.5);
                graphics.setColor(this.selectionColor);
                int n4 = (int)dArray[0];
                int n5 = (int)(dArray2[0] - dArray[0]);
                graphics.fillRect(n4, this.sy, n5, this.height - 1);
                graphics.setColor(this.getForeground());
                graphics.drawRect(n4, this.sy, n5, this.height - 1);
            }
        }

        private void drawIncludedBands(Graphics graphics, int n, int n2) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double d = this.getNumberOfValues();
            Color color = BreezeIntervalClass.intervalColor;
            int n3 = 0;
            while ((double)n3 < d) {
                if (this.tablePanel.isIncluded(n3)) {
                    int n4 = n3 + 1;
                    while ((double)n4 < d && this.tablePanel.isIncluded(n4)) {
                        ++n4;
                    }
                    this.Index2Screen(dArray, Math.max(0.0, (double)n3 - 0.5));
                    this.Index2Screen(dArray2, Math.min(d - 1.0, (double)n4 - 0.5));
                    graphics.setColor(color);
                    int n5 = (int)dArray[0];
                    int n6 = (int)(dArray2[0] - dArray[0]);
                    graphics.fillRect(n5, this.sy + 1, n6, this.height - 2);
                    graphics.setColor(this.getForeground());
                    graphics.drawRect(n5, this.sy, n6, this.height - 1);
                    n3 = n4 - 1;
                }
                ++n3;
            }
        }

        private void drawSelection(Graphics2D graphics2D, Point point, Point point2) {
            if (point != null && point2 != null) {
                graphics2D.setStroke(robberStroke);
                int n = Math.abs(point2.x - point.x);
                if (point.x < point2.x) {
                    graphics2D.drawRect(point.x, this.sy, n, this.height - 1);
                } else {
                    graphics2D.drawRect(point2.x, this.sy, n, this.height - 1);
                }
            }
        }

        private void setBand(MouseEvent mouseEvent, double d, double d2, double d3, double d4) {
            if (d > d4 || d2 < d3) {
                if (!mouseEvent.isControlDown()) {
                    this.selband = null;
                }
                return;
            }
            if ((d = Math.max(d, d3)) == (d2 = Math.min(d2, d4))) {
                if (!mouseEvent.isControlDown()) {
                    this.selband = null;
                }
                return;
            }
            if (this.selband == null || !mouseEvent.isControlDown()) {
                this.selband = new boolean[(int)d4];
            }
            int n = (int)d;
            while ((double)n < d2) {
                this.selband[n] = true;
                ++n;
            }
        }

        public void setSelectedRows(int[] nArray) {
            if (this.getNumberOfValues() > 0) {
                this.selband = new boolean[this.getNumberOfValues()];
                for (int n : nArray) {
                    this.selband[n] = true;
                }
                this.repaint();
            }
        }

        public float[] getWavelengthOrSetValues(int n) {
            ArrayList arrayList = (ArrayList)this.tablePanel.getTableList();
            int n2 = arrayList.size();
            if (this.isNumber(arrayList)) {
                float[] fArray = new float[n];
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = i < n2 ? ((SelectWavelengthPanelStep.WavelengthClass)arrayList.get(i)).getValue() : ((SelectWavelengthPanelStep.WavelengthClass)arrayList.get(n2 - 1)).getValue();
                }
                this.setValues(null);
                return fArray;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = i < n2 ? ((SelectWavelengthPanelStep.WavelengthClass)arrayList.get((int)i)).name : ((SelectWavelengthPanelStep.WavelengthClass)arrayList.get((int)(n2 - 1))).name;
            }
            this.setValues(stringArray);
            return null;
        }

        private boolean isNumber(ArrayList<SelectWavelengthPanelStep.WavelengthClass> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (RtDataFormat.isNumber(arrayList.get((int)i).name)) continue;
                return false;
            }
            return true;
        }
    }

    public static class WavelengthBreezeTable
    extends BreezeTablePanel {
        public final int includeColumn = 0;
        public boolean addingSelectionFromInteraction = false;

        public WavelengthBreezeTable() {
            this.getTable().setSelectionMode(2);
            this.setSortable(true);
            this.addRowHeader();
            this.getScrollPane().setHorizontalScrollBarPolicy(31);
            this.setColumnWidth(0);
            this.setMinimumSize(new Dimension(380, 0));
            this.setPreferredSize(new Dimension(380, 0));
            this.requestFocus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void spectralSelectionChanged(boolean[] blArray) {
            try {
                this.addingSelectionFromInteraction = true;
                BreezeTable breezeTable = this.getTable();
                if (blArray != null) {
                    int n = -1;
                    boolean bl = true;
                    for (int i = 0; i < blArray.length; ++i) {
                        int n2;
                        if (!blArray[i] || (n2 = SelectHelper.getTableIndex((JTable)((Object)this.getTable()), 0, i)) < 0) continue;
                        if (bl) {
                            ((JTable)((Object)breezeTable)).setRowSelectionInterval(n2, n2);
                            bl = false;
                        } else {
                            ((JTable)((Object)breezeTable)).addRowSelectionInterval(n2, n2);
                        }
                        n = n2;
                    }
                    if (n >= 0) {
                        ((JComponent)((Object)breezeTable)).scrollRectToVisible(((JTable)((Object)breezeTable)).getCellRect(n, 0, true));
                    }
                } else {
                    ((JTable)((Object)breezeTable)).clearSelection();
                }
            }
            finally {
                this.addingSelectionFromInteraction = false;
            }
        }

        public boolean isIncluded(int n) {
            BreezeIndexIntervalClass breezeIndexIntervalClass = SelectHelper.getIndexClass((JTable)((Object)this.getTable()), 0, n);
            return breezeIndexIntervalClass != null && breezeIndexIntervalClass.isIncluded();
        }

        public int[] getSelectedWavelength() {
            BreezeTable breezeTable = this.getTable();
            int[] nArray = ((JTable)((Object)breezeTable)).getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = ((SelectWavelengthPanelStep.WavelengthClass)((JTable)((Object)breezeTable)).getValueAt(nArray[i], 0)).getIndex();
            }
            return nArray2;
        }

        public void addSpectralPlotInteraction(final WavelengthSpectralPlot wavelengthSpectralPlot) {
            this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                final /* synthetic */ WavelengthBreezeTable this$0;
                {
                    this.this$0 = wavelengthBreezeTable;
                }

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!this.this$0.addingSelectionFromInteraction) {
                        wavelengthSpectralPlot.setSelectedRows(this.this$0.getSelectedWavelength());
                    }
                }
            });
        }
    }

    private static class PlotToggleButton
    extends BreezeToggleButton {
        public PlotToggleButton(String string, ButtonGroup buttonGroup, boolean bl, Runnable runnable) {
            super(string, null, buttonGroup, bl, runnable);
            this.setPreferredSize(new Dimension(100, 30));
            this.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
        }
    }

    private static class SampleDataWrapper
    extends DataWrapper {
        final Sample sample;

        public SampleDataWrapper(float[] fArray, float[] fArray2, Sample sample) {
            super(fArray, fArray2, "");
            this.sample = sample;
        }

        @Generated
        public Sample getSample() {
            return this.sample;
        }
    }
}

