/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.telops;

import java.util.ArrayList;
import se.prediktera.breeze.backend.measure.HySpexTelopReflectivityHandler;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.telops.ReferenceCaptureStep;
import se.prediktera.breeze.frontend.wizard.telops.ReferenceManipulateStep;
import se.prediktera.breeze.frontend.wizard.telops.ReflectiveType;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.map.common.error.ErrorHandler;

public class HySpexTelopReferenceWizard
extends WizardPanel {
    private final Runnable onFinish;
    private final HySpexTelopReflectivityHandler reflectivityHandler;

    public HySpexTelopReferenceWizard(final BreezeFrame breezeFrame, Runnable runnable) {
        super(breezeFrame, "Scan plate and enable reflectance spectra", false);
        this.onFinish = runnable;
        HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
        Camera camera2 = hardwareRegistry.getCameras().stream().filter(camera -> camera.getFormattedCameraType().contains("LWIR")).findFirst().orElseThrow(() -> new ErrorHandler.WarningMessageException("Failed to collect LWIR"));
        Camera camera3 = hardwareRegistry.getCameras().stream().filter(camera -> camera.getFormattedCameraType().contains("MWIR")).findFirst().orElseThrow(() -> new ErrorHandler.WarningMessageException("Failed to collect MWIR"));
        final ArrayList<Camera> arrayList = new ArrayList<Camera>();
        if (!camera2.isConnected()) {
            arrayList.add(camera2);
        }
        if (!camera3.isConnected()) {
            arrayList.add(camera3);
        }
        if (!arrayList.isEmpty() || !hardwareRegistry.getSampleMover().isConnected()) {
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){

                @Override
                public void runAction() {
                    ConnectProgressAction.connectAll(this.getProgressManager(), breezeFrame, arrayList);
                    this.setInfoText("Updating settings");
                }
            }, "Connecting hardware");
        }
        this.reflectivityHandler = new HySpexTelopReflectivityHandler(camera2, camera3);
        this.addReflectivityStep(ReflectiveType.High1);
        this.addReflectivityStep(ReflectiveType.High2);
        this.addReflectivityStep(ReflectiveType.Low1);
        this.addReflectivityStep(ReflectiveType.Low2);
    }

    public void addReflectivityStep(ReflectiveType reflectiveType) {
        this.addWizardStep(new ReferenceManipulateStep(reflectiveType));
        this.addWizardStep(new ReferenceCaptureStep(this.getFrame(), reflectiveType, this.reflectivityHandler));
    }

    @Override
    public BreezeType getPageType() {
        return BreezeType.Settings;
    }
}

