/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.telops;

import se.prediktera.breeze.backend.measure.HySpexTelopReflectivityHandler;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.telops.ReflectiveType;
import se.prediktera.breeze.hardware.Camera;

public class ReferenceCaptureStep
implements WizardStep.WizardStepConditional {
    private final ViewClass viewClass;
    private final BreezeFrame mainFrame;
    private final ReflectiveType reflectiveType;
    private final HySpexTelopReflectivityHandler measurementTaker;

    public ReferenceCaptureStep(BreezeFrame breezeFrame, ReflectiveType reflectiveType, HySpexTelopReflectivityHandler hySpexTelopReflectivityHandler) {
        this.reflectiveType = reflectiveType;
        DescriptionPanel descriptionPanel = new DescriptionPanel(this.getPlaceStringFromReflectivity(), "PlaceWhiteReference2");
        this.viewClass = new CameraViewClass("Capture", this.getPlaceStringFromReflectivity(), descriptionPanel);
        this.viewClass.setSubtitle2("Capture");
        this.mainFrame = breezeFrame;
        this.measurementTaker = hySpexTelopReflectivityHandler;
    }

    private String getPlaceStringFromReflectivity() {
        return switch (this.reflectiveType) {
            default -> throw new MatchException(null, null);
            case ReflectiveType.High1, ReflectiveType.Low1 -> "Capturing reflectivity plate for " + this.reflectiveType.getReflectanceDescription();
            case ReflectiveType.High2, ReflectiveType.Low2 -> "Capturing reflectivity plate for " + this.reflectiveType.getReflectanceDescription() + " - rotated 180 degrees";
        };
    }

    public void Execute() {
    }

    @Override
    public boolean isCondition() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        wizardControlCallback.setNextText("Start capture");
        if (bl && this.isCondition()) {
            return WizardPanel.LeaveProgressAction.createWithCancel(this.mainFrame, wizardControlCallback, breezeProgressManager -> {
                breezeProgressManager.setInfoText("Scanning reflectivity plate (" + this.reflectiveType.getReflectanceDescription() + ")");
                if (!this.measurementTaker.sendReflectivityScanCommand(breezeProgressManager, this.reflectiveType)) {
                    wizardControlCallback.setNextText("Failed");
                    wizardControlCallback.setEnabled(false);
                }
            }, "Taking " + this.reflectiveType.getReflectanceDescription() + " reflectivity reference measurement for LWIR");
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    public static class CameraViewClass
    extends ViewClass {
        public CameraViewClass(String string, String string2, DescriptionPanel descriptionPanel) {
            super(string, string2, descriptionPanel);
            BreezeLabel breezeLabel = new BreezeLabel(" LWIR", true, 16);
            breezeLabel.setResourceIcon("material/videocam");
            descriptionPanel.addBottomOption(breezeLabel);
            BreezeLabel breezeLabel2 = new BreezeLabel(" MWIR", true, 16);
            breezeLabel2.setResourceIcon("material/videocam");
            descriptionPanel.addBottomOption(breezeLabel2);
        }

        public static String getCameraDisplayIndex(Camera camera) {
            return camera.getFormattedCameraType();
        }
    }
}

