/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.unmixing.IResampler;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;

public class CalibratedReflectanceTargetList
implements Iterable<BandIntensity> {
    private final List<BandIntensity> list = new ArrayList<BandIntensity>();
    private final HashMap<BandNames, RtReferenceTarget> bandHashMap = new HashMap();

    public void add(int n, float f) {
        this.add(new BandIntensity(n, f));
    }

    public void add(BandIntensity bandIntensity) {
        this.list.add(bandIntensity);
    }

    public int size() {
        return this.list.size();
    }

    public BandIntensity get(int n) {
        return this.list.get(n);
    }

    public RtReferenceTarget getReferenceTarget(BandNames bandNames) {
        RtReferenceTarget rtReferenceTarget = this.bandHashMap.get(bandNames);
        if (rtReferenceTarget == null) {
            rtReferenceTarget = new RtReferenceTarget(this.interpolate(bandNames));
            this.bandHashMap.put(bandNames, rtReferenceTarget);
        }
        return rtReferenceTarget;
    }

    public float[] interpolate(BandNames bandNames) {
        float[] fArray = new float[bandNames.size()];
        for (int i = 0; i < bandNames.size(); ++i) {
            float f = RtDataFormat.toNumberFloat(bandNames.get(i));
            fArray[i] = this.interpolate(f);
        }
        return fArray;
    }

    private float interpolate(float f) {
        if (this.list.isEmpty()) {
            return f;
        }
        IResampler.LinearResampler linearResampler = new IResampler.LinearResampler();
        for (int i = 0; i < this.list.size(); ++i) {
            int n = this.list.get((int)i).band;
            if (!((float)n > f)) continue;
            float f2 = this.list.get((int)i).intensity;
            if (i > 0) {
                int n2 = this.list.get((int)(i - 1)).band;
                float f3 = this.list.get((int)(i - 1)).intensity;
                if (n > n2) {
                    return linearResampler.interpolate(n2, n, f3, f2, f);
                }
            }
            return f2;
        }
        return this.list.get((int)(this.list.size() - 1)).intensity;
    }

    public String toArgument() {
        StringBuffer stringBuffer = new StringBuffer();
        for (BandIntensity bandIntensity : this.list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(RtDataFormat.toString(bandIntensity.band));
            stringBuffer.append(";");
            stringBuffer.append(RtDataFormat.toString(bandIntensity.intensity));
        }
        return stringBuffer.toString();
    }

    public static CalibratedReflectanceTargetList fromTargetFile(File file) {
        return CalibratedReflectanceTargetList.fromTargetFile(file, 0);
    }

    public static CalibratedReflectanceTargetList fromTargetFile(File file, int n) {
        if (file != null && file.exists()) {
            try {
                CalibratedReflectanceTargetList calibratedReflectanceTargetList = new CalibratedReflectanceTargetList();
                if (PPImportDataHelper.isRawFile(file)) {
                    RawFileImpl rawFileImpl = new RawFileImpl(file);
                    FrameListFromRaw frameListFromRaw = rawFileImpl.readFrames();
                    BandNames bandNames = rawFileImpl.header().bandNames();
                    for (int i = 0; i < bandNames.size(); ++i) {
                        calibratedReflectanceTargetList.add(BandIntensity.from(bandNames.get(i), ((RawFrame)frameListFromRaw.get(n)).getFrameValue(0, i)));
                    }
                } else {
                    List<String> list = Files.readAllLines(file.toPath(), Charset.defaultCharset());
                    if (Reference.isMultiple(list.get(0))) {
                        ArrayList<Reference> arrayList = new ArrayList<Reference>();
                        Reference.readMultiple(list, arrayList);
                        Reference reference = arrayList.get(n);
                        float[] fArray = reference.getWavelength();
                        FloatMatrix floatMatrix = reference.getMatrix();
                        for (int i = 0; i < fArray.length; ++i) {
                            calibratedReflectanceTargetList.add(BandIntensity.from(RtDataFormat.toString(fArray[i]), floatMatrix.get(i, 0)));
                        }
                    } else {
                        int n2 = CalibratedReflectanceTargetList.getFirstLineWithData(list);
                        String string = list.get(n2);
                        String string2 = CalibratedReflectanceTargetList.getDelimiter(string);
                        if (string2 == null) {
                            int n3 = Integer.parseInt(string);
                            for (int i = 1; i <= n3; ++i) {
                                calibratedReflectanceTargetList.add(BandIntensity.from(list.get(i), list.get(i + n3)));
                            }
                        } else {
                            for (int i = n2; i < list.size(); ++i) {
                                String[] stringArray = list.get(i).split(string2);
                                if (stringArray.length != 2) continue;
                                calibratedReflectanceTargetList.add(BandIntensity.from(stringArray[0], stringArray[1]));
                            }
                        }
                    }
                }
                return calibratedReflectanceTargetList;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    private static int getFirstLineWithData(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).trim();
            int n = 0;
            for (char c : string.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                ++n;
            }
            double d = (double)n / (double)string.length();
            if (!(d > 0.5)) continue;
            return i;
        }
        throw new RuntimeException("No data found in reflectance target calibration file");
    }

    private static String getDelimiter(String string) {
        if (string.contains(";")) {
            return ";";
        }
        if (string.contains(",") && string.contains(".")) {
            return ",";
        }
        return null;
    }

    @Override
    public Iterator<BandIntensity> iterator() {
        return this.list.iterator();
    }

    public static class BandIntensity {
        public final int band;
        public final float intensity;

        public BandIntensity(int n, float f) {
            this.band = n;
            this.intensity = f;
        }

        public static BandIntensity from(String string, String string2) {
            return BandIntensity.from(string, RtDataFormat.toNumberFloat(string2));
        }

        public static BandIntensity from(String string, float f) {
            if (f > 1.0f) {
                f *= 0.01f;
            }
            return new BandIntensity(RtDataFormat.toNumberInt(string), f);
        }
    }
}

