/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.Temperature;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.CameraHelper;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.DeeTeeCamera;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.PredikteraSimulatorCamera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.samplemover.tray.CameraIndexSampleMover;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public interface Camera
extends Hardware {
    public boolean hasShutter();

    public void openShutter();

    public void closeShutter();

    public boolean isShutterOpened();

    public PixelWidth getWidth();

    public BandCount getBandCount();

    public RgbBands getRgbBands();

    public Integer getReadoutTime();

    public DataSize getDataSize();

    public MaxSignal getMaxsignal();

    public BandNames getBandNames();

    public FieldOfView getFieldOfView();

    public FrameRate getFrameRate();

    public FrameRate getMaxFrameRate();

    public IntegrationTime getIntegrationTime();

    public MeasurementLength getMeasurementLength();

    public Temperature getTemperature();

    public DrReMatrix getDrReMatrix();

    public boolean isFlipped();

    public void startCapture(FrameCount var1, CaptureCallback var2);

    public void setFieldOfView(FieldOfView var1);

    public boolean canChangeView();

    default public Resolution getResolution() {
        return new Resolution(this.getFieldOfView(), this.getWidth());
    }

    public void setFrameRate(FrameRate var1);

    public void setIntegrationTime(IntegrationTime var1);

    public boolean useReferencesWhenRecordingWithThisCamera();

    public String getXmlNodeName();

    public String getDeviceName();

    public void preCaptureWarmup();

    public int getId();

    public LengthValue getOffset();

    public String formatType();

    public CameraType getCameraType();

    public CameraCaptureType getType();

    public boolean isFrameRateAndIntegrationTimeConnected();

    default public boolean isIntegrationTimeFixed() {
        return false;
    }

    default public boolean isFrameRateFixed() {
        return false;
    }

    default public boolean isFieldOfViewFixed() {
        return false;
    }

    public String getFormattedCameraType();

    default public boolean takeDarkAfterMeasurement() {
        return false;
    }

    public static LengthValue withOffset(float f, Camera camera) {
        LengthValue lengthValue = new LengthValue(f);
        if (camera != null) {
            return lengthValue.withOffset(camera.getOffset());
        }
        return lengthValue;
    }

    public static boolean isXray(Camera camera) {
        if (camera instanceof DeeTeeCamera) {
            return true;
        }
        if (camera instanceof PredikteraSimulatorCamera) {
            PredikteraSimulatorCamera predikteraSimulatorCamera = (PredikteraSimulatorCamera)camera;
            if (camera.isConnected() && camera.getBandCount().value == 2) {
                int n = ((PredikteraSimulatorCamera.PredikteraSimulatorSettings)predikteraSimulatorCamera.getSettings()).getBaseLineOffset();
                return n > 0;
            }
        }
        return false;
    }

    default public boolean isRgb() {
        return this.getBandCount().value == 3 && this.getMaxsignal().value == 255.0f;
    }

    public static String getCameraTypeName(Camera camera) {
        return Camera.getCameraTypeName(camera, camera.toString());
    }

    public static String getCameraTypeName(Camera camera, String string) {
        if (camera != null) {
            String string2 = camera.getFormattedCameraType();
            if (string2.equals("FileReader")) {
                String string3 = "File reader";
                if (camera instanceof PredikteraSimulatorCamera) {
                    string3 = "Simulator camera";
                }
                if (HardwareRegistry.hasSecondCamera()) {
                    return string3 + " (" + (camera.getId() + 1) + ")";
                }
                return string3;
            }
            return string2;
        }
        return string;
    }

    public static boolean connected(Camera camera) {
        return camera != null && camera.isConnected();
    }

    public static boolean isHySpexOrTest(Camera camera) {
        return camera instanceof HySpexCamera || camera instanceof CameraIndexSampleMover;
    }

    default public SpectralReference.DarkReference getDarkReference() {
        return ReferenceHelper.getDarkReference(this);
    }

    default public SpectralReference.WhiteReference getWhiteReference() {
        return ReferenceHelper.getWhiteReference(this);
    }

    public static class MirrorLineInputField
    extends BreezeCheckBoxInputField {
        public MirrorLineInputField(RemoteCameraTypeSettings remoteCameraTypeSettings) {
            super("Mirror line", remoteCameraTypeSettings.isFlipPixels(), remoteCameraTypeSettings::setFlipPixels);
        }
    }

    public static enum FpsUnit {
        framePeriod,
        framesPerSecond;


        public static FpsUnit parse(String string) {
            for (FpsUnit fpsUnit : FpsUnit.values()) {
                if (!fpsUnit.name().equalsIgnoreCase(string)) continue;
                return fpsUnit;
            }
            return framePeriod;
        }
    }

    public static enum TransformAlgorithm {
        CompressReferences("Compress references"),
        PixelMask("Mask pixels"),
        RotateLeft("Rotate left"),
        RotateRight("Rotate right"),
        Smooth("Smooth"),
        SpectrumMask("Mask wavelength"),
        None("None"),
        SurfAndRansac("SURF and RANSAC with detector jump adjustment"),
        SiftAndRansac("SIFT and RANSAC with detector jump adjustment"),
        OrbAndRansac("ORB and RANSAC with detector jump adjustment"),
        ContourCentroids("Contours-based alignment using centroid with detector jump adjustment"),
        DetectorJump("Detector jump adjustment only");

        private final String name;

        private TransformAlgorithm(String string2) {
            this.name = string2;
        }

        public static TransformAlgorithm parse(String string) {
            for (TransformAlgorithm transformAlgorithm : TransformAlgorithm.values()) {
                if (!transformAlgorithm.name().equalsIgnoreCase(string)) continue;
                return transformAlgorithm;
            }
            return TransformAlgorithm.defaultValue();
        }

        public static TransformAlgorithm[] getMergeRealignmentAlgorithms() {
            return new TransformAlgorithm[]{None, SurfAndRansac, SiftAndRansac, OrbAndRansac, ContourCentroids, DetectorJump};
        }

        public static TransformAlgorithm defaultValue() {
            return SurfAndRansac;
        }

        public boolean hasOptions() {
            return this.equals((Object)SurfAndRansac) || this.equals((Object)SiftAndRansac) || this.equals((Object)OrbAndRansac) || this.equals((Object)ContourCentroids);
        }

        public String toString() {
            return this.name;
        }

        public static String getAlgorithmOptions(TransformAlgorithm transformAlgorithm) {
            return switch (transformAlgorithm.ordinal()) {
                case 7 -> BreezeProperties.getInstance().getMultiCameraSurfRealignmentOptions();
                case 8 -> BreezeProperties.getInstance().getMultiCameraSiftRealignmentOptions();
                case 9 -> BreezeProperties.getInstance().getMultiCameraOrbRealignmentOptions();
                case 10 -> BreezeProperties.getInstance().getMultiCameraContourRealignmentOptions();
                default -> "";
            };
        }

        public static void setAlgorithmOptions(TransformAlgorithm transformAlgorithm, String string) {
            switch (transformAlgorithm.ordinal()) {
                case 7: {
                    BreezeProperties.getInstance().setMultiCameraSurfRealignmentOptions(string);
                    break;
                }
                case 8: {
                    BreezeProperties.getInstance().setMultiCameraSiftRealignmentOptions(string);
                    break;
                }
                case 9: {
                    BreezeProperties.getInstance().setMultiCameraOrbRealignmentOptions(string);
                    break;
                }
                case 10: {
                    BreezeProperties.getInstance().setMultiCameraContourRealignmentOptions(string);
                    break;
                }
                default: {
                    throw new RuntimeException("Not implemented");
                }
            }
        }

        public static String getAlgorithmOptionsHelpString(TransformAlgorithm transformAlgorithm) {
            return switch (transformAlgorithm.ordinal()) {
                case 7 -> "hessianThreshold;nOctaves;nOctaveLayers";
                case 8 -> "nFeatures;nOctaveLayers;contrastThreshold;edgeThreshold;sigma";
                case 9 -> "nFeatures;scaleFactor;nLevels;edgeThreshold;firstLevel;wtaK;patchSize;fastThreshold";
                case 10 -> "preprocess1;preprocess2;...;preprocessN";
                default -> "";
            };
        }
    }

    public record MultiCameraSetting(MultiCameraMode mode, int index) {
        public static MultiCameraSetting parse(String string, int n) {
            return new MultiCameraSetting(MultiCameraMode.parse(string), n);
        }

        @Override
        public String toString() {
            if (this.mode().isSingle()) {
                return String.valueOf((Object)this.mode()) + "_" + this.index();
            }
            return this.mode().toString();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof MultiCameraSetting) {
                MultiCameraSetting multiCameraSetting = (MultiCameraSetting)object;
                return this.index == multiCameraSetting.index && this.mode == multiCameraSetting.mode;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.mode, this.index});
        }
    }

    public static enum MultiCameraMode {
        Parallel,
        ScaleUp,
        ScaleDown,
        Single,
        SeparateFiles;


        public static MultiCameraMode parse(String string) {
            for (MultiCameraMode multiCameraMode : MultiCameraMode.values()) {
                if (!multiCameraMode.name().equalsIgnoreCase(string)) continue;
                return multiCameraMode;
            }
            return MultiCameraMode.defaultValue();
        }

        public static MultiCameraMode defaultValue() {
            return SeparateFiles;
        }

        public boolean isScale() {
            return this.equals((Object)ScaleUp) || this.equals((Object)ScaleDown);
        }

        public boolean isMulti() {
            return !this.isSingle();
        }

        public boolean isSingle() {
            return this.equals((Object)Single);
        }

        public String toString() {
            return StringHelper.formatLabel(this.name());
        }

        public MultiCameraSetting toSetting() {
            return new MultiCameraSetting(this, 0);
        }

        public static String getDescription(MultiCameraMode multiCameraMode) {
            return switch (multiCameraMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Data from identical cameras mounted side by side are merged along the x-direction resulting in a wider image.";
                case 2 -> "Data is scaled down to the lowest camera resolution before merging.";
                case 1 -> "Data is scaled up to the highest camera resolution before merging.";
                case 3 -> "The single selected camera is used.";
                case 4 -> "Data is recorded separately for each camera without merging.";
            };
        }
    }

    public static enum CameraCaptureType {
        Snapshot("Snapshot scan"),
        Linescan("Line scan (Push-broom)");

        private final String description;

        private CameraCaptureType(String string2) {
            this.description = string2;
        }

        public boolean isSingleLine() {
            return this.equals((Object)Linescan);
        }

        public String toString() {
            return this.description;
        }
    }

    public static class OffsetInputField
    extends BreezeSpinnerInputPanel {
        public OffsetInputField(BreezeFrame breezeFrame, RemoteCamera remoteCamera, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this(breezeFrame, remoteCamera, settingsPanelCallback, BreezeInputFieldHelper.Format.OneRow);
        }

        public OffsetInputField(BreezeFrame breezeFrame, RemoteCamera remoteCamera, Hardware.SettingsPanelCallback settingsPanelCallback, BreezeInputFieldHelper.Format format) {
            super("Offset location (" + HardwareRegistry.getInstance().getSampleMoverUnit() + ")", "", 0.0f, 9999999.0f, 1.0f, remoteCamera.getOffset().value, format, BreezeSpinner.NumberInputLocation.LEFT, "");
            if (format == BreezeInputFieldHelper.Format.OneRow) {
                this.setUsage("Distance offset between camera and sample mover position");
            } else {
                this.setToolTipText("Distance offset between camera and sample mover position");
            }
            this.addCallback(d -> {
                float f = d.floatValue();
                ((RemoteCameraTypeSettings)remoteCamera.getSettings()).setOffset(f);
                if (remoteCamera.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)remoteCamera, "Offset", f);
                }
                if (settingsPanelCallback != null) {
                    settingsPanelCallback.reloadInformation();
                }
            });
        }
    }

    public static class FieldOfViewInputField
    extends BreezeSpinnerInputPanel {
        private Camera camera;

        public FieldOfViewInputField(BreezeFrame breezeFrame, Camera camera, AbstractRateTimeInputField.OnChangeListener onChangeListener) {
            super("Field of view (" + HardwareRegistry.getInstance().getSampleMoverUnit() + ")", "", 1.0f, 9999999.0f, 1.0f, 1.0f, "");
            this.setName("fieldofview");
            this.setCamera(camera);
            this.addCallback(d -> {
                this.camera.setFieldOfView(new FieldOfView(d.floatValue()));
                if (onChangeListener != null) {
                    onChangeListener.onChange();
                }
                SampleMover.checkForMaxSpeedWarning(breezeFrame, this.getTextArea(), this.camera);
            });
        }

        public void setCamera(Camera camera) {
            this.camera = camera;
            if (camera != null && camera.isConnected()) {
                this.setValue(camera.getFieldOfView().value);
                this.setEnabled(camera.canChangeView());
            } else {
                this.setText("Camera not connected");
                this.setEnabled(false);
            }
        }
    }

    public static class FramesToAverageInputField
    extends AbstractRateTimeInputField {
        public FramesToAverageInputField(BreezeFrame breezeFrame, Camera camera, CameraStreamGrabber cameraStreamGrabber, AbstractRateTimeInputField.OnChangeListener onChangeListener, ConnectedFields connectedFields) {
            super(breezeFrame, camera, cameraStreamGrabber, onChangeListener, "Frames to average", connectedFields, 1.0f, 1.0f);
        }

        @Override
        protected void setValueToCamera(Camera camera, float f) {
            FramesToAverageInputField.setFrameToAverage(camera, f);
        }

        public static void setFrameToAverage(Camera camera, float f) {
            float f2 = camera.getFrameRate().value;
            int n = ((IFramesToAverage)camera).getFramesToAverage();
            FrameRate frameRate = camera.getMaxFrameRate();
            float f3 = f / (float)n;
            int n2 = (int)(frameRate.value / f2);
            if (f3 > (float)n2) {
                f3 = n2;
                f = f3 * (float)n;
            }
            FrameRate frameRate2 = new FrameRate(Math.min(frameRate.value, f2 * f3));
            ((IFramesToAverage)camera).setFramesToAverage((int)Math.max(1.0f, f));
            camera.setFrameRate(frameRate2);
        }

        @Override
        protected void setValueFromCamera(Camera camera, boolean bl) {
            if (camera.isConnected()) {
                this.setValue(((IFramesToAverage)camera).getFramesToAverage());
            }
        }
    }

    public static class IntegrationTimeInputField
    extends AbstractRateTimeInputField {
        public IntegrationTimeInputField(BreezeFrame breezeFrame, Camera camera, CameraStreamGrabber cameraStreamGrabber, AbstractRateTimeInputField.OnChangeListener onChangeListener, ConnectedFields connectedFields) {
            super(breezeFrame, camera, cameraStreamGrabber, onChangeListener, "Integration time (\u03bcs)", connectedFields, 100.0f, 1.0f);
        }

        @Override
        protected void setValueToCamera(Camera camera, float f) {
            camera.setIntegrationTime(new IntegrationTime(f));
        }

        @Override
        protected void setValueFromCamera(Camera camera, boolean bl) {
            if (camera.isConnected()) {
                if (bl) {
                    this.setValue(camera.getIntegrationTime().value);
                } else {
                    this.setValueNoTrigger(camera.getIntegrationTime().value);
                }
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }
    }

    public static class FramePeriodInputField
    extends AbstractRateTimeInputField {
        public FramePeriodInputField(BreezeFrame breezeFrame, Camera camera, CameraStreamGrabber cameraStreamGrabber, AbstractRateTimeInputField.OnChangeListener onChangeListener, ConnectedFields connectedFields) {
            super(breezeFrame, camera, cameraStreamGrabber, onChangeListener, "Frame period (\u03bcs/f)", connectedFields, 100.0f, 1.0f);
        }

        @Override
        protected void setValueToCamera(Camera camera, float f) {
            camera.setFrameRate(FrameRate.fromFramePeriod(f));
        }

        @Override
        protected void setValueFromCamera(Camera camera, boolean bl) {
            if (camera.isConnected()) {
                this.setValue(camera.getFrameRate().framePeriodFloat());
            }
        }
    }

    public static class FrameRateInputField
    extends AbstractRateTimeInputField {
        public FrameRateInputField(BreezeFrame breezeFrame, Camera camera, CameraStreamGrabber cameraStreamGrabber, AbstractRateTimeInputField.OnChangeListener onChangeListener, ConnectedFields connectedFields) {
            super(breezeFrame, camera, cameraStreamGrabber, onChangeListener, "Frame rate (fps)", connectedFields, 1.0f, 1.0f);
            this.setName("framerate");
            this.setToolTipText("Note: Sample mover speed is calculated from frame rate and field of view.");
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }

        @Override
        protected void setValueToCamera(Camera camera, float f) {
            camera.setFrameRate(new FrameRate(f));
        }

        @Override
        protected void setValueFromCamera(Camera camera, boolean bl) {
            if (camera.isConnected()) {
                this.setValue(camera.getFrameRate().value);
            }
        }
    }

    public static abstract class AbstractRateTimeInputField
    extends BreezeSpinnerInputPanel {
        private final BreezeFrame frame;
        private final CameraStreamGrabber grabber;
        private final OnChangeListener listener;
        private final ConnectedFields connectedFields;
        private Camera camera;

        public AbstractRateTimeInputField(BreezeFrame breezeFrame, Camera camera, CameraStreamGrabber cameraStreamGrabber, OnChangeListener onChangeListener, String string, ConnectedFields connectedFields, float f, float f2) {
            super(string, "", f2, 9999999.0f, f, 1.0f, BreezeInputFieldHelper.Format.TwoRows, BreezeSpinner.NumberInputLocation.LEFT, "");
            this.camera = camera;
            this.frame = breezeFrame;
            this.grabber = cameraStreamGrabber;
            this.listener = onChangeListener;
            this.connectedFields = connectedFields;
            connectedFields.add(this);
            this.setCamera(camera);
            this.setName(StringHelper.removeSpace(string.toLowerCase()));
            this.addCallback(this::onChange);
        }

        private void onChange(Double d) {
            boolean bl = false;
            if (this.grabber != null && (bl = this.grabber.isRunning())) {
                this.grabber.stop();
            }
            this.setValueToCamera(this.camera, d.floatValue());
            if (HardwareRegistry.hasMultiModeCameras() && !BreezeProperties.getInstance().isExpertMode()) {
                Logg.debug((String)("Aligning multiple cameras for camera id " + this.camera.getId() + " : " + this.getName() + ":" + d), (Object[])new Object[0]);
                CameraHelper.alignCameras(this.camera);
            }
            if (this.grabber != null && bl) {
                this.grabber.startGrab(this.camera);
            }
            if (this.listener != null) {
                this.listener.onChange();
            }
            this.setValueFromCamera(this.camera, false);
            SampleMover.checkForMaxSpeedWarning(this.frame, this.getTextArea(), this.camera);
            if (this.connectedFields != null) {
                for (AbstractRateTimeInputField abstractRateTimeInputField : this.connectedFields) {
                    if (abstractRateTimeInputField == this) continue;
                    abstractRateTimeInputField.setValueFromCamera(abstractRateTimeInputField.getCamera(), false);
                }
            }
            if (this.listener != null) {
                this.listener.onChange();
            }
        }

        protected abstract void setValueToCamera(Camera var1, float var2);

        protected abstract void setValueFromCamera(Camera var1, boolean var2);

        public void setCamera(Camera camera) {
            this.camera = camera;
            if (camera != null && camera.isConnected()) {
                this.setValueFromCamera(camera, true);
                this.setEnabled(true);
            } else {
                this.setText("Camera not connected");
                this.setEnabled(false);
            }
        }

        @Generated
        public Camera getCamera() {
            return this.camera;
        }

        public static interface OnChangeListener {
            public void onChange();
        }
    }

    public static class ConnectedFields
    extends ArrayList<AbstractRateTimeInputField> {
    }

    public static class FailedToConnectException
    extends RuntimeException {
        public FailedToConnectException(String string) {
            this(string, true);
        }

        public FailedToConnectException(String string, boolean bl) {
            super(string + (bl ? "\n\nPlease ensure all cables are firmly attached and the hardware is powered on, then try connecting again" : ""));
        }

        public static FailedToConnectException create(Object object, CommandReply commandReply) {
            StringBuilder stringBuilder = new StringBuilder("\n\n");
            if (object != null) {
                stringBuilder.append("Hardware: ");
                stringBuilder.append(object);
                stringBuilder.append("\n");
            }
            stringBuilder.append(commandReply.getMessage());
            if (commandReply.getCode() == 3005) {
                return new FailedToConnectException(stringBuilder.toString(), false);
            }
            return new FailedToConnectException(stringBuilder.toString());
        }
    }

    public static interface SnapshotCamera
    extends Camera {
        public FrameCount getHeight();
    }

    public static interface SetMeasureLengthCamera
    extends Camera {
        public void setMeasureLength(MeasurementLength var1);

        public boolean canChangeLength();
    }

    public static class DefaultCaptureCallback
    implements CaptureCallback {
        @Override
        public void onStart(CaptureControl captureControl) {
        }

        @Override
        public void onFrame(FrameStack frameStack, CaptureControl captureControl) {
        }

        @Override
        public void onError(CaptureControl captureControl, Exception exception) {
        }

        @Override
        public void onStop() {
        }
    }

    public static interface CaptureControl {
        public void stop();
    }

    public static interface CaptureCallback {
        public void onStart(CaptureControl var1);

        public void onFrame(FrameStack var1, CaptureControl var2);

        public void onError(CaptureControl var1, Exception var2);

        public void onStop();
    }

    public static interface ICameraMode {
        public CameraMode getCameraMode();

        public CameraMode.CameraModeInputField createCameraModeField(Hardware.SettingsPanelCallback var1);
    }

    public static interface WhiteReferenceIntensity
    extends Camera {
        public File getWhiteReferenceTargetFile();

        public void setWhiteReferenceTargetFile(File var1);

        public RtReferenceTarget getReferenceTarget();
    }
}

