/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.CameraHelper;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.samplemover.tray.SimulatorSampleMoverTray;
import se.prediktera.breeze.test.MockBreezeTestProperties;

public class CameraAlignmentTest
extends MockBreezeTestProperties {
    private FakeCamera c1;
    private FakeCamera c2;

    @Before
    public void before() {
        this.c1 = new FakeCamera.FakeCameraWithSetFieldOfView(this){

            @Override
            public void setFrameRate(FrameRate frameRate) {
                super.setFrameRate(frameRate);
                if (frameRate.framePeriodFloat() < this.getIntegrationTime().value) {
                    this.setIntegrationTime(new IntegrationTime(frameRate.framePeriodFloat() - (float)this.getReadoutTime().intValue()));
                }
            }
        };
        this.c1.setReadoutTime(2);
        this.c1.setWidth(new PixelWidth(1800));
        this.c1.setFieldOfView(new FieldOfView(1684.0f));
        this.c1.setFrameRate(FrameRate.fromFramePeriod(2500.0f));
        this.c1.setIntegrationTime(new IntegrationTime(1000.0f));
        this.c2 = new FakeCamera.FakeCameraWithSetFieldOfView(this){

            @Override
            public void setFrameRate(FrameRate frameRate) {
                super.setFrameRate(frameRate);
                if (frameRate.framePeriodFloat() < this.getIntegrationTime().value) {
                    this.setIntegrationTime(new IntegrationTime(frameRate.framePeriodFloat() - (float)this.getReadoutTime().intValue()));
                }
            }
        };
        this.c2.setReadoutTime(200);
        this.c2.setId(1);
        this.c2.setWidth(new PixelWidth(450));
        this.c2.setFieldOfView(new FieldOfView(1684.0f));
        this.c2.setFrameRate(FrameRate.fromFramePeriod(14000.0f));
        this.c2.setIntegrationTime(new IntegrationTime(1000.0f));
        HardwareRegistry.getInstance().setRemoteCamera(this.c1, 0);
        HardwareRegistry.getInstance().setRemoteCamera(this.c2, 1);
        HardwareRegistry.getInstance().switchToSampleMover(new SimulatorSampleMoverTray());
    }

    @After
    public void after() {
        HardwareRegistry.disconnectAndClearInstance(BreezeProgressManager.createEmpty());
    }

    @Test
    public void dualCameraScaleDownTest() {
        BreezeProperties.getInstance().setMultiCameraSetting(new Camera.MultiCameraSetting(Camera.MultiCameraMode.ScaleDown, 0));
        CameraHelper.alignCameras(this.c1);
        MatcherAssert.assertThat((String)"Align sets c2 frame period to the same as c1", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)2500.0, (double)5.0)));
    }

    @Test
    public void dualCameraParallelTest() {
        BreezeProperties.getInstance().setMultiCameraSetting(new Camera.MultiCameraSetting(Camera.MultiCameraMode.Parallel, 0));
        CameraHelper.alignCameras(this.c1);
        MatcherAssert.assertThat((String)"Align sets c2 frame period to the same as c1", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)2500.0, (double)5.0)));
    }

    @Test
    public void dualCameraSeparateFilesIntegrationTimeTest() {
        BreezeProperties.getInstance().setMultiCameraSetting(new Camera.MultiCameraSetting(Camera.MultiCameraMode.SeparateFiles, 0));
        this.c1.setIntegrationTime(new IntegrationTime(3500.0f));
        CameraHelper.alignCameras(this.c1);
        MatcherAssert.assertThat((String)"Align does not change c1 'frames to average'", (Object)this.c1.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align does not change c1 frame period", (Object)this.c1.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)2500.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align does not change c2 'frames to average'", (Object)this.c2.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align does not change c2 frame period", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)10000.0, (double)5.0)));
        this.c2.setIntegrationTime(new IntegrationTime(5000.0f));
        CameraHelper.alignCameras(this.c2);
        MatcherAssert.assertThat((String)"Align does not change c1 'frames to average'", (Object)this.c1.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align does not change c1 frame period", (Object)this.c1.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)2500.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align does not change c2 'frames to average'", (Object)this.c2.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align does not change c2 frame period", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)10000.0, (double)5.0)));
    }

    @Test
    public void dualCameraSeparateFilesFPSAndFramesToAverageTest() {
        BreezeProperties.getInstance().setMultiCameraSetting(new Camera.MultiCameraSetting(Camera.MultiCameraMode.SeparateFiles, 0));
        this.c1.setIntegrationTime(new IntegrationTime(16996.0f));
        this.c1.setFrameRate(FrameRate.fromFramePeriod(17000.0f));
        this.c2.setIntegrationTime(new IntegrationTime(5400.0f));
        CameraHelper.alignCameras(this.c1);
        MatcherAssert.assertThat((Object)this.c1.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.c2.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align c1 changes c2 frame period", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)68000.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align c1 does not change c2 integration time", (Object)this.c2.getIntegrationTime().value, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)5400.0, (double)5.0)));
        Camera.FramesToAverageInputField.setFrameToAverage(this.c2, 13.0f);
        CameraHelper.alignCameras(this.c2);
        MatcherAssert.assertThat((String)"Align c2 does not change c1", (Object)this.c1.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)17000.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align c2 does not change c1", (Object)this.c1.getIntegrationTime().value, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)16996.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align c2 changes c2", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)5232.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align c2 changes c2", (Object)this.c2.getIntegrationTime().value, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)5032.0, (double)5.0)));
        Camera.FramesToAverageInputField.setFrameToAverage(this.c2, 14.0f);
        CameraHelper.alignCameras(this.c2);
        MatcherAssert.assertThat((String)"Align c2 with different 'frames to 'average' changes c2 differently", (Object)this.c2.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)4858.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align c2 with different 'frames to 'average' changes c2 differently", (Object)this.c2.getIntegrationTime().value, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)4658.0, (double)5.0)));
    }

    @Test
    public void singleCameraTest() {
        HardwareRegistry.getInstance().setRemoteCamera(null, 1);
        this.c1.setIntegrationTime(new IntegrationTime(3500.0f));
        CameraHelper.alignCameras(this.c1);
        this.c1.setFrameRate(FrameRate.fromFramePeriod(12000.0f));
        CameraHelper.alignCameras(this.c1);
        MatcherAssert.assertThat((String)"Align does not happen for single camera", (Object)this.c1.getFramesToAverage(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Align does not happen for single camera", (Object)this.c1.getFrameRate().framePeriodFloat(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)12000.0, (double)5.0)));
        MatcherAssert.assertThat((String)"Align does not happen for single camera", (Object)this.c1.getIntegrationTime().value, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)3500.0, (double)5.0)));
    }
}

