/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import java.util.List;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;

public class CameraHelper {
    public static void alignCameras(Camera camera) {
        if (!HardwareRegistry.hasMultiModeCameras()) {
            return;
        }
        SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
        if (sampleMover != null && HardwareRegistry.hasMultiModeCameras()) {
            FrameRate frameRate = camera.getFrameRate();
            List<Camera> list = HardwareRegistry.getInstance().getCameras();
            for (Camera camera2 : list) {
                if (camera2 == camera || !camera2.isConnected()) continue;
                Camera.MultiCameraMode multiCameraMode = BreezeProperties.getInstance().getMultiCameraSetting().mode();
                if (multiCameraMode.equals((Object)Camera.MultiCameraMode.Parallel) || multiCameraMode.equals((Object)Camera.MultiCameraMode.ScaleDown)) {
                    camera2.setFrameRate(frameRate);
                    continue;
                }
                if (!multiCameraMode.equals((Object)Camera.MultiCameraMode.SeparateFiles)) continue;
                camera2.setFrameRate(FrameRate.calculateTargetFrameRate(camera, camera2));
            }
        }
    }
}

