/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.AbstractCamera;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.AlliedVisionCamera;
import se.prediktera.breeze.hardware.camera.BaslerCamera;
import se.prediktera.breeze.hardware.camera.DeeTeeCamera;
import se.prediktera.breeze.hardware.camera.HaipCamera;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.HySpexLineProfiler;
import se.prediktera.breeze.hardware.camera.HySpexTelopCamera;
import se.prediktera.breeze.hardware.camera.IDSCamera;
import se.prediktera.breeze.hardware.camera.InnoSpecCamera;
import se.prediktera.breeze.hardware.camera.InnoSpecPhotonFocusCamera;
import se.prediktera.breeze.hardware.camera.PredikteraDataServerCamera;
import se.prediktera.breeze.hardware.camera.PredikteraSimulatorCamera;
import se.prediktera.breeze.hardware.camera.QtechnologyCamera;
import se.prediktera.breeze.hardware.camera.SonyCamera;
import se.prediktera.breeze.hardware.camera.SpecimCamera;
import se.prediktera.breeze.hardware.camera.SpecimJsonRpcCamera;
import se.prediktera.breeze.hardware.camera.UnispectralCamera;
import se.prediktera.breeze.hardware.camera.rgb.RgbUsbCamera;
import se.prediktera.breeze.hardware.samplemover.GenericSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.HySpexCoreScannerTable;
import se.prediktera.breeze.hardware.samplemover.tray.HySpexStepperTable;
import se.prediktera.breeze.hardware.samplemover.tray.InnoSpecStepperTable;
import se.prediktera.breeze.hardware.samplemover.tray.LabScanner;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.SisuCHEMA;
import se.prediktera.breeze.hardware.samplemover.tray.ViaSpecII;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.UmbioInspector;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class HardwareRegistry {
    public static int MaxSupportedCameras = 9;
    private static HardwareRegistry instance = null;
    private List<String> availableCameras;
    private final PredikteraSimulatorCamera defaultCamera;
    private final List<CameraList> cameraLists = new ArrayList<CameraList>();
    private final SampleMoverList sampleMoverList;
    private final HashMap<Integer, Camera> cameraHashMap = new HashMap();
    private SampleMover selectedSampleMover;

    public static void disconnectAndClearInstance(BreezeProgressManager breezeProgressManager) {
        if (instance != null) {
            HardwareRegistry.getInstance().disconnect(breezeProgressManager);
            instance = null;
        }
    }

    public static synchronized HardwareRegistry getInstance() {
        if (instance == null) {
            instance = new HardwareRegistry();
        }
        return instance;
    }

    public HardwareRegistry() {
        for (int i = 0; i < BreezeProperties.getInstance().getNumberOfCameras(); ++i) {
            this.cameraLists.add(this.createCameraList(i));
        }
        this.defaultCamera = (PredikteraSimulatorCamera)this.cameraLists.getFirst().get(0);
        this.sampleMoverList = new SampleMoverList(new InnoSpecStepperTable(), new ViaSpecII(), new SisuCHEMA(), new LabScanner(), new HySpexStepperTable(), new HySpexCoreScannerTable(), new UmbioInspector(), new GenericSampleMover());
    }

    private CameraList createCameraList(int n) {
        return new CameraList(n, new PredikteraSimulatorCamera(), new HySpexCamera(), new HySpexTelopCamera(), new HySpexLineProfiler(), new SpecimCamera(), new InnoSpecPhotonFocusCamera(), new AlliedVisionCamera("ResononAlliedVisionCamera", "Resonon Allied-based"), new BaslerCamera("ResononBaslerCamera", "Resonon Basler-based"), new IDSCamera("IDSCamera", "IDS Camera"), new DeeTeeCamera(), new SpecimJsonRpcCamera(), new BaslerCamera("BaslerCamera", "Basler Pylon SDK"), new UnispectralCamera(), new InnoSpecCamera(), new QtechnologyCamera(), new SonyCamera(), new RgbUsbCamera(), new HaipCamera(), new PredikteraDataServerCamera());
    }

    public void updateCamerasAvailable() {
        int n = BreezeProperties.getInstance().getNumberOfCameras();
        if (this.cameraLists.size() < n) {
            for (int i = this.cameraLists.size(); i < n; ++i) {
                this.cameraLists.add(this.createCameraList(i));
            }
        } else {
            for (int i = this.cameraLists.size() - 1; i >= n; --i) {
                this.cameraLists.remove(i);
                this.cameraHashMap.remove(i);
            }
        }
    }

    public List<Camera> getAvailableCameras(int n) {
        CameraList cameraList = this.getCameraList(n);
        if (this.availableCameras == null && BreezeProperties.getInstance().isBreezeRuntimeLocal()) {
            try {
                this.availableCameras = Arrays.asList(TcpManager.getInstance().getProperty("AvailableCameraProviders").split(";"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.availableCameras != null) {
            return cameraList.list.stream().filter(camera -> this.availableCameras.contains(camera.toString())).collect(Collectors.toList());
        }
        return cameraList.list;
    }

    public List<String> getAvailableCamera() {
        return this.availableCameras;
    }

    public void setAvailableCamera(List<String> list) {
        this.availableCameras = list;
    }

    public CameraList getCameraList(int n) {
        return this.cameraLists.size() > n ? this.cameraLists.get(n) : null;
    }

    public Camera getActiveCamera() {
        Camera.MultiCameraSetting multiCameraSetting;
        if (this.getSecondCamera() != null && (multiCameraSetting = BreezeProperties.getInstance().getMultiCameraSetting()).mode().equals((Object)Camera.MultiCameraMode.Single)) {
            return this.getCamera(multiCameraSetting.index());
        }
        return this.getFirstCamera();
    }

    public boolean anyCameraHasShutter() {
        return this.getCamerasForRecord().stream().anyMatch(Camera::hasShutter);
    }

    public Camera getFirstCamera() {
        return this.getCamera(0);
    }

    public Camera getSecondCamera() {
        return this.getCamera(1);
    }

    public List<Camera> getCamerasForRecord() {
        if (HardwareRegistry.hasMultiModeCameras()) {
            ArrayList<Camera> arrayList = new ArrayList<Camera>();
            for (int i = 0; i < this.cameraLists.size(); ++i) {
                Camera camera = this.getCamera(i);
                if (camera == null) continue;
                arrayList.add(camera);
            }
            return arrayList;
        }
        return Collections.singletonList(this.getActiveCamera());
    }

    public List<Camera> getCameras() {
        ArrayList<Camera> arrayList = new ArrayList<Camera>(this.cameraHashMap.values());
        arrayList.sort(Comparator.comparingInt(Camera::getId));
        return arrayList;
    }

    public static boolean hasSecondCamera() {
        return HardwareRegistry.getInstance().getSecondCamera() != null;
    }

    public static boolean hasMultiModeCameras() {
        if (HardwareRegistry.hasSecondCamera()) {
            return BreezeProperties.getInstance().getMultiCameraSetting().mode().isMulti();
        }
        return false;
    }

    public int getActualWidth(Camera camera) {
        if (HardwareRegistry.hasMultiModeCameras()) {
            Camera camera2 = this.getFirstCamera();
            Camera camera3 = this.getSecondCamera();
            if (camera2.isConnected() && camera3.isConnected()) {
                Camera.MultiCameraSetting multiCameraSetting = BreezeProperties.getInstance().getMultiCameraSetting();
                int n = camera2.getWidth().value;
                int n2 = camera3.getWidth().value;
                switch (multiCameraSetting.mode()) {
                    case Parallel: {
                        return n + n2;
                    }
                    case ScaleDown: {
                        return Math.min(n, n2);
                    }
                    case ScaleUp: {
                        return Math.max(n, n2);
                    }
                }
            }
        }
        return camera.getWidth().value;
    }

    public LengthValue getMinOffset() {
        return new LengthValue(Math.min(this.getFirstCamera().getOffset().value, this.getSecondCamera().getOffset().value));
    }

    public LengthValue getMaxOffset() {
        return new LengthValue(Math.max(this.getFirstCamera().getOffset().value, this.getSecondCamera().getOffset().value));
    }

    public Camera getCamera(int n) {
        if (!this.cameraHashMap.containsKey(n)) {
            String string = BreezeProperties.getInstance().getSelectedCamera(n, n == 0 ? this.defaultCamera.getXmlNodeName() : "none");
            if (string.equalsIgnoreCase("none")) {
                this.cameraHashMap.remove(n);
            } else {
                if (this.getCameraList(n) == null) {
                    return null;
                }
                Camera camera = this.getCameraList(n).getByXmlNodeName(string);
                if (camera != null) {
                    this.cameraHashMap.put(n, camera);
                }
            }
        }
        return this.cameraHashMap.get(n);
    }

    public boolean setRemoteCamera(Camera camera, int n) {
        Camera camera2 = this.cameraHashMap.get(n);
        if (camera == camera2) {
            return false;
        }
        if (camera2 != null) {
            if (camera2.isConnected()) {
                camera2.disconnect(BreezeProgressManager.createEmpty());
            }
            this.cameraHashMap.remove(n);
        }
        if (camera != null) {
            this.cameraHashMap.put(n, camera);
        }
        return true;
    }

    public void switchToCamera(Camera camera) {
        this.switchToCamera(camera, 0);
    }

    public void switchToCamera(Camera camera, int n) {
        if (this.setRemoteCamera(camera, n)) {
            BreezeProperties.getInstance().setSelectedCamera(n, camera);
        }
    }

    public SampleMover getSampleMover() {
        if (this.selectedSampleMover == null) {
            String string = BreezeProperties.getInstance().getSelectedSampleMover();
            this.selectedSampleMover = this.sampleMoverList.getByXmlNodeName(string);
        }
        return this.selectedSampleMover;
    }

    public String getSampleMoverUnit() {
        return this.getSampleMoverType().getUnit();
    }

    public RemoteSampleMoverSettings.MoverType getSampleMoverType() {
        SampleMover sampleMover = this.getSampleMover();
        if (sampleMover != null) {
            return sampleMover.getType();
        }
        return RemoteSampleMoverSettings.MoverType.Translation;
    }

    public void switchToSampleMover(SampleMover sampleMover) {
        if (sampleMover == this.selectedSampleMover) {
            return;
        }
        if (this.selectedSampleMover != null && this.selectedSampleMover.isConnected()) {
            this.selectedSampleMover.disconnect(BreezeProgressManager.createEmpty());
        }
        BreezeProperties.getInstance().setSelectedSampleMover(sampleMover);
        this.selectedSampleMover = sampleMover;
    }

    private void disconnect(BreezeProgressManager breezeProgressManager) {
        for (Camera camera : this.cameraHashMap.values()) {
            if (!camera.isConnected()) continue;
            camera.disconnect(breezeProgressManager);
        }
        if (this.selectedSampleMover != null && this.selectedSampleMover.isConnected()) {
            this.selectedSampleMover.disconnect(breezeProgressManager);
        }
    }

    @Generated
    public SampleMoverList getSampleMoverList() {
        return this.sampleMoverList;
    }

    public static class CameraList
    implements Iterable<Camera> {
        private List<Camera> list;

        public CameraList(int n, Camera ... cameraArray) {
            this.list = Arrays.asList(cameraArray);
            for (Camera camera : this.list) {
                if (!(camera instanceof AbstractCamera)) continue;
                ((AbstractCamera)camera).setId(n);
            }
        }

        public Camera getByXmlNodeName(String string) {
            Optional<Camera> optional = this.list.stream().filter(camera -> camera.getXmlNodeName().equals(string)).findAny();
            return optional.orElseGet(() -> this.list.getFirst());
        }

        public Camera getByDeviceName(String string) {
            Optional<Camera> optional = this.list.stream().filter(camera -> camera.getDeviceName().equals(string) || camera.toString().equals(string)).findAny();
            return optional.orElseGet(() -> this.list.getFirst());
        }

        @Override
        @NonNull
        public Iterator<Camera> iterator() {
            return this.list.iterator();
        }

        public Camera get(int n) {
            return this.list.get(n);
        }

        public void add(Camera camera) {
            this.list = new ArrayList<Camera>(this.list);
            this.list.add(camera);
        }

        public int indexOf(Camera camera) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get(i).toString().equals(camera.toString())) continue;
                return i;
            }
            return 0;
        }

        public List<Camera> getList() {
            return this.list;
        }
    }

    public static class SampleMoverList
    implements Iterable<SampleMover> {
        private List<SampleMover> list;

        public SampleMoverList(SampleMover ... sampleMoverArray) {
            this.list = Arrays.asList(sampleMoverArray);
        }

        public SampleMover getByXmlNodeName(String string) {
            return this.list.stream().filter(sampleMover -> sampleMover.getXmlNodeName().equals(string)).findAny().orElse(null);
        }

        @Override
        @NonNull
        public Iterator<SampleMover> iterator() {
            return this.list.iterator();
        }

        public void add(SampleMover sampleMover) {
            this.list = new ArrayList<SampleMover>(this.list);
            this.list.add(sampleMover);
        }
    }
}

