/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.map.common.NiceDataFormat;

public interface SampleMover
extends Hardware {
    public static final BoolHolder maxSpeedWarningdialogOpen = new BoolHolder(false);

    public String getXmlNodeName();

    public void moveToReturnPosition(Camera var1);

    public void moveToScanStartPosition(Camera var1);

    public void runScan(LengthValue var1, ScanMode var2, ScanEventListener var3, Camera var4);

    public void moveToEndScanPosition();

    public void stop();

    public boolean isBusy();

    public boolean inFocusState(Camera var1);

    public boolean isRunning();

    default public boolean isConveyor() {
        return false;
    }

    default public boolean isTray() {
        return !this.isConveyor();
    }

    default public void addAddtionalInformation(InformationPanel.InformationList informationList) {
    }

    default public void runContinuously(Speed speed) {
    }

    public void exitFocusState();

    public void enterFocusState(Camera var1);

    public boolean hasWhiteRefState();

    public boolean inWhiteRefState(Camera var1);

    public void exitWhiteRefState();

    public LengthValue whiteRefScanLength();

    public void enterWhiteRefState(Camera var1);

    public Speed movementSpeed();

    public Speed maxSpeed();

    public ComPort getComPort();

    public LengthValue minLength();

    public LengthValue maxLength();

    public float getPosition();

    public RemoteSampleMoverSettings.MoverType getType();

    default public String getUnit() {
        return this.getType().getUnit();
    }

    public static Speed getSpeed(SampleMover sampleMover, Camera camera, FrameCount frameCount, int n) {
        return new Speed(Math.min(new Speed((Camera)camera, (FrameCount)frameCount, (float)((float)n)).value, sampleMover.movementSpeed().value));
    }

    public static LengthValue getValidatorMaxLength(SampleMover sampleMover, int n) {
        return new LengthValue(n);
    }

    public static Speed getMaxSpeed(SampleMover sampleMover) {
        if (sampleMover != null) {
            return sampleMover.maxSpeed();
        }
        return null;
    }

    public static boolean isTray(SampleMover sampleMover) {
        return sampleMover != null && !sampleMover.isConveyor();
    }

    public static boolean isConveyor(SampleMover sampleMover) {
        return sampleMover != null && sampleMover.isConveyor();
    }

    public static void checkForMaxSpeedWarning(BreezeFrame breezeFrame, JTextField jTextField, Camera camera) {
        if (maxSpeedWarningdialogOpen.getValue()) {
            return;
        }
        Speed speed = SampleMover.getMaxSpeed(HardwareRegistry.getInstance().getSampleMover());
        if (speed != null && camera.isConnected()) {
            Speed speed2 = new Speed(camera);
            if (speed2.value > speed.value) {
                maxSpeedWarningdialogOpen.setTrue();
                BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Exceeds max speed", "Sample mover speed is calculated to " + String.valueOf(speed2) + " which exceed max speed of " + String.valueOf(speed) + ".\n\nSample mover speed is calculated from Field of view and Frame rate.", null, breezeActionEvent -> {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    maxSpeedWarningdialogOpen.setFalse();
                });
            }
        }
    }

    public static class MovementInputField
    extends BreezeInputField.Number {
        public MovementInputField(Speed speed, SampleMover sampleMover) {
            super("Travel speed", NiceDataFormat.toString((double)speed.value), sampleMover.getUnit() + "/s");
            this.addValidator(new NumericMinMaxValidator(0.0, this.getMaxSpeed(sampleMover), "max speed"));
        }

        private float getMaxSpeed(SampleMover sampleMover) {
            Speed speed = sampleMover.maxSpeed();
            if (speed != null) {
                return speed.value;
            }
            return 2.1474836E9f;
        }
    }

    public static class MaxLengthInputField
    extends BreezeInputField.Number {
        public MaxLengthInputField(LengthValue lengthValue, SampleMover sampleMover) {
            super("Max length (Optional)", lengthValue.value > 0.0f ? NiceDataFormat.toString((double)lengthValue.value) : "", sampleMover.getUnit());
        }
    }

    public static class ScanEventAdapter
    implements ScanEventListener {
        private boolean scanStarted;
        private boolean scanFinished;

        public ScanEventAdapter() {
            this(false, false);
        }

        public ScanEventAdapter(boolean bl, boolean bl2) {
            this.scanStarted = bl;
            this.scanFinished = bl2;
        }

        public void clear() {
            this.scanStarted = false;
            this.scanFinished = false;
        }

        @Override
        public void onScanStarted() {
            this.scanStarted = true;
        }

        @Override
        public void onScanFinished() {
            this.scanFinished = true;
        }

        public boolean isScanStarted() {
            return this.scanStarted;
        }

        @Override
        public void onScanDemo() {
        }

        public boolean isScanFinished() {
            return this.scanFinished;
        }
    }

    public static interface SettingsPanelSampleMover {
        public JPanel getSettingsPanel(BreezeFrame var1, Hardware.SettingsPanelCallback var2);
    }

    public static enum ScanMode {
        Measurement,
        Continous,
        DemoByLength,
        WhiteReference,
        WhiteReferenceOnly,
        Event,
        Reflectivity1,
        Reflectivity2,
        Reflectivity3,
        Reflectivity4;


        public static ScanMode fromDemo(boolean bl) {
            return bl ? DemoByLength : Measurement;
        }

        public boolean whiteReference() {
            return this.equals((Object)WhiteReference) || this.equals((Object)WhiteReferenceOnly);
        }

        public ScanMode actual() {
            if (this.equals((Object)WhiteReferenceOnly)) {
                return Measurement;
            }
            return this;
        }
    }

    public static enum Property {
        movementSpeed,
        maximumSpeed;

    }

    public static interface ScanEventListener {
        public void onScanStarted();

        public void onScanDemo();

        public void onScanFinished();
    }
}

