/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jpos.JposException;
import jpos.Scanner;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;

public class ZebraBarcodeScanner
implements DataListener,
ErrorListener,
AutoCloseable {
    private boolean isClosed = false;
    private final BarcodeListener barcodeListener;
    private final Scanner scanner;
    private SwingWorker worker;

    @Override
    public void close() throws Exception {
        if (this.isClosed) {
            return;
        }
        this.worker.cancel(true);
        try {
            if (this.scanner.getClaimed()) {
                this.scanner.release();
            }
            this.scanner.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    public ZebraBarcodeScanner(BarcodeListener barcodeListener) {
        this.barcodeListener = barcodeListener;
        this.scanner = new Scanner();
        this.scanner.addErrorListener((ErrorListener)this);
        this.scanner.addDataListener((DataListener)this);
        this.worker = new SwingWorker<JposException, Void>(){
            private final BarcodeListener _barcodeListener;
            {
                this._barcodeListener = ZebraBarcodeScanner.this.barcodeListener;
            }

            @Override
            protected JposException doInBackground() throws Exception {
                int n = 3;
                JposException jposException = null;
                for (int i = 0; i < n; ++i) {
                    try {
                        Thread.sleep(i * i * 1000);
                        ZebraBarcodeScanner.this.scanner.open("ZebraScannerSNAPI");
                        ZebraBarcodeScanner.this.scanner.claim(10000);
                        ZebraBarcodeScanner.this.scanner.setDeviceEnabled(true);
                        ZebraBarcodeScanner.this.scanner.setDataEventEnabled(true);
                        return null;
                    }
                    catch (JposException jposException2) {
                        jposException = jposException2;
                        continue;
                    }
                }
                return jposException;
            }

            @Override
            public void done() {
                JposException jposException = null;
                try {
                    jposException = (JposException)((Object)this.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
                catch (CancellationException cancellationException) {
                    return;
                }
                if (jposException == null) {
                    this._barcodeListener.onScannerConnected();
                } else {
                    this._barcodeListener.onError(jposException.getMessage());
                }
            }
        };
        this.worker.execute();
    }

    public void dataOccurred(DataEvent dataEvent) {
        try {
            byte[] byArray = this.scanner.getScanData();
            String string = new String(byArray, StandardCharsets.UTF_8);
            SwingUtilities.invokeLater(() -> this.barcodeListener.onBarcodeScanned(string));
        }
        catch (JposException jposException) {
            SwingUtilities.invokeLater(() -> this.barcodeListener.onError(jposException.getMessage()));
        }
        try {
            this.scanner.setDataEventEnabled(true);
        }
        catch (JposException jposException) {
            SwingUtilities.invokeLater(() -> this.barcodeListener.onError(jposException.getMessage()));
        }
    }

    public void errorOccurred(ErrorEvent errorEvent) {
        this.barcodeListener.onError("Barcode Error: " + errorEvent.getErrorCode());
    }

    public static interface BarcodeListener {
        public void onScannerConnected();

        public void onBarcodeScanned(String var1);

        public void onError(String var1);
    }
}

