/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.AlliedVisionCameraSettings;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.component.BinningInputField;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class AlliedVisionCamera
extends RemoteCamera<AlliedVisionCameraSettings> {
    private final String cameraName;
    private final String displayName;

    public AlliedVisionCamera(String string, String string2) {
        this.cameraName = string;
        this.displayName = string2;
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return this.cameraName;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    protected AlliedVisionCameraSettings createSettings() {
        return new AlliedVisionCameraSettings(this);
    }

    public String toString() {
        return this.displayName;
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!AlliedVisionCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, AlliedVisionCamera.this.settings));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            if (AlliedVisionCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, AlliedVisionCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private final Hardware.SettingsPanelCallback callback;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced", true, true);
                this.callback = settingsPanelCallback;
                this.fillPanel(breezeFrame);
            }

            private void fillPanel(BreezeFrame breezeFrame) {
                this.addPanel(new TriggerSourceInputField(((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerSource(), this::setTriggerSource));
                this.addPanel(new TriggerSelectorInputField(((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerSelector(), this::setTriggerSelector));
                this.addPanel(new TriggerActivationInputField(((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerActivation(), this::setTriggerActivation));
                this.addPanel(new BreezeInputField.Number("Trigger delay", ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerDelay(), "\u00b5s", this::setTriggerDelay));
                this.addPanel(new BreezeCheckBoxInputField("Trigger mode", ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerMode(), this::setTriggerMode));
                if (!AlliedVisionCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(AlliedVisionCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, AlliedVisionCamera.this, this.callback));
                }
                this.addPanel(new BinningInputField.BinningSpatialInputField(AlliedVisionCamera.this, this.callback));
                this.addPanel(new BinningInputField.BinningSpectralInputField(AlliedVisionCamera.this, this.callback));
            }

            private void setTriggerSelector(String string) {
                ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).setTriggerSelector(string);
                if (AlliedVisionCamera.this.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)AlliedVisionCamera.this, "TriggerSelector", string);
                    this.callback.reloadInformation();
                }
            }

            private void setTriggerActivation(String string) {
                ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).setTriggerActivation(string);
                if (AlliedVisionCamera.this.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)AlliedVisionCamera.this, "TriggerActivation", string);
                    this.callback.reloadInformation();
                }
            }

            private void setTriggerSource(String string) {
                ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).setTriggerSource(string);
                if (AlliedVisionCamera.this.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)AlliedVisionCamera.this, "TriggerSource", string);
                    this.callback.reloadInformation();
                }
            }

            private void setTriggerDelay(TextActionEvent textActionEvent) {
                float f = textActionEvent.getValueFloat();
                ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).setTriggerDelay(f);
                if (AlliedVisionCamera.this.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)AlliedVisionCamera.this, "TriggerDelay", f);
                    this.callback.reloadInformation();
                }
            }

            private void setTriggerMode(boolean bl) {
                ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).setTriggerMode(bl);
                if (AlliedVisionCamera.this.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)AlliedVisionCamera.this, "TriggerMode", Boolean.toString(bl));
                    this.callback.reloadInformation();
                }
            }
        }

        private class TriggerActivationInputField
        extends BreezeComboBoxInputField<String> {
            public TriggerActivationInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
                super("Trigger Activation", Arrays.asList("RisingEdge", "FallingEdge", "AnyEdge"), string, selectionChangedListener);
                this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
                this.setUnit(" ");
                this.setUsage("Type of activation, for hardware triggers. This controls edge/level and polarity sensitivities");
            }
        }

        private class TriggerSourceInputField
        extends BreezeComboBoxInputField<String> {
            public TriggerSourceInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
                super("Trigger Source", ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerSourcesAvailable(), string, selectionChangedListener);
                this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
                this.setUnit(" ");
                this.setUsage("Source of trigger, when TriggerMode is On. This might be an hardware trigger, a fixed rate generator, or software trigger only.");
            }
        }

        private class TriggerSelectorInputField
        extends BreezeComboBoxInputField<String> {
            public TriggerSelectorInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
                super("Trigger Selector", ((AlliedVisionCameraSettings)AlliedVisionCamera.this.settings).getTriggerSelectorsAvailable(), string, selectionChangedListener);
                this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
                this.setUnit(" ");
                this.setUsage("FrameStart is the trigger which starts each image (when acquisition is running). AcquisitionStart is the trigger which starts the acquisition process.");
            }
        }
    }
}

