/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.component.TriggerSettings;
import se.prediktera.breeze.hardware.tcp.Command;

public class AlliedVisionCameraSettings
extends RemoteCameraTypeSettingsWithRoi<AlliedVisionCameraSettings>
implements TriggerSettings {
    public AlliedVisionCameraSettings(RemoteCamera<AlliedVisionCameraSettings> remoteCamera) {
        super(remoteCamera);
    }

    @Override
    public List<Command.Argument> getArguments() {
        List<Command.Argument> list = super.getArguments();
        list.add(new Command.Argument("Type", (Object)this.camera.getDeviceName()));
        this.fillArgumentsWithTrigger(list);
        return list;
    }

    public void setSpectralRoi(String string) {
        this.camera.setSpectralROI(string);
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
    }

    public String getSpectralRoi() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1");
    }

    @Override
    public String getTriggerSelector() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelector", "FrameStart");
    }

    @Override
    public void setTriggerSelector(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelector", String.valueOf(string));
    }

    @Override
    public String getTriggerActivation() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", "RisingEdge");
    }

    @Override
    public void setTriggerActivation(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", String.valueOf(string));
    }

    @Override
    public double getTriggerDelay() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "TriggerDelay", 0.0);
    }

    @Override
    public void setTriggerDelay(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerDelay", RtDataFormat.valueOf(d));
    }

    @Override
    public boolean getTriggerMode() {
        return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "TriggerMode", false);
    }

    @Override
    public void setTriggerMode(boolean bl) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerMode", Boolean.toString(bl));
    }

    @Override
    public String getTriggerSource() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", "Software");
    }

    @Override
    public void setTriggerSource(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", String.valueOf(string));
    }

    @Override
    public List<String> getTriggerSelectorsAvailable() {
        String string = BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelectorsAvailable", "FrameStart;AcquisitionStart");
        return Arrays.asList(string.split(";"));
    }

    @Override
    public List<String> getTriggerSourcesAvailable() {
        String string = BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSourcesAvailable", "Freerun;Line1;Line2");
        return Arrays.asList(string.split(";"));
    }
}

