/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.component.BinningInputField;
import se.prediktera.breeze.hardware.tcp.Command;

public class BaslerCamera
extends RemoteCamera<BaslerCameraSettings> {
    private final String cameraName;
    private final String displayName;

    public BaslerCamera(String string, String string2) {
        this.cameraName = string;
        this.displayName = string2;
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return this.cameraName;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    protected BaslerCameraSettings createSettings() {
        return new BaslerCameraSettings(this, this);
    }

    public String toString() {
        return this.displayName;
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!BaslerCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, BaslerCamera.this.settings));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private final Hardware.SettingsPanelCallback callback;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced", true, true);
                this.callback = settingsPanelCallback;
                this.fillPanel(breezeFrame);
            }

            private void fillPanel(BreezeFrame breezeFrame) {
                if (!BaslerCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(BaslerCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, BaslerCamera.this, this.callback));
                }
                this.addPanel(new BinningInputField.BinningSpatialInputField(BaslerCamera.this, this.callback));
                this.addPanel(new BinningInputField.BinningSpectralInputField(BaslerCamera.this, this.callback));
            }
        }
    }

    public class BaslerCameraSettings
    extends RemoteCameraTypeSettingsWithRoi<BaslerCameraSettings> {
        public BaslerCameraSettings(BaslerCamera baslerCamera, RemoteCamera<BaslerCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Type", (Object)this.camera.getDeviceName()));
            list.add(new Command.Argument("SpectralRoi", (Object)this.getSpectralRoi()));
            return list;
        }

        public void setSpectralRoi(String string) {
            this.camera.setSpectralROI(string);
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
        }

        public String getSpectralRoi() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1");
        }
    }
}

