/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class CameraMode {
    public static CameraMode Empty = new CameraMode("0", "N/A");
    private final String id;
    private String name;
    private boolean def;

    public CameraMode(String string, String string2) {
        this.id = string;
        this.name = string2;
    }

    public CameraMode(String string) {
        String[] stringArray = string.split("#", 3);
        if (stringArray.length > 1) {
            this.id = stringArray[0];
            this.name = stringArray[1];
            if (stringArray.length > 2) {
                this.def = stringArray[2].equals("default");
            }
        } else {
            this.id = this.name = stringArray[0];
        }
    }

    public String getXmlNodeName() {
        return EvinceScriptCommands.removeSpace((String)this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof CameraMode) {
            return ((CameraMode)object).getId().equals(this.getId());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.id.hashCode() + this.name.hashCode();
    }

    public static CameraMode getCameraMode(Camera camera, CameraModeSettings cameraModeSettings) {
        CameraModeList cameraModeList = cameraModeSettings.listCameraModes();
        if (cameraModeList.isEmpty()) {
            return Empty;
        }
        CameraMode cameraMode = CameraMode.getDefaultMode(cameraModeList);
        CameraMode cameraMode3 = BreezeProperties.getInstance().getCameraMode(camera, cameraModeSettings.getCameraType(), cameraMode);
        Optional<CameraMode> optional = cameraModeList.stream().filter(cameraMode2 -> cameraMode2.getId().equals(cameraMode3.getId())).findFirst();
        if (optional.isPresent()) {
            cameraMode3.setName(optional.get().getName());
            return cameraMode3;
        }
        BreezeProperties.getInstance().setCameraMode(camera, cameraModeSettings.getCameraType(), cameraMode);
        return cameraMode;
    }

    private static CameraMode getDefaultMode(CameraModeList cameraModeList) {
        for (CameraMode cameraMode : cameraModeList) {
            if (!cameraMode.isDef()) continue;
            return cameraMode;
        }
        return (CameraMode)cameraModeList.getFirst();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isDef() {
        return this.def;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    public static interface CameraModeSettings
    extends CameraType.CameraTypeSettings {
        public CameraModeList listCameraModes();

        public void clearCameraModeList();

        public void changeCameraMode(CameraMode var1);

        public CameraMode getCameraMode();
    }

    public static class CameraModeList
    extends ArrayList<CameraMode> {
        public CameraModeList(List<String> list) {
            for (String string : list) {
                this.add(new CameraMode(string));
            }
        }
    }

    public static class CameraModeInputFieldReload
    extends CameraModeInputField {
        public CameraModeInputFieldReload(String string, String string2, Hardware.SettingsPanelCallback settingsPanelCallback, CameraModeSettings cameraModeSettings) {
            super(string, string2, settingsPanelCallback, cameraModeSettings);
            this.reload();
        }
    }

    public static class CameraModeInputField
    extends JPanel {
        private final BreezeComboBoxInputField.Loading<CameraMode> modeInputField;
        private JPanel emptyPanel;

        public CameraModeInputField(String string, String string2, final Hardware.SettingsPanelCallback settingsPanelCallback, final CameraModeSettings cameraModeSettings) {
            super(new GridBagLayout());
            this.setOpaque(false);
            settingsPanelCallback.setEnabled(false);
            this.modeInputField = new BreezeComboBoxInputField.Loading<CameraMode>(string, cameraMode -> {
                cameraModeSettings.changeCameraMode((CameraMode)cameraMode);
                settingsPanelCallback.reloadInformation();
            }, string2, new BreezeComboBox.LoadingCallback<CameraMode>(){

                @Override
                public void loadItems(List<CameraMode> list) {
                    if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
                        for (CameraMode cameraMode : cameraModeSettings.listCameraModes()) {
                            if (cameraMode.getName().isEmpty()) continue;
                            list.add(cameraMode);
                        }
                        settingsPanelCallback.setEnabled(true);
                    }
                }

                @Override
                public Object getSelectedItem() {
                    return cameraModeSettings.getCameraMode();
                }
            });
            this.add(this.modeInputField, GridBagHelper.createWithWeigthX1(0, new Insets(0, 0, 0, 0)));
            this.emptyPanel = new JPanel();
            this.emptyPanel.setOpaque(false);
            this.emptyPanel.setPreferredSize(new Dimension(70, 34));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 15;
            this.add((Component)this.emptyPanel, gridBagConstraints);
        }

        public void reload() {
            this.modeInputField.reload();
        }

        public void hideEmptyPanel() {
            this.emptyPanel.setVisible(false);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (this.modeInputField != null) {
                this.modeInputField.setEnabled(bl);
            }
        }
    }
}

