/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public class CameraType {
    private final String name;

    public CameraType(String string) {
        this.name = string;
    }

    public String getXmlNodeName() {
        return StringHelper.removeAllNonXmlTagCharacters(this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof CameraType) {
            return ((CameraType)object).getXmlNodeName().equals(this.getXmlNodeName());
        }
        return super.equals(object);
    }

    public static CameraType fromXml(String string) {
        return new CameraType(string);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    public static class CameraTypeInputField
    extends JPanel {
        private final BreezeComboBoxInputField.Loading typeInputField;

        public CameraTypeInputField(Hardware.SettingsPanelCallback settingsPanelCallback, CameraTypeSettings cameraTypeSettings) {
            this(settingsPanelCallback, cameraTypeSettings, null);
        }

        public CameraTypeInputField(final Hardware.SettingsPanelCallback settingsPanelCallback, final CameraTypeSettings cameraTypeSettings, final CameraTypeCallback cameraTypeCallback) {
            super(new GridBagLayout());
            settingsPanelCallback.setEnabled(false);
            this.typeInputField = new BreezeComboBoxInputField.Loading<CameraType>("Type", cameraType -> {
                cameraTypeSettings.changeCameraType((CameraType)cameraType);
                if (cameraTypeCallback != null) {
                    cameraTypeCallback.OnChange((CameraType)cameraType);
                    settingsPanelCallback.reloadInformation();
                }
            }, "sensors", new BreezeComboBox.LoadingCallback(){

                public void loadItems(List list) {
                    if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
                        for (CameraType cameraType : cameraTypeSettings.listCameraNames()) {
                            if (cameraType.getName().isEmpty()) continue;
                            list.add(cameraType);
                        }
                        settingsPanelCallback.setEnabled(list != null && !list.isEmpty());
                        if (cameraTypeCallback != null) {
                            cameraTypeCallback.OnChange(cameraTypeSettings.getCameraType());
                        }
                    }
                }

                @Override
                public Object getSelectedItem() {
                    return cameraTypeSettings.getCameraType();
                }
            });
            this.typeInputField.reload();
            this.add((Component)this.typeInputField, GridBagHelper.createWithWeigthX1(0, new Insets(0, 0, 0, 0)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.anchor = 15;
            this.add((Component)EntryMainHelper.createSmallTextButton("Update", () -> {
                cameraTypeSettings.clearCameraList();
                this.typeInputField.reload();
            }), gridBagConstraints);
        }

        public void reload(CameraTypeSettings cameraTypeSettings) {
            cameraTypeSettings.clearCameraList();
            this.typeInputField.reload();
        }

        public static interface CameraTypeCallback {
            public void OnChange(CameraType var1);
        }
    }

    public static interface CameraTypeSettings {
        public CameraTypeList listCameraNames();

        public void clearCameraList();

        public void changeCameraType(CameraType var1);

        public CameraType getCameraType();
    }

    public static class CameraTypeList
    extends ArrayList<CameraType> {
        public CameraTypeList(List<String> list) {
            for (String string : list) {
                this.add(new CameraType(string));
            }
        }
    }
}

