/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.tcp.Command;

public class CubertCamera
extends RemoteCamera<CubertCameraSettings> {
    @Override
    protected CubertCameraSettings createSettings() {
        return new CubertCameraSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return true;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    public String toString() {
        return "Cubert";
    }

    @Override
    public String getXmlNodeName() {
        return "Cubert";
    }

    @Override
    public String getDeviceName() {
        return "CubertCamera";
    }

    @Override
    public RgbBands getRgbBands() {
        RgbBands rgbBands = RgbBands.fromCommaSeparatedString(((CubertCameraSettings)this.settings).getRgbBands());
        if (rgbBands.size() > 0) {
            return rgbBands;
        }
        return super.getRgbBands();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
    }

    protected List<Command.Argument> getCameraNamesArguments() {
        return new ArrayList<Command.Argument>();
    }

    public class CubertCameraSettings
    extends RemoteCameraTypeSettings<CubertCameraSettings> {
        public CubertCameraSettings(RemoteCamera<CubertCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return CubertCamera.this.getCameraNamesArguments();
        }

        @Override
        public List<Command.Argument> getArguments() {
            return super.getArguments();
        }
    }

    private class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!CubertCamera.this.isConnected()) {
                // empty if block
            }
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }
    }
}

