/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.NetworkAdapterIPComboBoxInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class DeeTeeCamera
extends RemoteCamera<DeeTeeSettings>
implements StateCamera {
    private final List<String> availableBinningModes = Arrays.asList("No binning", "Averaging every 2 pixels", "Summing every 2 pixels", "Averaging every 4 pixels", "Summing every 4 pixels");

    @Override
    protected DeeTeeSettings createSettings() {
        return new DeeTeeSettings(this);
    }

    public String toString() {
        return "Detection Technology";
    }

    @Override
    public String getXmlNodeName() {
        return "DetectionTechnology";
    }

    @Override
    public String getDeviceName() {
        return "DeeTeeCamera";
    }

    @Override
    public boolean hasShutter() {
        return ((DeeTeeSettings)this.settings).useServerCameraForTest();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Spatial Binning", this.availableBinningModes.get(((DeeTeeSettings)this.settings).getSpatialBinning()));
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(settingsPanelCallback);
    }

    public static void sendCameraPropertyChangedEvent(DeeTeeEnum deeTeeEnum, Object object) {
        TcpManager.getInstance().sendEvent("Event", "CameraPropertyChanged:" + deeTeeEnum.toString() + "=" + DeeTeeCamera.getValueString(object), 0);
    }

    private static String getValueString(Object object) {
        if (object instanceof BreezeInputField.Number) {
            return object.toString().replace(",", ".");
        }
        return object.toString();
    }

    @Override
    public boolean autoChangeState() {
        return ((DeeTeeSettings)this.settings).useServerCameraForTest();
    }

    @Override
    public boolean hasWhiteReference() {
        return true;
    }

    public class DeeTeeSettings
    extends RemoteCameraTypeSettings<DeeTeeSettings>
    implements NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings {
        public DeeTeeSettings(RemoteCamera<DeeTeeSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public String getHostIp() {
            return BreezeProperties.getInstance().getCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "hostIp", "127.0.0.1");
        }

        @Override
        public void setHostIp(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "hostIp", string);
        }

        public int getSpatialBinning() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(DeeTeeCamera.this, this.getCameraType(), "spatialBinning", 0);
        }

        public void setSpatialBinning(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "spatialBinning", "" + n);
        }

        public int getBaseLineOffset() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(DeeTeeCamera.this, this.getCameraType(), "baseLineOffset", 52000);
        }

        public void setBaseLineOffset(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "baseLineOffset", "" + n);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.BaseLineOffset, n);
        }

        public boolean isDynCalibration() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(DeeTeeCamera.this, this.getCameraType(), "dynCalEnable", false);
        }

        public void setDynCalibration(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "dynCalEnable", "" + bl);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DynCalEnable, bl);
        }

        public boolean useServerCameraForTest() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(DeeTeeCamera.this, this.getCameraType(), "useServerCameraForTest", false);
        }

        public int getLines() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(DeeTeeCamera.this, this.getCameraType(), "dynCalLines", 100);
        }

        public void setLines(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "dynCalLines", "" + n);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DynCalLines, n);
        }

        public double getThreshold() {
            return BreezeProperties.getInstance().getCameraTypePropertyDouble(DeeTeeCamera.this, this.getCameraType(), "dynCalThreshold", 0.015);
        }

        public void setThreshold(double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "dynCalThreshold", "" + d);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DynCalThreshold, d);
        }

        public int getNumberOfBlockSaved() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(DeeTeeCamera.this, this.getCameraType(), "dynCalNbBlockSaved", 10);
        }

        public void setNumberOfBlockSaved(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "dynCalNbBlockSaved", "" + n);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DynCalNbBlockSaved, n);
        }

        public boolean isGeoCorrEnable() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(DeeTeeCamera.this, this.getCameraType(), "geoCorrEnable", true);
        }

        public void setGeoCorrEnable(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "geoCorrEnable", "" + bl);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.GeoCorrEnable, bl);
        }

        public double getSD() {
            return BreezeProperties.getInstance().getCameraTypePropertyDouble(DeeTeeCamera.this, this.getCameraType(), "SD", 1160.0);
        }

        public void setSD(double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "SD", "" + d);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.SD, d);
        }

        public double getDLe() {
            return BreezeProperties.getInstance().getCameraTypePropertyDouble(DeeTeeCamera.this, this.getCameraType(), "DLe", 36.411);
        }

        public void setDLe(double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "DLe", "" + d);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DLE, d);
        }

        public double getDHe() {
            return BreezeProperties.getInstance().getCameraTypePropertyDouble(DeeTeeCamera.this, this.getCameraType(), "DHe", 40.6);
        }

        public void setDHe(double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "DHe", "" + d);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.DHE, d);
        }

        public double getCenterPixel() {
            return BreezeProperties.getInstance().getCameraTypePropertyDouble(DeeTeeCamera.this, this.getCameraType(), "CenterPixel", 458.5);
        }

        public void setCenterPixel(double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "CenterPixel", "" + d);
            DeeTeeCamera.sendCameraPropertyChangedEvent(DeeTeeEnum.CenterPixel, d);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("HostIp", (Object)this.getHostIp()));
            list.add(new Command.Argument("SpatialBinning", (Object)this.getSpatialBinning()));
            if (this.useServerCameraForTest()) {
                ToastHandler.getInstance().showToast("USING TEST SERVER", Toast.IconType.Warning);
                list.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
                list.add(new Command.Argument("BroadCastPort", (Object)9999));
                list.add(new Command.Argument("BroadCastSendPort", (Object)8888));
                list.add(new Command.Argument("CommandPort", (Object)7777));
                list.add(new Command.Argument("FrameRate", (Object)1000));
                File file = this.getTestDataFolder();
                if (file.exists()) {
                    list.add(new Command.Argument("RawDataFilePath", new File(file, "measurement.raw")));
                    list.add(new Command.Argument("DarkReferenceFilePath", new File(file, "darkref_measurement.raw")));
                    list.add(new Command.Argument("WhiteReferenceFilePath", new File(file, "whiteref_measurement.raw")));
                }
            }
            list.add(new Command.Argument(DeeTeeEnum.BaseLineOffset, (Object)this.getBaseLineOffset()));
            list.add(new Command.Argument(DeeTeeEnum.DynCalEnable, (Object)this.isDynCalibration()));
            list.add(new Command.Argument(DeeTeeEnum.DynCalLines, (Object)this.getLines()));
            list.add(new Command.Argument(DeeTeeEnum.DynCalThreshold, (Object)this.getThreshold()));
            list.add(new Command.Argument(DeeTeeEnum.DynCalNbBlockSaved, (Object)this.getNumberOfBlockSaved()));
            list.add(new Command.Argument(DeeTeeEnum.GeoCorrEnable, (Object)this.isGeoCorrEnable()));
            list.add(new Command.Argument(DeeTeeEnum.SD, (Object)this.getSD()));
            list.add(new Command.Argument(DeeTeeEnum.DLE, (Object)this.getDLe()));
            list.add(new Command.Argument(DeeTeeEnum.DHE, (Object)this.getDHe()));
            list.add(new Command.Argument(DeeTeeEnum.CenterPixel, (Object)this.getCenterPixel()));
            return list;
        }

        private File getTestDataFolder() {
            return new File(BreezeProperties.getInstance().getCameraTypeProperty(DeeTeeCamera.this, this.getCameraType(), "TestDataFolder", ""));
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return this.getArguments();
        }
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!DeeTeeCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, DeeTeeCamera.this.settings, cameraType -> {}));
                InputFieldHelper.addPanel(this, new NetworkAdapterIPComboBoxInputField((NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings)((Object)DeeTeeCamera.this.settings)));
                BreezeComboBoxInputField<String> breezeComboBoxInputField = new BreezeComboBoxInputField<String>("Spatial Binning", DeeTeeCamera.this.availableBinningModes, DeeTeeCamera.this.availableBinningModes.get(((DeeTeeSettings)DeeTeeCamera.this.settings).getSpatialBinning()), string -> ((DeeTeeSettings)deeTeeCamera.settings).setSpatialBinning(deeTeeCamera.availableBinningModes.indexOf(string)));
                breezeComboBoxInputField.setUnit(" ");
                breezeComboBoxInputField.setUnitLabelWidth(85);
                InputFieldHelper.addPanel(this, breezeComboBoxInputField);
            }
            if (!DeeTeeCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CalibrationAdvancedPanel());
                InputFieldHelper.addPanel(this, new RecalibrationAdvancedPanel());
            }
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private class CalibrationAdvancedPanel
        extends CollapsePanel {
            private final BreezeInputField.Number linesInputField;
            private final BreezeInputField.Number thresholdInputField;
            private final BreezeInputField.Number nbBlockSavedInputField;

            public CalibrationAdvancedPanel() {
                super("Calibration");
                this.addPanel(new BreezeInputField.Number("Ob", "Base line offset", ((DeeTeeSettings)DeeTeeCamera.this.settings).getBaseLineOffset(), ""), (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setBaseLineOffset(textActionEvent.getValueInt()));
                this.addPanel(new BreezeCheckBoxInputField("Dynamic Calibration", ((DeeTeeSettings)DeeTeeCamera.this.settings).isDynCalibration(), bl -> {
                    ((DeeTeeSettings)DeeTeeCamera.this.settings).setDynCalibration(bl);
                    this.updateFieldEnabled(bl);
                }));
                this.linesInputField = new BreezeInputField.Number("Lines", "Number of lines", ((DeeTeeSettings)DeeTeeCamera.this.settings).getLines(), "");
                this.addPanel(this.linesInputField, (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setLines(textActionEvent.getValueInt()));
                this.thresholdInputField = new BreezeInputField.Number("Threshold", "Threshold", ((DeeTeeSettings)DeeTeeCamera.this.settings).getThreshold(), "");
                this.addPanel(this.thresholdInputField, (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setThreshold(textActionEvent.getValue()));
                this.nbBlockSavedInputField = new BreezeInputField.Number("Blocks", "Number of block saved", ((DeeTeeSettings)DeeTeeCamera.this.settings).getNumberOfBlockSaved(), "");
                this.addPanel(this.nbBlockSavedInputField, (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setNumberOfBlockSaved(textActionEvent.getValueInt()));
                this.updateFieldEnabled(((DeeTeeSettings)DeeTeeCamera.this.settings).isDynCalibration());
            }

            private void updateFieldEnabled(boolean bl) {
                this.linesInputField.setEnabled(bl);
                this.thresholdInputField.setEnabled(bl);
                this.nbBlockSavedInputField.setEnabled(bl);
            }
        }

        private class RecalibrationAdvancedPanel
        extends CollapsePanel {
            private final List<BreezeInputField> fields;

            public RecalibrationAdvancedPanel() {
                super("Geometric correction");
                this.fields = new ArrayList<BreezeInputField>();
                this.addPanel(new BreezeCheckBoxInputField("Enable", ((DeeTeeSettings)DeeTeeCamera.this.settings).isGeoCorrEnable(), bl -> {
                    ((DeeTeeSettings)DeeTeeCamera.this.settings).setGeoCorrEnable(bl);
                    this.updateFieldEnabled(bl);
                }));
                this.add(new BreezeInputField.Number("SD", "Source to detector surface distance", ((DeeTeeSettings)DeeTeeCamera.this.settings).getSD(), "mm"), (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setSD(textActionEvent.getValueFloat()));
                this.add(new BreezeInputField.Number("DLe", "Detector surface to diode array LE distance", ((DeeTeeSettings)DeeTeeCamera.this.settings).getDLe(), "mm"), (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setDLe(textActionEvent.getValueFloat()));
                this.add(new BreezeInputField.Number("DHe", "Detector surface to diode array HE distance", ((DeeTeeSettings)DeeTeeCamera.this.settings).getDHe(), "mm"), (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setDHe(textActionEvent.getValueFloat()));
                this.add(new BreezeInputField.Number("Center pixel", "Sensor pixel number corresponding to the center of the beam", ((DeeTeeSettings)DeeTeeCamera.this.settings).getCenterPixel(), "pixel"), (TextActionEvent textActionEvent) -> ((DeeTeeSettings)settingsPanel.DeeTeeCamera.this.settings).setCenterPixel(textActionEvent.getValueFloat()));
                this.updateFieldEnabled(((DeeTeeSettings)DeeTeeCamera.this.settings).isGeoCorrEnable());
            }

            public void add(BreezeInputField breezeInputField, TextActionEvent.TextActionListener textActionListener) {
                super.addPanel(breezeInputField, textActionListener);
                this.fields.add(breezeInputField);
            }

            private void updateFieldEnabled(boolean bl) {
                for (BreezeInputField breezeInputField : this.fields) {
                    breezeInputField.setEnabled(bl);
                }
            }
        }
    }

    public static enum DeeTeeEnum {
        BaseLineOffset,
        DynCalEnable,
        DynCalLines,
        DynCalThreshold,
        DynCalNbBlockSaved,
        GeoCorrEnable,
        SD,
        DLE,
        DHE,
        CenterPixel;

    }
}

