/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import javax.swing.JComponent;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.Temperature;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.capture.TcpStream;
import se.prediktera.breeze.hardware.camera.capture.TcpStreamCaptureSession;

public class FakeCamera
extends RemoteCamera<FakeRemoteCameraTypeSettings>
implements IFramesToAverage {
    private final TcpStream.FakeStream stream;
    private boolean isCapturing = false;
    public boolean preCaptureCalled = false;
    private boolean shutterCalled = false;
    private ThreadUtil.SimpleCallback onStartCallback;
    public PixelWidth width = new PixelWidth(256);
    public MaxSignal maxSignal = new MaxSignal(16384.0f);
    public FieldOfView fieldOfView = new FieldOfView(320.0f);
    public FrameRate frameRate = new FrameRate(100.0f);
    public IntegrationTime integrationTime = new IntegrationTime(1000.0f);
    public Temperature temperature = new Temperature(20.0f);
    public boolean useReferencesWhenRecordingWithThisCamera = true;
    private String deviceName = "FakeCamera";
    private int framesToAverage = 1;
    private FrameRate maxFrameRate = new FrameRate(1000.0f);
    private Integer readoutTime = 0;

    public FakeCamera(TcpStream.FakeStream fakeStream) {
        this.stream = fakeStream;
    }

    public FakeCamera() {
        this(new TcpStream.FakeStream());
    }

    public FakeCamera(String string) {
        this();
        this.deviceName = string;
    }

    @Override
    public void closeShutter() {
        this.shutterCalled = true;
    }

    @Override
    public void openShutter() {
        this.shutterCalled = true;
    }

    @Override
    public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public void setWidth(PixelWidth pixelWidth) {
        this.width = pixelWidth;
    }

    @Override
    public PixelWidth getWidth() {
        return this.width;
    }

    @Override
    public MaxSignal getMaxsignal() {
        return this.maxSignal;
    }

    public boolean isCapturing() {
        return this.isCapturing;
    }

    public void onStart(ThreadUtil.SimpleCallback simpleCallback) {
        this.onStartCallback = simpleCallback;
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return this.useReferencesWhenRecordingWithThisCamera;
    }

    @Override
    public BandCount getBandCount() {
        return new BandCount(1);
    }

    @Override
    public RgbBands getRgbBands() {
        return this.getBandCount().getRgbBands(null);
    }

    @Override
    public DataSize getDataSize() {
        return DataSize.FLOAT_4;
    }

    @Override
    public BandNames getBandNames() {
        return new BandNames(this.getBandCount(), 400.0, 1000.0);
    }

    @Override
    public MeasurementLength getMeasurementLength() {
        return new MeasurementLength(1.0f);
    }

    @Override
    public void setFrameRate(FrameRate frameRate) {
        this.frameRate = new FrameRate(Math.min(this.maxFrameRate.value, frameRate.value));
    }

    @Override
    public void setIntegrationTime(IntegrationTime integrationTime) {
        this.integrationTime = integrationTime;
    }

    @Override
    public FieldOfView getFieldOfView() {
        return this.fieldOfView;
    }

    @Override
    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public IntegrationTime getIntegrationTime() {
        return this.integrationTime;
    }

    @Override
    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setReadoutTime(Integer n) {
        this.readoutTime = n;
    }

    @Override
    public Integer getReadoutTime() {
        return this.readoutTime;
    }

    public void setMaxFrameRate(FrameRate frameRate) {
        this.maxFrameRate = frameRate;
    }

    @Override
    public FrameRate getMaxFrameRate() {
        return this.maxFrameRate;
    }

    @Override
    public void disconnect(BreezeProgressManager breezeProgressManager) {
    }

    @Override
    public void startCapture(FrameCount frameCount, Camera.CaptureCallback captureCallback) {
        new TcpStreamCaptureSession(this.stream, frameCount, new TcpStreamCaptureSession.CameraCallbacks(){

            @Override
            public void startCapture(FrameCount frameCount) {
                FakeCamera.this.isCapturing = true;
                if (FakeCamera.this.onStartCallback != null) {
                    FakeCamera.this.onStartCallback.callback();
                }
            }

            @Override
            public void stopCapture() {
                FakeCamera.this.isCapturing = false;
            }
        }, captureCallback).runBlocking();
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return null;
    }

    @Override
    public boolean canChangeView() {
        return false;
    }

    @Override
    public boolean canChangeLength() {
        return false;
    }

    @Override
    protected FakeRemoteCameraTypeSettings createSettings() {
        return null;
    }

    @Override
    public CameraType getCameraType() {
        return new CameraType("Fake");
    }

    @Override
    public LengthValue getOffset() {
        return new LengthValue(0.0f);
    }

    @Override
    public int getFramesToAverage() {
        return this.framesToAverage;
    }

    @Override
    public void setFramesToAverage(int n) {
        this.framesToAverage = n;
    }

    public static class FakeRemoteCameraTypeSettings
    extends RemoteCameraTypeSettings<FakeRemoteCameraTypeSettings> {
        public FakeRemoteCameraTypeSettings(RemoteCamera<FakeRemoteCameraTypeSettings> remoteCamera) {
            super(remoteCamera);
        }
    }

    public static class FakeCameraFromMeasurement
    extends FakeCamera {
        private SpectralReference.DarkReference darkReference;
        private SpectralReference.WhiteReference whiteReference;
        private final CameraType cameraType;
        private final RawHeader header;

        public FakeCameraFromMeasurement(Measurement measurement) {
            this.maxSignal = measurement.getMaxSignal();
            this.integrationTime = measurement.getIntegrationTime();
            this.darkReference = measurement.darkReference();
            this.whiteReference = measurement.whiteReference();
            this.header = measurement.rawFile().header();
            this.cameraType = new CameraType(measurement.getName());
        }

        @Override
        public SpectralReference.DarkReference getDarkReference() {
            return this.darkReference;
        }

        public void setDarkReference(SpectralReference.DarkReference darkReference) {
            this.darkReference = darkReference;
        }

        @Override
        public SpectralReference.WhiteReference getWhiteReference() {
            return this.whiteReference;
        }

        public void setWhiteReference(SpectralReference.WhiteReference whiteReference) {
            this.whiteReference = whiteReference;
        }

        @Override
        public BandNames getBandNames() {
            return this.header.bandNames();
        }

        @Override
        public BandCount getBandCount() {
            return this.header.bandCount();
        }

        @Override
        public PixelWidth getWidth() {
            return this.header.pixelWidth();
        }

        @Override
        public RgbBands getRgbBands() {
            return this.header.rgbBands();
        }

        @Override
        public CameraType getCameraType() {
            return this.cameraType;
        }
    }

    public static class FakeCameraWithSetFieldOfView
    extends FakeCamera {
        @Override
        public void setFieldOfView(FieldOfView fieldOfView) {
            this.fieldOfView = fieldOfView;
        }

        @Override
        public boolean canChangeView() {
            return true;
        }
    }
}

