/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.component.NetworkAdapterIPComboBoxInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class HaipCamera
extends RemoteCamera<HaipCameraSettings> {
    @Override
    protected HaipCameraSettings createSettings() {
        return new HaipCameraSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(settingsPanelCallback);
    }

    public String toString() {
        return "HAIP Solutions";
    }

    @Override
    public String getXmlNodeName() {
        return "Haip";
    }

    @Override
    public String getDeviceName() {
        return "HaipCamera";
    }

    @Override
    public RgbBands getRgbBands() {
        RgbBands rgbBands = RgbBands.fromCommaSeparatedString(((HaipCameraSettings)this.settings).getRgbBands());
        if (rgbBands.size() > 0) {
            return rgbBands;
        }
        return super.getRgbBands();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Serial no", ((HaipCameraSettings)this.settings).getSerialNo());
        informationList.add("Mode", ((HaipCameraSettings)this.settings).getCameraMode().getName());
        informationList.add("Temperature", this.getTemperature().toString());
    }

    protected List<Command.Argument> getCameraNamesArguments() {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("HostIp", (Object)((HaipCameraSettings)this.settings).getHostIp()));
        if (((HaipCameraSettings)this.settings).useServerCameraForTest()) {
            ToastHandler.getInstance().showToast("USING TEST SERVER", Toast.IconType.Warning);
            arrayList.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
        }
        return arrayList;
    }

    public class HaipCameraSettings
    extends RemoteCameraTypeSettings<HaipCameraSettings>
    implements NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings,
    CameraMode.CameraModeSettings {
        private CameraMode.CameraModeList cameraModeList;

        public HaipCameraSettings(RemoteCamera<HaipCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public String getHostIp() {
            return BreezeProperties.getInstance().getCameraTypeProperty(HaipCamera.this, this.getCameraType(), "hostIp", "127.0.0.1");
        }

        @Override
        public void setHostIp(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(HaipCamera.this, this.getCameraType(), "hostIp", string);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return HaipCamera.this.getCameraNamesArguments();
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            if (this.useServerCameraForTest()) {
                list.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
            }
            list.add(new Command.Argument("HostIp", (Object)this.getHostIp()));
            list.add(new Command.Argument("ModeId", (Object)this.getCameraMode().getId()));
            return list;
        }

        public boolean useServerCameraForTest() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(HaipCamera.this, this.getCameraType(), "useServerCameraForTest", false);
        }

        @Override
        public CameraMode.CameraModeList listCameraModes() {
            if (this.cameraModeList == null) {
                this.cameraModeList = TcpManager.getInstance().getCameraModes(this.camera, this.getCameraType(), this.getListCameraNamesArguments());
            }
            return this.cameraModeList;
        }

        @Override
        public void clearCameraModeList() {
            this.cameraModeList = null;
        }

        @Override
        public void changeCameraMode(CameraMode cameraMode) {
            BreezeProperties.getInstance().setCameraMode(this.camera, this.getCameraType(), cameraMode);
        }

        @Override
        public CameraMode getCameraMode() {
            return CameraMode.getCameraMode(this.camera, this);
        }
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!HaipCamera.this.isConnected()) {
                NetworkAdapterIPComboBoxInputField networkAdapterIPComboBoxInputField = new NetworkAdapterIPComboBoxInputField((NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings)((Object)HaipCamera.this.settings));
                networkAdapterIPComboBoxInputField.setDescription("Camera IP");
                InputFieldHelper.addPanel(this, networkAdapterIPComboBoxInputField);
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, HaipCamera.this.settings));
                InputFieldHelper.addPanel(this, new CameraMode.CameraModeInputFieldReload("Mode", "modes", settingsPanelCallback, (CameraMode.CameraModeSettings)((Object)HaipCamera.this.settings)));
            }
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }
    }
}

