/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTextFieldEmptyText;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.component.RgbBandsInputField;
import se.prediktera.breeze.hardware.camera.component.SpatialRoiInputField;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.breeze.util.FilePathString;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class HySpexCamera
extends RemoteCamera<HySpexSettings>
implements IFramesToAverage,
Camera.WhiteReferenceIntensity,
Camera.ICameraMode {
    public static final String CAMERA_NAME = "HySpex SDK";
    public static final String DEVICE_NAME = "HySpexCamera";
    public static final File DEFAULT_SETTINGS_PATH = new File(System.getenv("PUBLIC"), "HySpex");

    @Override
    protected HySpexSettings createSettings() {
        return new HySpexSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public RtReferenceTarget getReferenceTarget() {
        return ((HySpexSettings)this.settings).getReferenceTarget();
    }

    @Override
    public File getWhiteReferenceTargetFile() {
        return ((HySpexSettings)this.settings).getWhiteReferenceTargetFile();
    }

    @Override
    public void setWhiteReferenceTargetFile(File file) {
        ((HySpexSettings)this.settings).setWhiteReferenceTargetFile(file);
    }

    @Override
    public SettingsPanel getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public int getFramesToAverage() {
        return ((HySpexSettings)this.settings).getFramesToAverage();
    }

    @Override
    public void setFramesToAverage(int n) {
        ((HySpexSettings)this.settings).setFramesToAverage(n);
        this.remoteSettings.setCameraProperty("FramesToAverage", n);
    }

    @Override
    public CameraMode getCameraMode() {
        return ((HySpexSettings)this.settings).getCameraMode();
    }

    public String toString() {
        return CAMERA_NAME;
    }

    @Override
    public String getXmlNodeName() {
        return "HySpex";
    }

    @Override
    public String getDeviceName() {
        return DEVICE_NAME;
    }

    @Override
    public FieldOfView getFieldOfView() {
        FieldOfView fieldOfView;
        if (!this.canChangeView() && (fieldOfView = ((HySpexSettings)this.settings).getFieldOfView()) != null) {
            return fieldOfView;
        }
        return super.getFieldOfView();
    }

    @Override
    public boolean canChangeView() {
        return ((HySpexSettings)this.settings).canChangeView();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        informationList.add("Settings folder", new FilePathString(((HySpexSettings)this.settings).getSettingsFile()).toString());
        super.add(informationList);
        informationList.add("Temperature", this.getTemperature().toString());
        informationList.add("Frames to average", ((HySpexSettings)this.settings).getFramesToAverage());
        informationList.add("Lens", ((HySpexSettings)this.settings).getCameraMode().getName());
        File file = ((HySpexSettings)this.settings).getWhiteReferenceTargetFile();
        if (file != null) {
            informationList.add("Calibrated reflectance target", file.getAbsolutePath());
        }
        if (this.getReadoutTime() != null) {
            informationList.add("Readout time", this.getReadoutTime() + " \u03bcs");
        }
        informationList.add("Buffer size", ((HySpexSettings)this.settings).getBufferSize());
        informationList.add("Trigger", ((HySpexSettings)this.settings).getTriggerMode());
        informationList.add("Control mode", ((HySpexSettings)this.settings).getControlMode());
        informationList.add("Image mode", ((HySpexSettings)this.settings).getImageOption());
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return ((HySpexSettings)this.settings).getImageOption().contains("RAW");
    }

    @Override
    public boolean takeDarkAfterMeasurement() {
        return ((HySpexSettings)this.settings).takeDarkAfterMeasurement();
    }

    @Override
    public CameraMode.CameraModeInputField createCameraModeField(Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new CameraMode.CameraModeInputField("Lens", "lenses", settingsPanelCallback, (CameraMode.CameraModeSettings)((Object)this.settings));
    }

    public static class HySpexSettings
    extends RemoteCameraTypeSettingsWithRoi<HySpexSettings>
    implements CameraMode.CameraModeSettings {
        private CameraMode.CameraModeList cameraModeList = null;
        private FieldOfView fow;

        public HySpexSettings(RemoteCamera<HySpexSettings> remoteCamera) {
            super(remoteCamera);
        }

        public void setSettingsFile(File file) {
            BreezeProperties.getInstance().setCameraFile(this.camera, "setfile", file);
            this.clear();
        }

        public File getSettingsFile() {
            return BreezeProperties.getInstance().getCameraFile(this.camera, "setfile", DEFAULT_SETTINGS_PATH);
        }

        public void setFramesToAverage(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "framesToAverage", String.valueOf(n));
        }

        public int getFramesToAverage() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "framesToAverage", 1);
        }

        public String getImageOption() {
            return BreezeProperties.getInstance().getCameraProperty(this.camera, "imageOption", "RAW_BP");
        }

        public void setImageOption(String string) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "imageOption", string);
        }

        public FieldOfView getFieldOfView() {
            if (this.fow == null && this.camera.isConnected()) {
                String string = TcpManager.getInstance().getCameraProperty(this.camera, "FieldOfView");
                this.fow = new FieldOfView(RtDataFormat.toNumberFloat(string));
            }
            return this.fow;
        }

        @Override
        public void clear() {
            super.clear();
            this.fow = null;
        }

        public void setSpectralRoi(String string) {
            this.camera.setSpectralROI(string);
        }

        public String getSpectralRoi() {
            return this.camera.getSpectralROI();
        }

        public void setSpatialRoi(String string) {
            this.camera.setSpatialRoi(string);
        }

        public String getSpatialRoi() {
            return this.camera.getSpatialRoi();
        }

        @Override
        public CameraMode.CameraModeList listCameraModes() {
            if (this.cameraModeList == null) {
                this.cameraModeList = TcpManager.getInstance().getCameraModes(this.camera, this.getCameraType(), this.getListCameraNamesArguments());
            }
            return this.cameraModeList;
        }

        @Override
        public void clearCameraModeList() {
            this.cameraModeList = null;
        }

        @Override
        public void changeCameraMode(CameraMode cameraMode) {
            if (this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)this.camera, "Mode", cameraMode.getId());
                this.fow = null;
            }
            BreezeProperties.getInstance().setCameraMode(this.camera, this.getCameraType(), cameraMode);
        }

        @Override
        public CameraMode getCameraMode() {
            return CameraMode.getCameraMode(this.camera, this);
        }

        public boolean canChangeView() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "editFow", false);
        }

        public void setChangeView(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "editFow", String.valueOf(bl));
        }

        public boolean takeDarkAfterMeasurement() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "darkAfter", true);
        }

        public void setTakeDarkAfterMeasurement(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "darkAfter", String.valueOf(bl));
        }

        public final void setBufferSize(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "bufferSize", String.valueOf(n));
        }

        public final int getBufferSize() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "bufferSize", 1024);
        }

        public final void setBufferPreProcessingSize(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "bufferPreProSize", String.valueOf(n));
        }

        public final int getBufferPreProcessingSize() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "bufferPreProSize", 128);
        }

        public final String getControlMode() {
            return BreezeProperties.getInstance().getCameraProperty(this.camera, "controlMode", "disabled");
        }

        public final void setControlMode(String string) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "controlMode", string);
        }

        public final String getTriggerMode() {
            return BreezeProperties.getInstance().getCameraProperty(this.camera, "triggerMode", "default");
        }

        public final void setTriggerMode(String string) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "triggerMode", string);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            File file = this.getSettingsFile();
            if (file != null) {
                arrayList.add(new Command.Argument("SetFilePath", (Object)file.getAbsolutePath()));
            }
            return arrayList;
        }

        @Override
        public List<Command.Argument> getArguments() {
            File file;
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("FramesToAverage", (Object)this.getFramesToAverage()));
            list.add(new Command.Argument("LensId", (Object)this.getCameraMode().getId()));
            File file2 = this.getSettingsFile();
            if (file2 != null) {
                list.add(new Command.Argument("SetFilePath", (Object)file2.getAbsolutePath()));
            }
            if ((file = this.getWhiteReferenceTargetFile()) != null) {
                list.add(new Command.Argument("ReferenceTargetFile", file.getAbsoluteFile()));
            }
            list.add(new Command.Argument("BufferSize", (Object)this.getBufferSize()));
            list.add(new Command.Argument("BufferSizePreProcessing", (Object)this.getBufferPreProcessingSize()));
            list.add(new Command.Argument("ImageOption", (Object)this.getImageOption()));
            list.add(new Command.Argument("MotorType", (Object)HardwareRegistry.getInstance().getSampleMoverType().getType()));
            list.add(new Command.Argument("ControlMode", (Object)this.getControlMode()));
            list.add(new Command.Argument("Trigger", (Object)this.getTriggerMode()));
            return list;
        }
    }

    public class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            CameraMode.CameraModeInputField cameraModeInputField = HySpexCamera.this.createCameraModeField(settingsPanelCallback);
            if (!HySpexCamera.this.isConnected()) {
                HySpexCamera hySpexCamera2;
                CameraType.CameraTypeInputField cameraTypeInputField = new CameraType.CameraTypeInputField(settingsPanelCallback, HySpexCamera.this.settings, cameraType -> {
                    ((HySpexSettings)hySpexCamera.settings).clearCameraModeList();
                    cameraModeInputField.reload();
                });
                Camera camera2 = HardwareRegistry.getInstance().getCameras().stream().filter(camera -> camera.getDeviceName().equals(HySpexCamera.DEVICE_NAME)).findFirst().orElse(null);
                if (camera2 instanceof HySpexCamera && (hySpexCamera2 = (HySpexCamera)camera2).getId() != HySpexCamera.this.getId()) {
                    ((HySpexSettings)HySpexCamera.this.settings).setSettingsFile(((HySpexSettings)hySpexCamera2.getSettings()).getSettingsFile());
                    cameraTypeInputField.reload(HySpexCamera.this.settings);
                    FileInputField.FolderInputField folderInputField = new FileInputField.FolderInputField((Component)this, "Settings folder (from " + StringUtils.capitalize((String)StringHelper.numberToOrdinal(hySpexCamera2.getId())) + " camera)", ((HySpexSettings)HySpexCamera.this.settings).getSettingsFile(), null, true, BreezeInputFieldHelper.Format.TwoRows);
                    folderInputField.setEditable(false);
                    InputFieldHelper.addPanel(this, folderInputField);
                } else {
                    InputFieldHelper.addPanel(this, new FileInputField.FolderInputField(this, "Settings folder", ((HySpexSettings)HySpexCamera.this.settings).getSettingsFile(), textActionEvent -> {
                        ((HySpexSettings)hySpexCamera.settings).setSettingsFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull());
                        cameraTypeInputField.reload(hySpexCamera.settings);
                        settingsPanelCallback.reloadSubsequentTabs();
                    }, true, BreezeInputFieldHelper.Format.TwoRows){

                        @Override
                        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                            super.customizeDialog(jopensaveDialog2);
                            jopensaveDialog2.addExtension("set", "Set files");
                            jopensaveDialog2.addAllFiles();
                        }
                    });
                }
                InputFieldHelper.addPanel(this, cameraTypeInputField);
            } else {
                cameraModeInputField.reload();
            }
            InputFieldHelper.addPanel(this, cameraModeInputField);
            InputFieldHelper.addPanel(this, new CalibratedReflectanceTargetInputField((Component)breezeFrame, ((HySpexSettings)HySpexCamera.this.settings).getWhiteReferenceTargetFile(), textActionEvent -> HySpexCamera.this.setWhiteReferenceTargetFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull()), BreezeInputFieldHelper.Format.TwoRows));
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (!HySpexCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(HySpexCamera.this.settings));
                    this.addPanel(new BreezeInputField.Number("Buffer size", (double)((HySpexSettings)HySpexCamera.this.settings).getBufferSize(), "", textActionEvent -> ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).setBufferSize(textActionEvent.getValueInt())));
                    this.addPanel(new BreezeInputField.Number("Buffer size (pre processing)", (double)((HySpexSettings)HySpexCamera.this.settings).getBufferPreProcessingSize(), "", textActionEvent -> ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).setBufferPreProcessingSize(textActionEvent.getValueInt())));
                    this.addPanel(new ImageOptionComboBox(((HySpexSettings)HySpexCamera.this.settings).getImageOption(), ((HySpexSettings)HySpexCamera.this.settings)::setImageOption));
                    this.addPanel(new ControlModeComboBox(((HySpexSettings)HySpexCamera.this.settings).getControlMode(), ((HySpexSettings)HySpexCamera.this.settings)::setControlMode));
                    this.addPanel(new TriggerComboBox(((HySpexSettings)HySpexCamera.this.settings).getTriggerMode(), ((HySpexSettings)HySpexCamera.this.settings)::setTriggerMode));
                }
                this.addPanel(new Camera.OffsetInputField(breezeFrame, HySpexCamera.this, settingsPanelCallback));
                this.addPanel(new RgbBandsInputField(breezeFrame, ((HySpexSettings)HySpexCamera.this.settings).getRgbBands(), textActionEvent -> ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).setRgbBands(textActionEvent.getText())));
                if (HySpexCamera.this.isConnected()) {
                    String string2 = ((HySpexSettings)HySpexCamera.this.settings).getSpectralRoi();
                    SpectralRoiInputField spectralRoiInputField = new SpectralRoiInputField(breezeFrame, HySpexCamera.this, string -> {
                        String string2 = string;
                        if (string2.isEmpty()) {
                            string2 = ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).getSpectralRoi();
                        }
                        ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).setSpectralRoi(string2);
                        settingsPanelCallback.reloadInformation();
                    });
                    spectralRoiInputField.setEnabled(!string2.equals("SPECTRAL_NOT_SUPPORTED"));
                    this.addPanel(spectralRoiInputField);
                    String string3 = ((HySpexSettings)HySpexCamera.this.settings).getSpatialRoi();
                    SpatialRoiInputField spatialRoiInputField = new SpatialRoiInputField(string3, textActionEvent -> {
                        ((HySpexSettings)settingsPanel.HySpexCamera.this.settings).setSpatialRoi(textActionEvent.getText());
                        settingsPanelCallback.reloadInformation();
                    }, "Spatial region of interest with start value and size (example: 100;10)");
                    spatialRoiInputField.setEnabled(Pattern.matches("^[0-9]+", string3));
                    this.addPanel(spatialRoiInputField, null, 250);
                }
                this.addPanel(new BreezeCheckBoxInputField("Allow editing Field of view of connected camera", ((HySpexSettings)HySpexCamera.this.settings).canChangeView(), ((HySpexSettings)HySpexCamera.this.settings)::setChangeView));
                this.addPanel(new BreezeCheckBoxInputField("Dark after record", ((HySpexSettings)HySpexCamera.this.settings).takeDarkAfterMeasurement(), "Take dark reference after recorded measurement", BreezeInputFieldHelper.Format.OneRow, ((HySpexSettings)HySpexCamera.this.settings)::setTakeDarkAfterMeasurement));
            }
        }
    }

    public static class TriggerComboBox
    extends BreezeComboBoxInputField<String> {
        public TriggerComboBox(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger mode", " ", BreezeInputFieldHelper.Format.OneRow);
            for (String string2 : new String[]{"default", "internal", "external"}) {
                this.addItem(string2);
            }
            this.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
            this.setSelectedItem(string);
            this.setChangedListener(selectionChangedListener);
        }
    }

    public static class ControlModeComboBox
    extends BreezeComboBoxInputField<String> {
        public ControlModeComboBox(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Control mode", " ", BreezeInputFieldHelper.Format.OneRow);
            for (String string2 : new String[]{"disabled", "master", "slave"}) {
                this.addItem(string2);
            }
            this.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
            this.setSelectedItem(string);
            this.setChangedListener(selectionChangedListener);
        }
    }

    public static class ImageOptionComboBox
    extends BreezeComboBoxInputField<String> {
        public ImageOptionComboBox(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Image option", " ", BreezeInputFieldHelper.Format.OneRow);
            for (String string2 : new String[]{"RAW", "BGSUB", "RE", "RAW_BP", "HSNR_RAW", "HSNR_RE", "HSNR_RAW_BP"}) {
                this.addItem(string2);
            }
            this.setSelectedItem(string);
            this.setChangedListener(selectionChangedListener);
        }
    }

    public static class CalibratedReflectanceTargetInputField
    extends FileInputField {
        public CalibratedReflectanceTargetInputField(Component component, File file, TextActionEvent.TextActionListener textActionListener, BreezeInputFieldHelper.Format format) {
            super(component, "Calibrated reflectance target", new FilePathString(file).toString(), textActionListener, true, format);
        }

        public CalibratedReflectanceTargetInputField(Component component) {
            this(component, "Calibrated reflectance target (optional)");
        }

        public CalibratedReflectanceTargetInputField(Component component, String string) {
            super(component, string, (File)null, null);
        }

        public CalibratedReflectanceTargetInputField(Component component, String string, BreezeInputFieldHelper.Format format) {
            super(component, string, "", null, true, format);
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.addExtension("txt", "Text format");
            jopensaveDialog2.addExtension("csv", "CSV format");
            jopensaveDialog2.addAllSupported();
            jopensaveDialog2.addAllFiles();
        }

        public static class CalibratedReflectanceTargetWithFocusInputField
        extends CalibratedReflectanceTargetInputField {
            private final BreezeTextFieldEmptyText textField;
            private File file;

            public CalibratedReflectanceTargetWithFocusInputField(Component component, File file, TextActionEvent.TextActionListener textActionListener, BreezeInputFieldHelper.Format format) {
                super(component, file, textActionListener, format);
                this.getBrowseButton().setToolTipText("Select calibrated reflectance target file");
                this.getInputField().setDescription("Cal. reflectance target");
                this.textField = this.getTextField().getTextField();
                this.textField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        this.setFullpath();
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        this.setFileName();
                    }
                });
                this.setFileName();
            }

            @Override
            protected boolean useIcon() {
                return true;
            }

            @Override
            protected void onBrowse() {
                this.setFullpath();
            }

            @Override
            protected void onFileSelected() {
                this.setFileName();
            }

            private void setFullpath() {
                if (this.file != null) {
                    this.textField.setText(this.file.getAbsolutePath());
                    this.textField.selectAll();
                }
            }

            private void setFileName() {
                this.file = this.getFile();
                this.getInputField().setToolTipText(FileHelper.getAbsolutePathOrEmpty(this.file));
                this.textField.setText(FileHelper.getFileName(this.file));
            }
        }
    }
}

