/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class HySpexLineProfiler
extends RemoteCamera<HySpexLineProfilerSettings> {
    @Override
    protected HySpexLineProfilerSettings createSettings() {
        return new HySpexLineProfilerSettings(this);
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new HySpexLineProfilerSettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public String getDeviceName() {
        return "HySpexLineProfiler";
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Settings file", ((HySpexLineProfilerSettings)this.settings).getSettingsFile());
    }

    public String toString() {
        return "HySpex Line Profiler";
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return false;
    }

    public static class HySpexLineProfilerSettings
    extends RemoteCameraTypeSettings<HySpexLineProfilerSettings> {
        public HySpexLineProfilerSettings(RemoteCamera<HySpexLineProfilerSettings> remoteCamera) {
            super(remoteCamera);
        }

        public String toString() {
            return "HySpexLineProfilerSettings";
        }

        public File getSettingsFile() {
            return BreezeProperties.getInstance().getCameraFile(this.camera, "settingsFile", new File(HySpexCamera.DEFAULT_SETTINGS_PATH, "hyspex_lineprofiler.json"));
        }

        public void setSettingsFile(File file) {
            BreezeProperties.getInstance().setCameraFile(this.camera, "settingsFile", file);
        }

        public boolean isExternalTrigger() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "externalTrigger", true);
        }

        public void setExternalTrigger(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "externalTrigger", Boolean.toString(bl));
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("SettingsFile", this.getSettingsFile()));
            list.add(new Command.Argument("ExternalTrigger", (Object)this.isExternalTrigger()));
            return list;
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            arrayList.add(new Command.Argument("SettingsFile", this.getSettingsFile()));
            return arrayList;
        }
    }

    public class HySpexLineProfilerSettingsPanel
    extends JPanel {
        public HySpexLineProfilerSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!HySpexLineProfiler.this.isConnected()) {
                CameraType.CameraTypeInputField cameraTypeInputField = new CameraType.CameraTypeInputField(settingsPanelCallback, HySpexLineProfiler.this.settings);
                InputFieldHelper.addPanel(this, cameraTypeInputField);
                FileInputField fileInputField = new FileInputField(breezeFrame, "HySpex Telops settings file *.json", ((HySpexLineProfilerSettings)HySpexLineProfiler.this.settings).getSettingsFile(), textActionEvent -> {
                    ((HySpexLineProfilerSettings)hySpexLineProfiler.settings).setSettingsFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull());
                    cameraTypeInputField.reload(hySpexLineProfiler.settings);
                }, true, BreezeInputFieldHelper.Format.TwoRows){

                    @Override
                    protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                        jopensaveDialog2.addExtension(new String[]{"json"}, "HySpex Line Profiler *.json", (byte)0, null);
                    }
                };
                InputFieldHelper.addPanel(this, fileInputField);
                InputFieldHelper.addPanel(this, new BreezeCheckBoxInputField("Use external trigger", ((HySpexLineProfilerSettings)HySpexLineProfiler.this.settings).isExternalTrigger(), ((HySpexLineProfilerSettings)HySpexLineProfiler.this.settings)::setExternalTrigger));
            }
            if (HySpexLineProfiler.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, HySpexLineProfiler.this.remoteSettings);
            }
            this.setOpaque(false);
        }
    }
}

