/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.wizard.telops.HySpexTelopReferenceWizard;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class HySpexTelopCamera
extends RemoteCamera<HySpexTelopCameraSettings>
implements StateCamera,
Camera.SnapshotCamera {
    @Override
    public FrameCount getHeight() {
        return new FrameCount(256);
    }

    @Override
    protected HySpexTelopCameraSettings createSettings() {
        return new HySpexTelopCameraSettings(this);
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public boolean hasWhiteReference() {
        return true;
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return false;
    }

    @Override
    public boolean isFrameRateFixed() {
        return true;
    }

    @Override
    public String getDeviceName() {
        return "HySpexTelopsCamera";
    }

    public String toString() {
        return "HySpex Telops";
    }

    @Override
    public String getXmlNodeName() {
        return "HySpexTelops";
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Settings file", ((HySpexTelopCameraSettings)this.getSettings()).getSettingsFilePath());
        informationList.add("Distance set point", RtDataFormat.toString(((HySpexTelopCameraSettings)this.getSettings()).getDistanceSetPoint()));
    }

    public static class HySpexTelopCameraSettings
    extends RemoteCameraTypeSettings<HySpexTelopCameraSettings> {
        public HySpexTelopCameraSettings(RemoteCamera<HySpexTelopCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            String string = this.getSettingsFilePath();
            if (string != null) {
                arrayList.add(new Command.Argument("settingsFile", (Object)string));
            }
            return arrayList;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("settingsFile", (Object)this.getSettingsFilePath()));
            list.add(new Command.Argument("distanceSetPoint", (Object)this.getDistanceSetPoint()));
            list.add(new Command.Argument(SampleMover.ScanMode.Reflectivity1.toString(), (Object)this.getReflectivityFilePath(SampleMover.ScanMode.Reflectivity1)));
            list.add(new Command.Argument(SampleMover.ScanMode.Reflectivity2.toString(), (Object)this.getReflectivityFilePath(SampleMover.ScanMode.Reflectivity2)));
            list.add(new Command.Argument(SampleMover.ScanMode.Reflectivity3.toString(), (Object)this.getReflectivityFilePath(SampleMover.ScanMode.Reflectivity3)));
            list.add(new Command.Argument(SampleMover.ScanMode.Reflectivity4.toString(), (Object)this.getReflectivityFilePath(SampleMover.ScanMode.Reflectivity4)));
            return list;
        }

        public final String getSettingsFilePath() {
            return BreezeProperties.getInstance().getCameraProperty(this.camera, "settingsFilePath", "C:\\Users\\public\\HySpex\\hyspex_ftir.json");
        }

        public String getReflectivityFilePath(SampleMover.ScanMode scanMode) {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.camera.getCameraType(), scanMode.name().toLowerCase(), "");
        }

        public final void setSettingsFilePath(File file) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "settingsFilePath", file.getAbsolutePath());
        }

        public final int getDistanceSetPoint() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "distanceSetPoint", 190);
        }

        public final void setDistanceSetPoint(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "distanceSetPoint", RtDataFormat.toString(n));
        }
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(final BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            JPanel jPanel;
            JPanel jPanel2;
            this.setLayout(new GridBagLayout());
            if (!HySpexTelopCamera.this.isConnected()) {
                jPanel2 = new CameraType.CameraTypeInputField(settingsPanelCallback, HySpexTelopCamera.this.settings);
                InputFieldHelper.addPanel(this, jPanel2);
                jPanel = new FileInputField(breezeFrame, "HySpex Telops settings file *.json", ((HySpexTelopCameraSettings)HySpexTelopCamera.this.settings).getSettingsFilePath(), arg_0 -> SettingsPanel.lambda$new$0(HySpexTelopCamera.this, (CameraType.CameraTypeInputField)jPanel2, arg_0), true, BreezeInputFieldHelper.Format.TwoRows){

                    @Override
                    protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                        jopensaveDialog2.addExtension(new String[]{"json"}, "HySpex Telops *.json", (byte)0, null);
                    }
                };
                InputFieldHelper.addPanel(this, jPanel);
                InputFieldHelper.addPanel(this, new BreezeSpinnerInputPanel("Distance set point", "", 0.0f, 9999.0f, 1.0f, ((HySpexTelopCameraSettings)HySpexTelopCamera.this.getSettings()).getDistanceSetPoint(), "cm", d -> ((HySpexTelopCameraSettings)HySpexTelopCamera.this.getSettings()).setDistanceSetPoint(d.intValue())));
            }
            if (HySpexTelopCamera.this.isConnected()) {
                jPanel2 = new BreezeButton("Start Reference Wizard", () -> BreezeProgressDialog.startProgress(breezeFrame, new OpenEntryProgressAction(this, breezeFrame, 0.7){

                    @Override
                    protected BreezeMainPanel createOpenPanel() {
                        return new HySpexTelopReferenceWizard(breezeFrame, () -> Logg.info((String)"DONE", (Object[])new Object[0]));
                    }
                }, "Opening...", 0));
                jPanel2.setPreferredSize(new Dimension(250, 30));
                ((BreezeButton)jPanel2).setTextFont(new Font("Tahoma", 0, 16));
                jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(jPanel2);
                InputFieldHelper.addPanel(this, jPanel);
                InputFieldHelper.addWarningsPanel(this, HySpexTelopCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }

        private static /* synthetic */ void lambda$new$0(HySpexTelopCamera hySpexTelopCamera, CameraType.CameraTypeInputField cameraTypeInputField, TextActionEvent textActionEvent) {
            ((HySpexTelopCameraSettings)hySpexTelopCamera.settings).setSettingsFilePath(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull());
            cameraTypeInputField.reload(hySpexTelopCamera.settings);
        }
    }
}

