/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.IDSCameraSettings;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.IScanMode;
import se.prediktera.breeze.hardware.camera.component.SpatialRoiInputField;
import se.prediktera.breeze.hardware.camera.component.TriggerCollapsePanel;
import se.prediktera.breeze.hardware.camera.component.TriggerSettings;
import se.prediktera.breeze.hardware.camera.rgb.RgbUsbCamera;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class IDSCamera
extends RemoteCamera<IDSCameraSettings>
implements StateCamera,
Camera.SnapshotCamera {
    private final String cameraName;
    private final String displayName;

    public IDSCamera(String string, String string2) {
        this.cameraName = string;
        this.displayName = string2;
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public boolean hasWhiteReference() {
        return true;
    }

    @Override
    public boolean canChangeLength() {
        return !((IDSCameraSettings)this.settings).fixedLength();
    }

    @Override
    public String getDeviceName() {
        return this.cameraName;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    protected IDSCameraSettings createSettings() {
        return new IDSCameraSettings(this);
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public FrameCount getHeight() {
        return ((IDSCameraSettings)this.settings).getHeight();
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return false;
    }

    @Override
    public String getFormattedCameraType() {
        return ((IDSCameraSettings)this.settings).getFormattedCameraType("IDS");
    }

    @Override
    public MeasurementLength getMeasurementLength() {
        if (((IDSCameraSettings)this.settings).fixedLength()) {
            if (this.isConnected()) {
                return new MeasurementLength(this.getHeight().value, MeasurementLength.LengthUnit.frames);
            }
            return new MeasurementLength(0.0f);
        }
        return BreezeProperties.getInstance().getMeasurementLength();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        String string;
        String string2;
        super.add(informationList);
        informationList.add("Mode", this.getType().toString());
        informationList.add("Trigger mode", ((IDSCameraSettings)this.settings).getTriggerMode() ? "On" : "Off");
        if (((IDSCameraSettings)this.settings).getTriggerMode()) {
            informationList.add("Trigger source", ((IDSCameraSettings)this.settings).getTriggerSource());
            informationList.add("Trigger activation", ((IDSCameraSettings)this.settings).getTriggerActivation());
        }
        if (this.getType() == Camera.CameraCaptureType.Snapshot) {
            informationList.add("CameraHeight", this.getHeight().value);
        }
        if (StringUtils.isNotEmpty((CharSequence)(string2 = this.getSpatialRoi()))) {
            informationList.add("Spatial ROI X", string2);
        }
        if (StringUtils.isNotEmpty((CharSequence)(string = TcpManager.getInstance().getCameraProperty(this, "SpatialROIY")))) {
            informationList.add("Spatial ROI Y", string);
        }
        informationList.add("Packet size", this.remoteSettings.getPacketSize() + " bytes");
        informationList.add("Analog gain", ((IDSCameraSettings)this.settings).getAnalogGain());
        informationList.add("Digital all gain", ((IDSCameraSettings)this.settings).getDigitalAllGain());
        informationList.add("Digital red gain", ((IDSCameraSettings)this.settings).getDigitalRedGain());
        informationList.add("Digital green gain", ((IDSCameraSettings)this.settings).getDigitalGreenGain());
        informationList.add("Digital blue gain", ((IDSCameraSettings)this.settings).getDigitalBlueGain());
        informationList.add("Binning horizontal", (String)(((IDSCameraSettings)this.settings).getBinningSpatial() == 1 ? "None" : ((IDSCameraSettings)this.settings).getBinningSpatial() + "X"));
        informationList.add("Binning vertical", (String)(((IDSCameraSettings)this.settings).getBinningSpectral() == 1 ? "None" : ((IDSCameraSettings)this.settings).getBinningSpectral() + "X"));
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return ((IDSCameraSettings)this.settings).getType();
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!IDSCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, IDSCamera.this.settings));
                InputFieldHelper.addPanel(this, new RgbUsbCamera.ScanModeInputField(IDSCamera.this, (IScanMode)((Object)IDSCamera.this.settings), settingsPanelCallback));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            if (IDSCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, IDSCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private final Hardware.SettingsPanelCallback callback;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced", true, true);
                this.callback = settingsPanelCallback;
                this.fillPanel(breezeFrame);
            }

            private void fillPanel(BreezeFrame breezeFrame) {
                this.addPanel(new TriggerCollapsePanel(IDSCamera.this, this.callback, (TriggerSettings)((Object)IDSCamera.this.settings)));
                if (!IDSCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(IDSCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, IDSCamera.this, this.callback));
                } else {
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "AnalogAll", "Analog gain", this::setAnalogGain, (float)((IDSCameraSettings)IDSCamera.this.settings).getAnalogGain()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "DigitalAll", "Digital all gain", this::setDigitalAllGain, (float)((IDSCameraSettings)IDSCamera.this.settings).getDigitalAllGain()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "DigitalRed", "Digital red channel gain", this::setDigitalRedGain, (float)((IDSCameraSettings)IDSCamera.this.settings).getDigitalRedGain()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "DigitalGreen", "Digital green channel gain", this::setDigitalGreenGain, (float)((IDSCameraSettings)IDSCamera.this.settings).getDigitalGreenGain()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "DigitalBlue", "Digital blue channel gain", this::setDigitalBlueGain, (float)((IDSCameraSettings)IDSCamera.this.settings).getDigitalBlueGain()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "BinningHorizontal", "Horizontal Binning", this::setBinningHorizontal, ((IDSCameraSettings)IDSCamera.this.settings).getBinningSpatial()));
                    if (((IDSCameraSettings)IDSCamera.this.settings).fixedLength()) {
                        this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "BinningVertical", "Vertical Binning", this::setBinningVertical, ((IDSCameraSettings)IDSCamera.this.settings).getBinningSpectral()));
                    } else {
                        this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(IDSCamera.this.remoteSettings, "OffsetY", "Offset Y", this::setYOffset, ((IDSCameraSettings)IDSCamera.this.settings).getOffsetY()));
                    }
                }
                String string = ((IDSCameraSettings)IDSCamera.this.settings).getSpatialRoiX();
                SpatialRoiInputField spatialRoiInputField = new SpatialRoiInputField(SpatialRoiInputField.Dimension.X, string, textActionEvent -> {
                    ((IDSCameraSettings)IDSCamera.this.settings).setSpatialRoiX(textActionEvent.getText());
                    if (IDSCamera.this.isConnected()) {
                        TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "SpatialROI", textActionEvent.getText());
                    }
                    IDSCamera.this.remoteSettings.clear();
                    this.callback.reloadInformation();
                }, "X Spatial region of interest with start pixel to end pixel (100-200)");
                String string2 = ((IDSCameraSettings)IDSCamera.this.settings).getSpatialRoiY();
                SpatialRoiInputField spatialRoiInputField2 = new SpatialRoiInputField(SpatialRoiInputField.Dimension.Y, string2, textActionEvent -> {
                    ((IDSCameraSettings)IDSCamera.this.settings).setSpatialRoiX(textActionEvent.getText());
                    if (IDSCamera.this.isConnected()) {
                        TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "SpatialROIY", textActionEvent.getText());
                    }
                    IDSCamera.this.remoteSettings.clear();
                    this.callback.reloadInformation();
                }, "Y Spatial region of interest with start pixel to end pixel (100-200)");
                spatialRoiInputField2.setVisible(((IDSCameraSettings)IDSCamera.this.settings).fixedLength());
                this.addPanel(spatialRoiInputField, null, 250);
                this.addPanel(spatialRoiInputField2, null, 250);
            }

            private void setAnalogGain(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setAnalogGain(f);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "AnalogGain", f);
            }

            private void setDigitalAllGain(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setDigitalAllGain(f);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "DigitalAllGain", f);
            }

            private void setDigitalRedGain(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setDigitalRedGain(f);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "DigitalRedGain", f);
            }

            private void setDigitalGreenGain(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setDigitalGreenGain(f);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "DigitalGreenGain", f);
            }

            private void setDigitalBlueGain(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setDigitalBlueGain(f);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "DigitalBlueGain", f);
            }

            private void setYOffset(float f) {
                ((IDSCameraSettings)IDSCamera.this.settings).setOffsetY((int)f);
                IDSCamera.this.remoteSettings.setCameraProperty("OffsetY", (int)f);
            }

            private void setBinningHorizontal(float f) {
                int n = (int)f;
                ((IDSCameraSettings)IDSCamera.this.settings).setBinningSpatial(n);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "BinningSpatial", n);
            }

            private void setBinningVertical(float f) {
                int n = (int)f;
                ((IDSCameraSettings)IDSCamera.this.settings).setBinningSpectral(n);
                TcpManager.getInstance().setCameraProperty((Camera)IDSCamera.this, "BinningSpectral", n);
            }
        }
    }
}

