/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.component.IScanMode;
import se.prediktera.breeze.hardware.camera.component.TriggerSettings;
import se.prediktera.breeze.hardware.tcp.Command;

public class IDSCameraSettings
extends RemoteCameraTypeSettingsWithRoi<IDSCameraSettings>
implements TriggerSettings,
IScanMode {
    public IDSCameraSettings(RemoteCamera<IDSCameraSettings> remoteCamera) {
        super(remoteCamera);
    }

    @Override
    public List<Command.Argument> getArguments() {
        List<Command.Argument> list = super.getArguments();
        list.add(new Command.Argument("Type", (Object)this.camera.getDeviceName()));
        list.add(new Command.Argument("IsSnapshot", (Object)this.fixedLength()));
        list.add(new Command.Argument("SpatialROIX", (Object)this.getSpatialRoiX()));
        list.add(new Command.Argument("SpatialROIY", (Object)this.getSpatialRoiY()));
        list.add(new Command.Argument("DigitalAllGain", (Object)this.getDigitalAllGain()));
        list.add(new Command.Argument("DigitalRedGain", (Object)this.getDigitalRedGain()));
        list.add(new Command.Argument("DigitalGreenGain", (Object)this.getDigitalGreenGain()));
        list.add(new Command.Argument("DigitalBlueGain", (Object)this.getDigitalBlueGain()));
        list.add(new Command.Argument("AnalogGain", (Object)this.getAnalogGain()));
        list.add(new Command.Argument("OffsetY", (Object)this.getOffsetY()));
        this.fillArgumentsWithTrigger(list);
        return list;
    }

    public final void setAnalogGain(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "gainAnalog", RtDataFormat.valueOf(d));
    }

    public final double getAnalogGain() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "gainAnalog", 1.0);
    }

    public final void setDigitalAllGain(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "gainDigitalAll", RtDataFormat.valueOf(d));
    }

    public final void setDigitalRedGain(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "gainDigitalRed", RtDataFormat.valueOf(d));
    }

    public final void setDigitalGreenGain(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "gainDigitalGreen", RtDataFormat.valueOf(d));
    }

    public final void setDigitalBlueGain(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "gainDigitalBlue", RtDataFormat.valueOf(d));
    }

    public final double getDigitalAllGain() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "gainDigitalAll", 1.0);
    }

    public final double getDigitalRedGain() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "gainDigitalRed", 1.0);
    }

    public final double getDigitalBlueGain() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "gainDigitalBlue", 1.0);
    }

    public final double getDigitalGreenGain() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "gainDigitalGreen", 1.0);
    }

    public String getSpatialRoiX() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoiX", "");
    }

    public void setSpatialRoiX(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoiX", string);
    }

    public String getSpatialRoiY() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoiY", "");
    }

    public void setSpatialRoiY(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoiY", string);
    }

    public final void setOffsetY(int n) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "offsetY", String.valueOf(n));
    }

    public final int getOffsetY() {
        return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "offsetY", 760);
    }

    public final void setImageWidth(int n) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "imageWidth", String.valueOf(n));
    }

    @Override
    public boolean fixedLength() {
        return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "fixedLength", true);
    }

    @Override
    public void setFixedLength(boolean bl) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "fixedLength", String.valueOf(bl));
    }

    public Camera.CameraCaptureType getType() {
        return this.fixedLength() ? Camera.CameraCaptureType.Snapshot : Camera.CameraCaptureType.Linescan;
    }

    public void setSpectralRoi(String string) {
        this.camera.setSpectralROI(string);
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
    }

    public String getSpectralRoi() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1");
    }

    @Override
    public String getTriggerSelector() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelector", "FrameStart");
    }

    @Override
    public void setTriggerSelector(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelector", String.valueOf(string));
    }

    @Override
    public String getTriggerActivation() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", "RisingEdge");
    }

    @Override
    public void setTriggerActivation(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", String.valueOf(string));
    }

    @Override
    public double getTriggerDelay() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "TriggerDelay", 0.0);
    }

    @Override
    public void setTriggerDelay(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerDelay", RtDataFormat.valueOf(d));
    }

    @Override
    public boolean getTriggerMode() {
        return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "TriggerMode", false);
    }

    @Override
    public void setTriggerMode(boolean bl) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerMode", Boolean.toString(bl));
    }

    @Override
    public double getTriggerControlledExposureTimeMax() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "TriggerControlledExposureTimeMax", -1.0);
    }

    @Override
    public void setTriggerControlledExposureTimeMax(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerControlledExposureTimeMax", RtDataFormat.valueOf(d));
    }

    @Override
    public double getTriggerControlledExposureTimeMin() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "TriggerControlledExposureTimeMin", -1.0);
    }

    @Override
    public void setTriggerControlledExposureTimeMin(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerControlledExposureTimeMin", RtDataFormat.valueOf(d));
    }

    @Override
    public String getTriggerSource() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", "Software");
    }

    @Override
    public void setTriggerSource(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", String.valueOf(string));
    }

    @Override
    public List<String> getTriggerSelectorsAvailable() {
        String string = BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSelectorsAvailable", "FrameStart;AcquisitionStart");
        return Arrays.asList(string.split(";"));
    }

    @Override
    public List<String> getTriggerSourcesAvailable() {
        String string = BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSourcesAvailable", "Line0;Line1;Line2");
        return Arrays.asList(string.split(";"));
    }
}

