/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.util.FileFromAbsolutePath;

public class InnoSpecCamera
extends RemoteCamera<InnoSpecSettings> {
    @Override
    protected InnoSpecSettings createSettings() {
        return new InnoSpecSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public final MaxSignal getMaxsignal() {
        return new MaxSignal(16384.0f);
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    public String toString() {
        return "INNO-SPEC RedEye (Legacy)";
    }

    @Override
    public String getDeviceName() {
        return "InnoSpecCamera";
    }

    public static class InnoSpecSettings
    extends RemoteCameraTypeSettings<InnoSpecSettings> {
        public InnoSpecSettings(RemoteCamera<InnoSpecSettings> remoteCamera) {
            super(remoteCamera);
        }

        public void setMissingPixelsFile(File file) {
            BreezeProperties.getInstance().setCameraFile(this.camera, "missingPixelsFile", file);
        }

        public File getMissingPixelsFile() {
            return BreezeProperties.getInstance().getCameraFile(this.camera, "missingPixelsFile", null);
        }

        public String getAbsolutePath() {
            File file = this.getMissingPixelsFile();
            return file != null ? file.getAbsolutePath() : null;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            File file = this.getMissingPixelsFile();
            if (file != null) {
                list.add(new Command.Argument("MissingPixelsFilePath", file));
            }
            return list;
        }
    }

    class SettingsPanel
    extends JPanel {
        private AdvancedPanel advancedPanel;

        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!InnoSpecCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, InnoSpecCamera.this.settings, cameraType -> this.advancedPanel.typeChanged()));
            }
            this.advancedPanel = new AdvancedPanel(breezeFrame, settingsPanelCallback);
            InputFieldHelper.addPanel(this, this.advancedPanel);
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        public BreezeTextField getMissingPixelsFileTextField() {
            return this.advancedPanel.getMissingPixelsFileTextField();
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private FileInputField missingPixelsFileTextField;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (!InnoSpecCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(InnoSpecCamera.this.settings));
                    this.missingPixelsFileTextField = new FileInputField((Component)breezeFrame, "Missing pixels file", ((InnoSpecSettings)InnoSpecCamera.this.settings).getMissingPixelsFile(), textActionEvent -> ((InnoSpecSettings)settingsPanel.InnoSpecCamera.this.settings).setMissingPixelsFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull()), false);
                    this.addPanel(this.missingPixelsFileTextField);
                }
            }

            public void typeChanged() {
            }

            public BreezeTextField getMissingPixelsFileTextField() {
                return this.missingPixelsFileTextField != null ? this.missingPixelsFileTextField.getTextField() : null;
            }
        }
    }
}

