/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.PhotonFocusCamera;
import se.prediktera.breeze.hardware.camera.PhotonFocusCameraSettings;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class InnoSpecPhotonFocusCamera
extends PhotonFocusCamera {
    public InnoSpecPhotonFocusCamera() {
        super("InnoSpecPhotonFocusCamera", "INNO-SPEC RedEye");
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new InnoSpecPhotonFocusSettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    protected InnoSpecPhotonFocusCameraSettings createSettings() {
        return new InnoSpecPhotonFocusCameraSettings(this);
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Serial no", ((PhotonFocusCameraSettings)this.settings).getSerialNo());
        String string = ((InnoSpecPhotonFocusCameraSettings)this.settings).getConfigurationFile();
        if (!string.isEmpty()) {
            informationList.add("Config file path", ((InnoSpecPhotonFocusCameraSettings)this.settings).getConfigurationFile());
            informationList.add("Type", this.getFormattedCameraType());
            informationList.add("Mode", ((InnoSpecPhotonFocusCameraSettings)this.settings).getCameraMode().getName());
        }
    }

    @Override
    public String getFormattedCameraType() {
        return ((PhotonFocusCameraSettings)this.settings).getFormattedCameraType("RedEye");
    }

    public class InnoSpecPhotonFocusSettingsPanel
    extends JPanel {
        public InnoSpecPhotonFocusSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            InnoSpecPhotonFocusCameraSettings innoSpecPhotonFocusCameraSettings = (InnoSpecPhotonFocusCameraSettings)InnoSpecPhotonFocusCamera.this.settings;
            PhotonFocusCamera.PhotonFocusAdvancedPanel photonFocusAdvancedPanel = new PhotonFocusCamera.PhotonFocusAdvancedPanel(InnoSpecPhotonFocusCamera.this, breezeFrame, settingsPanelCallback, !innoSpecPhotonFocusCameraSettings.hasConfig());
            if (!InnoSpecPhotonFocusCamera.this.isConnected()) {
                CameraMode.CameraModeInputFieldReload cameraModeInputFieldReload = new CameraMode.CameraModeInputFieldReload("Mode", "modes", settingsPanelCallback, innoSpecPhotonFocusCameraSettings);
                innoSpecPhotonFocusCameraSettings.clearCameraModeList();
                cameraModeInputFieldReload.setVisible(false);
                cameraModeInputFieldReload.reload();
                FileInputField fileInputField = new FileInputField(breezeFrame, "Configuration file", "", textActionEvent -> {
                    File file = textActionEvent.getFile();
                    innoSpecPhotonFocusCameraSettings.setConfigurationFile(file);
                    innoSpecPhotonFocusCameraSettings.clearCameraModeList();
                    cameraModeInputFieldReload.setVisible(file != null);
                    cameraModeInputFieldReload.reload();
                    photonFocusAdvancedPanel.refresh();
                }, true, BreezeInputFieldHelper.Format.TwoRows){

                    @Override
                    protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                        jopensaveDialog2.addExtension("toml", "Configuration format (*.toml)");
                        jopensaveDialog2.addAllFiles();
                    }
                };
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, innoSpecPhotonFocusCameraSettings, arg_0 -> InnoSpecPhotonFocusSettingsPanel.lambda$new$1(InnoSpecPhotonFocusCamera.this, fileInputField, innoSpecPhotonFocusCameraSettings, cameraModeInputFieldReload, arg_0)));
                InputFieldHelper.addPanel(this, fileInputField);
                fileInputField.setUsage("Optional configuration file for wavelength information and smiles correction");
                InputFieldHelper.addPanel(this, cameraModeInputFieldReload);
            }
            InputFieldHelper.addPanel(this, photonFocusAdvancedPanel);
            if (InnoSpecPhotonFocusCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, InnoSpecPhotonFocusCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }

        private static /* synthetic */ void lambda$new$1(InnoSpecPhotonFocusCamera innoSpecPhotonFocusCamera, 1 var1_1, InnoSpecPhotonFocusCameraSettings innoSpecPhotonFocusCameraSettings, CameraMode.CameraModeInputFieldReload cameraModeInputFieldReload, CameraType cameraType) {
            String string = ((InnoSpecPhotonFocusCameraSettings)innoSpecPhotonFocusCamera.settings).getConfigurationFile();
            var1_1.setFile(string.isEmpty() ? null : new File(string));
            innoSpecPhotonFocusCameraSettings.clearCameraModeList();
            cameraModeInputFieldReload.setVisible(!string.isEmpty());
            cameraModeInputFieldReload.reload();
        }
    }

    public static class InnoSpecPhotonFocusCameraSettings
    extends PhotonFocusCameraSettings
    implements CameraMode.CameraModeSettings {
        private CameraMode.CameraModeList cameraModeList;

        public InnoSpecPhotonFocusCameraSettings(RemoteCamera<PhotonFocusCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        public String getConfigurationFile() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "configurationFile", "");
        }

        public boolean hasConfig() {
            return !this.getConfigurationFile().isEmpty();
        }

        public void setConfigurationFile(File file) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "configurationFile", FileHelper.getAbsolutePathOrEmpty(file));
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("ConfigFilePath", (Object)this.getConfigurationFile()));
            if (this.getCameraMode() != null) {
                list.add(new Command.Argument("ModeId", (Object)this.getCameraMode().getId()));
            }
            return list;
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            arrayList.add(new Command.Argument("ConfigFilePath", (Object)this.getConfigurationFile()));
            return arrayList;
        }

        @Override
        public CameraMode.CameraModeList listCameraModes() {
            if (this.cameraModeList == null) {
                this.cameraModeList = TcpManager.getInstance().getCameraModes(this.camera, this.getCameraType(), this.getListCameraNamesArguments());
            }
            return this.cameraModeList;
        }

        @Override
        public void clearCameraModeList() {
            this.cameraModeList = null;
        }

        @Override
        public void changeCameraMode(CameraMode cameraMode) {
            BreezeProperties.getInstance().setCameraMode(this.camera, this.getCameraType(), cameraMode);
        }

        @Override
        public CameraMode getCameraMode() {
            return CameraMode.getCameraMode(this.camera, this);
        }
    }
}

