/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.util.raw.ByteListFromRaw;
import se.prediktera.map.common.error.Logg;

public class MeasurementFrameSourceList {
    private final FrameSourceList rawSourceList;
    private final FrameSourceList whiteRefSourceList;
    private final FrameSourceList darkRefSourceList;
    private final boolean hasReferences;
    private boolean open;

    public MeasurementFrameSourceList(BreezeProgress breezeProgress, List<Measurement> list) {
        breezeProgress.setInfoText("Initiating Sample File Reader");
        Measurement measurement = this.getFirstMeasurementWithData(list);
        if (measurement == null) {
            throw new RuntimeException("Cant create source list from measurement list without data");
        }
        this.rawSourceList = new FrameSourceList(list, StateCamera.RawType.Normal);
        if (measurement.hasReferences()) {
            this.hasReferences = true;
            this.whiteRefSourceList = new FrameSourceList(list, StateCamera.RawType.WhiteReference);
            this.darkRefSourceList = new FrameSourceList(list, StateCamera.RawType.DarkReference);
        } else {
            this.hasReferences = false;
            this.darkRefSourceList = null;
            this.whiteRefSourceList = null;
        }
    }

    public void resetPosition() {
        this.rawSourceList.resetPosition();
        if (this.hasReferences) {
            this.whiteRefSourceList.resetPosition();
            this.darkRefSourceList.resetPosition();
        }
    }

    public byte[] getFrame(StateCamera.RawType rawType) {
        StateCamera.RawType rawType2 = rawType.getData();
        if (rawType2 == StateCamera.RawType.Normal) {
            return this.rawSourceList.getFrame();
        }
        if (this.hasReferences && rawType2 == StateCamera.RawType.WhiteReference) {
            return this.whiteRefSourceList.getFrame();
        }
        if (this.hasReferences && rawType2 == StateCamera.RawType.DarkReference) {
            return this.darkRefSourceList.getFrame();
        }
        throw new RuntimeException("Frame source has no frames for raw type: " + String.valueOf((Object)rawType2));
    }

    public boolean hasReferences() {
        return this.hasReferences;
    }

    public void open() {
        if (!this.open) {
            this.rawSourceList.open();
            if (this.hasReferences) {
                this.whiteRefSourceList.open();
                this.darkRefSourceList.open();
            }
            this.open = true;
        }
    }

    public void close() {
        this.rawSourceList.close();
        if (this.hasReferences) {
            this.whiteRefSourceList.close();
            this.darkRefSourceList.close();
        }
        this.open = false;
    }

    private Measurement getFirstMeasurementWithData(List<Measurement> list) {
        for (Measurement measurement : list) {
            if (!measurement.hasData()) continue;
            return measurement;
        }
        return null;
    }

    private static class FrameSourceList {
        private int index;
        private int line;
        private final ArrayList<FrameSource> frameSources = new ArrayList();

        public FrameSourceList(List<Measurement> list, StateCamera.RawType rawType) {
            for (Measurement measurement : list) {
                if (!measurement.hasData()) continue;
                this.frameSources.add(new ChannelFrameSource(measurement, rawType));
            }
        }

        public void resetPosition() {
            this.line = 0;
            this.index = 0;
        }

        public void open() {
            for (FrameSource frameSource : this.frameSources) {
                frameSource.open();
            }
        }

        public void close() {
            for (FrameSource frameSource : this.frameSources) {
                frameSource.close();
            }
        }

        public byte[] getFrame() {
            FrameSource frameSource = this.frameSources.get(this.index);
            if (this.line == frameSource.getNumberOfFrames().value) {
                this.line = 0;
                if (++this.index == this.frameSources.size()) {
                    this.index = 0;
                }
                frameSource = this.frameSources.get(this.index);
            }
            return frameSource.getFrame(this.line++);
        }
    }

    private static class ChannelFrameSource
    implements FrameSource {
        private final RawHeader header;
        private final ByteBuffer byteBuffer;
        private final int bufferSize;
        private final RawFile fileByState;
        private FileChannel channel;
        private final long headerOffset;

        public ChannelFrameSource(Measurement measurement, StateCamera.RawType rawType) {
            DataSize dataSize;
            Logg.trace((String)"Creating cache for measurement {} with state {}", (Object[])new Object[]{measurement, rawType});
            this.fileByState = ChannelFrameSource.getFileByStateOrThrowException(measurement, rawType);
            this.header = this.fileByState.header();
            if (rawType != StateCamera.RawType.Normal && (dataSize = ChannelFrameSource.getFileByStateOrThrowException(measurement, StateCamera.RawType.Normal).header().dataSize()) != this.header.dataSize()) {
                throw new RuntimeException("The data size for " + rawType.toString().toLowerCase() + " (" + String.valueOf((Object)this.header.dataSize()) + ") is different from the measurement file (" + String.valueOf((Object)dataSize) + ")");
            }
            this.bufferSize = this.header.bandCount().value * this.header.pixelWidth().value * this.header.dataSize().size;
            this.byteBuffer = ByteBuffer.allocate(this.bufferSize);
            this.headerOffset = this.header.getHeaderOffset();
        }

        private static RawFile getFileByStateOrThrowException(Measurement measurement, StateCamera.RawType rawType) {
            RawFile rawFile = rawType.getFileByState(measurement);
            if (rawFile == null) {
                throw new RuntimeException("Cant create frame source, no raw file for type: " + String.valueOf((Object)rawType));
            }
            return rawFile;
        }

        @Override
        public void open() {
            if (this.channel != null) {
                throw new RuntimeException("Channel already open for file: " + String.valueOf(this.fileByState.file()));
            }
            try {
                this.channel = new FileInputStream(this.fileByState.file()).getChannel();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }

        @Override
        public byte[] getFrame(int n) {
            try {
                this.channel.position(this.headerOffset + (long)n * (long)this.bufferSize);
                this.channel.read(this.byteBuffer);
                byte[] byArray = (byte[])this.byteBuffer.array().clone();
                this.byteBuffer.clear();
                return byArray;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public FrameCount getNumberOfFrames() {
            return this.header.frameCount();
        }

        @Override
        public void close() {
            if (this.channel != null) {
                try {
                    this.channel.close();
                    this.channel = null;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private static class CachingFrameSource
    implements FrameSource {
        private final List<byte[]> frames;

        public CachingFrameSource(Measurement measurement, StateCamera.RawType rawType) {
            Logg.trace((String)"Creating cache for measurement {} with state {}", (Object[])new Object[]{measurement, rawType});
            RawFile rawFile = rawType.getFileByState(measurement);
            if (rawFile.file().exists()) {
                Logg.trace((String)".. found reference file", (Object[])new Object[0]);
                this.frames = new ByteListFromRaw(rawFile.file());
            } else {
                Logg.trace((String)".. empty reference", (Object[])new Object[0]);
                this.frames = new ArrayList<byte[]>();
            }
        }

        @Override
        public byte[] getFrame(int n) {
            return this.frames.get(n);
        }

        @Override
        public FrameCount getNumberOfFrames() {
            return new FrameCount(this.frames.size());
        }

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }
    }

    private static interface FrameSource {
        public byte[] getFrame(int var1);

        public FrameCount getNumberOfFrames();

        public void open();

        public void close();
    }
}

