/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.PhotonFocusCameraSettings;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.component.BinningInputField;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public abstract class PhotonFocusCamera
extends RemoteCamera<PhotonFocusCameraSettings> {
    private final String cameraName;
    private final String displayName;

    public PhotonFocusCamera(String string, String string2) {
        this.cameraName = string;
        this.displayName = string2;
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return this.cameraName;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new PhotonFocusSettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    protected PhotonFocusCameraSettings createSettings() {
        return new PhotonFocusCameraSettings(this);
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Correction mode", ((PhotonFocusCameraSettings)this.settings).getCorrectionMode());
        informationList.add("Trigger source", ((PhotonFocusCameraSettings)this.settings).getTriggerSource());
        informationList.add("Trigger activation", ((PhotonFocusCameraSettings)this.settings).getTriggerActivation());
        informationList.add("Trigger delay", RtDataFormat.valueOf(((PhotonFocusCameraSettings)this.settings).getTriggerDelay()) + " ms");
        informationList.add("Trigger mode", ((PhotonFocusCameraSettings)this.settings).getTriggerMode() ? "On" : "Off");
        informationList.add("Packet size", this.remoteSettings.getPacketSize() + " bytes");
        informationList.add("Spatial binning", this.remoteSettings.getBinningSpatial());
        informationList.add("Spectral binning", this.remoteSettings.getBinningSpectral());
        if (!this.getSpatialRoi().isEmpty()) {
            informationList.add("Spatial ROI", this.getSpatialRoi());
        }
    }

    public String toString() {
        return this.displayName;
    }

    public class PhotonFocusSettingsPanel
    extends JPanel {
        public PhotonFocusSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!PhotonFocusCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, PhotonFocusCamera.this.settings));
            }
            InputFieldHelper.addPanel(this, new PhotonFocusAdvancedPanel(breezeFrame, settingsPanelCallback, true));
            if (PhotonFocusCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, PhotonFocusCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }
    }

    private static class CorrectionModeInputField
    extends BreezeComboBoxInputField<String> {
        public CorrectionModeInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Camera correction mode", Arrays.asList("Off", "Offset", "OffsetHotpixel", "Hotpixel", "OffsetGain", "OffsetGainHotpixel"), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("<html>Select the mode of fixed pattern noise (FPN) correction. <br/>The Offset correction is based on a internal black reference image stored in the camera from the manufacturer. <br />The Gain correction is based on a grey reference image, collected using mid intensity uniform lighting. <br />If the hot pixel correction is switched on, the camera replaces the value of a defect pixel by an average of its neighbour pixels.<br/><ul><li>Off &rarr; No correction.</li>\n<li>Offset &rarr; Only Offset correction.</li>\n<li>OffsetHotpixel &rarr;  Offset and Hotpixel correction.</li>\n<li>Hotpixel &rarr;  Only Hotpixel correction.</li>\n<li>OffsetGain &rarr;  Offset and Gain correction.</li>\n<li>OffsetGainHotpixel &rarr;  Offset, Gain and Hotpixel correction.</li></ul></html>");
            this.setEditable(false);
            this.setSelectedItem(string);
        }
    }

    private static class TriggerActivationInputField
    extends BreezeComboBoxInputField<String> {
        public TriggerActivationInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger activation", Arrays.asList("RisingEdge", "FallingEdge", "AnyEdge"), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("<html>Specifies the activation mode of the trigger.<br/><ul><li>RisingEdge &rarr; Specifies that the trigger is considered valid on the rising edge of the source signal.</li><li>FallingEdge &rarr; Specifies that the trigger is considered valid on the falling edge of the source signal.</li><li>AnyEdge &rarr; Specifies that the trigger is considered valid on the falling or rising edge of the source signal.</li></ul></html>");
        }
    }

    private class TriggerSourceInputField
    extends BreezeComboBoxInputField<String> {
        public TriggerSourceInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger source", ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getTriggerSourcesAvailable(), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("Select physical line to activate camera");
        }
    }

    protected class PhotonFocusAdvancedPanel
    extends CollapsePanel {
        private final Hardware.SettingsPanelCallback callback;
        private final boolean allowBinning;

        public PhotonFocusAdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback, boolean bl) {
            super("Advanced", true, true);
            this.callback = settingsPanelCallback;
            this.allowBinning = bl;
            this.fillPanel(breezeFrame);
        }

        private void fillPanel(BreezeFrame breezeFrame) {
            BreezeInputField breezeInputField;
            this.addPanel(new TriggerSourceInputField(((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getTriggerSource(), this::setTriggerSource));
            this.addPanel(new TriggerActivationInputField(((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getTriggerActivation(), this::setTriggerActivation));
            this.addPanel(new BreezeInputField.Number("Trigger delay", ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getTriggerDelay(), "\u00b5s", this::setTriggerDelay));
            this.addPanel(new BreezeCheckBoxInputField("Trigger mode", ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getTriggerMode(), this::setTriggerMode));
            if (!PhotonFocusCamera.this.isConnected()) {
                this.addPanel(new CorrectionModeInputField(((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getCorrectionMode(), ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings)::setCorrectionMode));
                this.addPanel(new Camera.MirrorLineInputField(PhotonFocusCamera.this.settings));
                this.addPanel(new Camera.OffsetInputField(breezeFrame, PhotonFocusCamera.this, this.callback));
                breezeInputField = new BreezeInputField("Spatial ROI", ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getSpatialRoi(), " ", textActionEvent -> ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setSpatialRoi(textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
                breezeInputField.setUsage("Spatial Region Of Interest in format 'OffsetX-EndPixel' (64-256)");
                breezeInputField.reFormat();
                this.addPanel(breezeInputField);
            } else if (this.allowBinning) {
                this.addPanel(new SpectralRoiInputField(breezeFrame, PhotonFocusCamera.this, this::setSpectralRoi));
                breezeInputField = new BreezeInputField("Spatial ROI", ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getSpatialRoi(), "", textActionEvent -> ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setSpatialRoi(textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
                InputFieldHelper.addPanel(this, breezeInputField);
                breezeInputField.setUsage("Spatial Region Of Interest in format 'OffsetX-EndPixel' (64-256)");
                breezeInputField.reFormat();
            }
            breezeInputField = new BreezeInputField("Spectral range", this.getSpectralRange(), "nm", this::setSpectralRange, BreezeInputFieldHelper.Format.TwoRows);
            breezeInputField.setUsage("<html>Specify a desired spectral range (e.g., <b>950-1700</b>) in nm<br/>Breeze will apply best effort to only include bands in that range, limited by camera increment requirements</html>");
            breezeInputField.reFormat();
            this.addPanel(breezeInputField);
            if (this.allowBinning) {
                this.addPanel(new BinningInputField.BinningSpatialInputField(PhotonFocusCamera.this, this.callback));
                this.addPanel(new BinningInputField.BinningSpectralInputField(PhotonFocusCamera.this, this.callback));
            }
        }

        private String getSpectralRange() {
            return ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).getSpectralRange();
        }

        private void setSpectralRange(TextActionEvent textActionEvent) {
            if (PhotonFocusCamera.this.isConnected()) {
                PhotonFocusCamera.this.remoteSettings.setCameraProperty("SpectralRange", textActionEvent.getText());
                this.callback.reloadInformation();
            }
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setSpectralRange(textActionEvent.getText());
        }

        private void setSpectralRoi(String string) {
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setSpectralRoi(string);
            this.callback.reloadInformation();
        }

        private void setTriggerSource(String string) {
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setTriggerSource(string);
            if (PhotonFocusCamera.this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)PhotonFocusCamera.this, "TriggerSource", string);
                this.callback.reloadInformation();
            }
        }

        private void setTriggerActivation(String string) {
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setTriggerActivation(string);
            if (PhotonFocusCamera.this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)PhotonFocusCamera.this, "TriggerActivation", string);
                this.callback.reloadInformation();
            }
        }

        private void setTriggerDelay(TextActionEvent textActionEvent) {
            float f = textActionEvent.getValueFloat();
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setTriggerDelay(f);
            if (PhotonFocusCamera.this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)PhotonFocusCamera.this, "TriggerDelay", f);
                this.callback.reloadInformation();
            }
        }

        private void setTriggerMode(boolean bl) {
            ((PhotonFocusCameraSettings)PhotonFocusCamera.this.settings).setTriggerMode(bl);
            if (PhotonFocusCamera.this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)PhotonFocusCamera.this, "TriggerMode", Boolean.toString(bl));
                this.callback.reloadInformation();
            }
        }
    }
}

