/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class PhotonFocusCameraSettings
extends RemoteCameraTypeSettingsWithRoi<PhotonFocusCameraSettings> {
    private List<String> availableIps;

    public PhotonFocusCameraSettings(RemoteCamera<PhotonFocusCameraSettings> remoteCamera) {
        super(remoteCamera);
    }

    @Override
    public List<Command.Argument> getArguments() {
        List<Command.Argument> list = super.getArguments();
        list.add(new Command.Argument("Type", (Object)this.camera.getDeviceName()));
        list.add(new Command.Argument("CorrectionMode", (Object)this.getCorrectionMode()));
        list.add(new Command.Argument("SpectralRoi", (Object)this.getSpectralRoi()));
        list.add(new Command.Argument("SpectralRange", (Object)this.getSpectralRange()));
        list.add(new Command.Argument("SpatialRoi", (Object)this.getSpatialRoi()));
        list.add(new Command.Argument("TriggerSource", (Object)this.getTriggerSource()));
        list.add(new Command.Argument("TriggerActivation", (Object)this.getTriggerActivation()));
        list.add(new Command.Argument("TriggerDelay", (Object)this.getTriggerDelay()));
        list.add(new Command.Argument("TriggerMode", (Object)this.getTriggerMode()));
        return list;
    }

    @Override
    public void clear() {
        super.clear();
        this.availableIps = null;
    }

    public List<String> getHostIps() {
        if (this.availableIps == null || this.availableIps.isEmpty()) {
            String string = TcpManager.getInstance().getCameraProperty(this.camera, "AvailableIps");
            this.availableIps = Arrays.asList(string.split(";"));
        }
        return this.availableIps;
    }

    public String getCorrectionMode() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "correctionMode", "OffsetGainHotpixel");
    }

    public void setCorrectionMode(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "correctionMode", string);
    }

    public void setSpectralRoi(String string) {
        this.camera.setSpectralROI(string);
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
    }

    public String getSpectralRoi() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1");
    }

    public void setSpectralRange(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRange", string);
    }

    public String getSpectralRange() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRange", "");
    }

    public String getTriggerSource() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", "Software");
    }

    public void setTriggerSource(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSource", String.valueOf(string));
    }

    public String getTriggerActivation() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", "RisingEdge");
    }

    public void setTriggerActivation(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerActivation", String.valueOf(string));
    }

    public double getTriggerDelay() {
        return BreezeProperties.getInstance().getCameraTypePropertyDouble(this.camera, this.getCameraType(), "TriggerDelay", 0.0);
    }

    public void setTriggerDelay(double d) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerDelay", RtDataFormat.valueOf(d));
    }

    public boolean getTriggerMode() {
        return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "TriggerMode", false);
    }

    public void setTriggerMode(boolean bl) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "TriggerMode", Boolean.toString(bl));
    }

    public List<String> getTriggerSourcesAvailable() {
        String string = BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "TriggerSourcesAvailable", "Line0;Line1");
        return Arrays.asList(string.split(";"));
    }

    public String getSpatialRoi() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoi", "");
    }

    public void setSpatialRoi(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoi", string);
    }
}

