/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PredikteraDataServerCamera
extends RemoteCamera<DataServerCameraSettings>
implements StateCamera {
    @Override
    public boolean isFrameRateAndIntegrationTimeConnected() {
        return true;
    }

    @Override
    protected DataServerCameraSettings createSettings() {
        return new DataServerCameraSettings(this);
    }

    @Override
    public boolean canChangeView() {
        return false;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public String getDeviceName() {
        return "DataServerCamera";
    }

    @Override
    public boolean autoChangeState() {
        return true;
    }

    public String toString() {
        return "Prediktera Data Server";
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Port", ((DataServerCameraSettings)this.getSettings()).getPort());
        informationList.add("Data size", ((DataServerCameraSettings)this.getSettings()).getDataSize());
    }

    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public boolean hasWhiteReference() {
        return false;
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return false;
    }

    public static class DataServerCameraSettings
    extends RemoteCameraTypeSettings {
        public DataServerCameraSettings(RemoteCamera<DataServerCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Port", (Object)this.getPort()));
            list.add(new Command.Argument("Width", (Object)this.getWidth()));
            list.add(new Command.Argument("Height", (Object)this.getHeight2()));
            list.add(new Command.Argument("Wavelength", (Object)this.getWavelength()));
            list.add(new Command.Argument("MaxSignal", (Object)this.getMaxSignal()));
            list.add(new Command.Argument("DataSize", (Object)this.getDataSize()));
            return list;
        }

        public final String getPort() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "port", "");
        }

        public final void setPort(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "port", string);
        }

        public final int getWidth() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "width", 100);
        }

        public final void setWidth(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "width", String.valueOf(n));
        }

        public final int getHeight2() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "height", 100);
        }

        public final void setHeight2(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "height", String.valueOf(n));
        }

        public final String getWavelength() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "wavelength", "");
        }

        public final void setWavelength(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "wavelength", string);
        }

        public final int getMaxSignal() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "maxSignal", 1);
        }

        public final void setMaxSignal(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "maxSignal", String.valueOf(n));
        }

        public final String getDataSize() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "dataSize", "Float");
        }

        public final void setDataSize(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "dataSize", string);
        }
    }

    private class SettingsPanel
    extends JPanel {
        private BreezeInputField.Number widthField;
        private BreezeInputField.Number heightField;
        private BreezeInputField wavelengthField;

        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!PredikteraDataServerCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, PredikteraDataServerCamera.this.settings, cameraType -> {}));
                this.addPanel(new BreezeInputField("TCP listen port", ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getPort(), "", textActionEvent -> {
                    ((DataServerCameraSettings)predikteraDataServerCamera.settings).setPort(textActionEvent.getText());
                    settingsPanelCallback.reloadInformation();
                }, BreezeInputFieldHelper.Format.OneRow));
                this.widthField = new BreezeInputField.Number("Width (pixels)", ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getWidth(), "", textActionEvent -> {
                    ((DataServerCameraSettings)predikteraDataServerCamera.settings).setWidth(textActionEvent.getValueInt());
                    settingsPanelCallback.reloadInformation();
                }, BreezeInputFieldHelper.Format.OneRow);
                this.addPanel(this.widthField);
                this.heightField = new BreezeInputField.Number("Number of bands (height)", ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getHeight2(), "", textActionEvent -> {
                    ((DataServerCameraSettings)predikteraDataServerCamera.settings).setHeight2(textActionEvent.getValueInt());
                    settingsPanelCallback.reloadInformation();
                }, BreezeInputFieldHelper.Format.OneRow);
                this.addPanel(this.heightField);
                this.wavelengthField = new BreezeInputField("Band names", ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getWavelength(), "", textActionEvent -> {
                    ((DataServerCameraSettings)predikteraDataServerCamera.settings).setWavelength(textActionEvent.getText());
                    settingsPanelCallback.reloadInformation();
                }, BreezeInputFieldHelper.Format.OneRow);
                this.addPanel(this.wavelengthField);
                InputFieldHelper.addPanel(this, new DataSizeComboBox(((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getDataSize(), ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings)::setDataSize));
                this.addPanel(new BreezeInputField.Number("Max signal", ((DataServerCameraSettings)PredikteraDataServerCamera.this.settings).getMaxSignal(), "", textActionEvent -> ((DataServerCameraSettings)predikteraDataServerCamera.settings).setMaxSignal(textActionEvent.getValueInt()), BreezeInputFieldHelper.Format.OneRow));
                JLabel jLabel = new JLabel("If you have an Envi image header specifying the format you want to use, you can import settings from its header file:");
                jLabel.setFont(new Font("Tahoma", 0, 14));
                InputFieldHelper.addPanel(this, jLabel, true, new Insets(10, 0, 0, 0));
                InputFieldHelper.addPanel(this, EntryMainHelper.createSmallTextButton("Import", () -> {
                    jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select header file", (Component)breezeFrame);
                    jopensaveDialog2.setMultiSelectionEnabled(true);
                    jopensaveDialog2.setCurrentDirectory(WorkspaceManager.getWorkspaceFolder());
                    jopensaveDialog2.addExtension("hdr", "Envi header file");
                    if (jopensaveDialog2.openshow()) {
                        RawHeader rawHeader = new RawHeader(jopensaveDialog2.getSelectedFile());
                        this.widthField.setValueAndTrigger(rawHeader.pixelWidth().value);
                        this.heightField.setValueAndTrigger(rawHeader.bandCount().value);
                        this.wavelengthField.setTextAndTrigger(rawHeader.bandNames().toWavelength());
                        settingsPanelCallback.reloadInformation();
                    }
                }), false, null);
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            this.setOpaque(false);
        }

        public void addPanel(BreezeInputField breezeInputField) {
            breezeInputField.setLabelWidth(170);
            InputFieldHelper.addPanel(this, breezeInputField);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (!PredikteraDataServerCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(PredikteraDataServerCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, PredikteraDataServerCamera.this, settingsPanelCallback));
                }
            }
        }
    }

    private static class DataSizeComboBox
    extends BreezeComboBoxInputField<String> {
        public DataSizeComboBox(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Data size", List.of("Byte", "Short", "Float", "Double"), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.setLabelWidth(170);
            this.setUnit("");
        }
    }
}

