/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.SpecimCamera;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.RgbBandsInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.breeze.util.FilePathString;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class PredikteraSimulatorCamera
extends RemoteCamera<PredikteraSimulatorSettings>
implements StateCamera,
Camera.WhiteReferenceIntensity {
    public PredikteraSimulatorCamera(TcpManager tcpManager) {
    }

    public PredikteraSimulatorCamera() {
        this(TcpManager.getInstance());
    }

    @Override
    protected PredikteraSimulatorSettings createSettings() {
        return new PredikteraSimulatorSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return ((PredikteraSimulatorSettings)this.settings).hasShutter();
    }

    @Override
    public SettingsPanel getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    public String toString() {
        return "Prediktera Simulator Camera";
    }

    @Override
    public String getXmlNodeName() {
        return "PredikteraTest";
    }

    @Override
    public String getDeviceName() {
        return "SimulatorCamera";
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return ((PredikteraSimulatorSettings)this.settings).hasReference();
    }

    @Override
    public boolean autoChangeState() {
        return true;
    }

    @Override
    public boolean hasWhiteReference() {
        return this.useReferencesWhenRecordingWithThisCamera();
    }

    @Override
    public RgbBands getRgbBands() {
        RgbBands rgbBands = RgbBands.fromCommaSeparatedString(((PredikteraSimulatorSettings)this.settings).getRgbBands());
        if (rgbBands.size() > 0) {
            return rgbBands;
        }
        return super.getRgbBands();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        Object object;
        Object object2;
        if (((PredikteraSimulatorSettings)this.settings).isDirectoryData()) {
            informationList.add("Using selection data", StringHelper.formatLabel("" + ((PredikteraSimulatorSettings)this.settings).getDirectory().isAutomatic));
            informationList.add("Data from study", ((PredikteraSimulatorSettings)this.settings).getDirectory().name);
        } else {
            informationList.add("Raw file", ((PredikteraSimulatorSettings)this.settings).getRawFile());
            object2 = ((PredikteraSimulatorSettings)this.settings).getDarkRefFile();
            if (!((String)object2).isEmpty()) {
                informationList.add("Dark reference file", (String)object2);
            }
            if (!((String)(object = ((PredikteraSimulatorSettings)this.settings).getWhiteRefFile())).isEmpty()) {
                informationList.add("White reference file", (String)object);
            }
        }
        object2 = ((PredikteraSimulatorSettings)this.settings).getWhiteReferenceTargetFile();
        if (object2 != null) {
            informationList.add("Calibrated reflectance target", ((File)object2).getAbsolutePath());
        }
        informationList.add("Bad pixel file", (object = ((PredikteraSimulatorSettings)this.settings).getBadPixelsFile()) != null ? ((File)object).getAbsolutePath() : "N/A");
        super.add(informationList);
    }

    @Override
    public RtReferenceTarget getReferenceTarget() {
        return ((PredikteraSimulatorSettings)this.settings).getReferenceTarget();
    }

    @Override
    public File getWhiteReferenceTargetFile() {
        return ((PredikteraSimulatorSettings)this.settings).getWhiteReferenceTargetFile();
    }

    @Override
    public void setWhiteReferenceTargetFile(File file) {
        ((PredikteraSimulatorSettings)this.settings).setWhiteReferenceTargetFile(file);
    }

    @Override
    public boolean takeDarkAfterMeasurement() {
        return ((PredikteraSimulatorSettings)this.settings).getTakeDarkAfterMeasurement();
    }

    public static List<Command.Argument> getFileArguments(File file, File file2, File file3) {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        PredikteraSimulatorCamera.addFileArguments(arrayList, file, file2, file3);
        return arrayList;
    }

    public static void addFileArguments(List<Command.Argument> list, File file, File file2, File file3) {
        PredikteraSimulatorCamera.addFileArguments(list, new FilePathString(file).toString(), new FilePathString(file2).toString(), new FilePathString(file3).toString(), null);
    }

    public static List<Command.Argument> addFileArguments(List<Command.Argument> list, String string, String string2, String string3, String string4) {
        if (string4 != null) {
            if (string4.isEmpty()) {
                throw new ErrorHandler.InformationMessageException("Failed to find any studies, cannot load camera");
            }
            list.add(new Command.Argument("DirectoryPath", (Object)string4));
        } else if (string != null) {
            if (string.isEmpty()) {
                throw new ErrorHandler.InformationMessageException("No raw file path specified, cannot load camera");
            }
            list.add(new Command.Argument("RawDataFilePath", (Object)string));
            if (string2 != null && string3 != null) {
                list.add(new Command.Argument("DarkReferenceFilePath", (Object)string2));
                list.add(new Command.Argument("WhiteReferenceFilePath", (Object)string3));
            } else {
                list.add(new Command.Argument("DarkReferenceFilePath", (Object)""));
                list.add(new Command.Argument("WhiteReferenceFilePath", (Object)""));
            }
            list.add(new Command.Argument("Type", (Object)"CustomFile"));
        } else {
            list.add(new Command.Argument("RawDataFilePath", (Object)""));
            list.add(new Command.Argument("DarkReferenceFilePath", (Object)""));
            list.add(new Command.Argument("WhiteReferenceFilePath", (Object)""));
        }
        return list;
    }

    public static class PredikteraSimulatorSettings
    extends RemoteCameraTypeSettings<PredikteraSimulatorSettings> {
        private static BreezeMasterCache masterCache;
        private Boolean hasReference;
        private String customCameraTypeName = null;

        public PredikteraSimulatorSettings(PredikteraSimulatorCamera predikteraSimulatorCamera) {
            super(predikteraSimulatorCamera);
        }

        @Override
        public List<Command.Argument> getArguments() {
            File file;
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("BaseLineOffset", (Object)this.getBaseLineOffset()));
            list.add(new Command.Argument("BpFilePath", this.getBadPixelsFile() != null ? this.getBadPixelsFile().getAbsolutePath() : null));
            list.add(new Command.Argument("InitiationTime", (Object)0));
            if (this.customCameraTypeName != null) {
                list.add(new Command.Argument("CameraType", (Object)this.customCameraTypeName));
            }
            if ((file = this.getWhiteReferenceTargetFile()) != null) {
                list.add(new Command.Argument("ReferenceTargetFile", file.getAbsoluteFile()));
            }
            if (this.camera.takeDarkAfterMeasurement()) {
                list.add(new Command.Argument("BinaryHeader", (Object)"true"));
            }
            return PredikteraSimulatorCamera.addFileArguments(list, this.getRawFile(), this.getDarkRefFile(), this.getWhiteRefFile(), this.isDirectoryData() ? this.getDirectory().path : null);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            arrayList.add(new Command.Argument("InitiateAvailableDevicesTime", (Object)0));
            return arrayList;
        }

        public boolean hasShutter() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(this.camera, this.getCameraType(), "shutter", true);
        }

        public String getRawFile() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "rawFile", "");
        }

        public void setRawFile(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "rawFile", string);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ListItem getDirectory() {
            Object object;
            BreezeProperties.SimulatorDirectorySettings simulatorDirectorySettings = BreezeProperties.getInstance().getSimulatorDirectoryData(this.camera, this.getCameraType());
            boolean bl = simulatorDirectorySettings.isAutomatic();
            String string = simulatorDirectorySettings.getPath();
            Object object2 = "From directory: " + string;
            if (!bl) return new ListItem((String)object2, string, bl);
            if (masterCache == null) {
                object = UpdateHelper.Product.getRunningProduct();
                masterCache = object.equals((Object)UpdateHelper.Product.Breeze) ? BreezeMasterCache.getInstance() : new BreezeMasterCache();
            }
            if (BreezeFrame.getInstance().getViewStack().getStudyContext() == null) {
                if (WorkspaceManager.getInstance().getWorkspace() == null) throw new RuntimeException("Failed to find any studies, cannot load camera");
                object = masterCache.getStudyList();
                if (((ArrayList)object).isEmpty()) {
                    return ListItem.Automatic;
                }
                BasicWorkflow basicWorkflow = (BasicWorkflow)((ArrayList)object).getFirst();
                string = basicWorkflow.getFolder().getPath();
                object2 = basicWorkflow.getName();
                return new ListItem((String)object2, string, bl);
            } else {
                object = BreezeFrame.getInstance().getViewStack().getStudyContext();
                string = ((Workflow)object).getFolder().getPath();
                object2 = ((Workflow)object).getName();
            }
            return new ListItem((String)object2, string, bl);
        }

        public void setDirectory(ListItem listItem) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "directory", listItem.path, Collections.singletonMap("isAutomatic", Boolean.toString(listItem.isAutomatic)));
        }

        public boolean isDirectoryData() {
            return BreezeProperties.getInstance().getSimulatorDirectoryData(this.camera, this.getCameraType()).isUsingDirectoryData();
        }

        public void setDirectoryData(boolean bl) {
            ListItem listItem = this.getDirectory();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("usingDirectoryData", Boolean.toString(bl));
            hashMap.put("isAutomatic", Boolean.toString(listItem.isAutomatic));
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "directory", listItem.path, hashMap);
        }

        public String getDarkRefFile() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "darkRefFile", "");
        }

        public void setDarkRefFile(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "darkRefFile", string);
        }

        public String getWhiteRefFile() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "whiteRefFile", "");
        }

        public void setWhiteRefFile(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "whiteRefFile", string);
        }

        public File getBadPixelsFile() {
            return BreezeProperties.getInstance().getCameraTypeFile(this.camera, this.getCameraType(), "badPixelsFile");
        }

        public void setBadPixelsFile(File file) {
            BreezeProperties.getInstance().setCameraTypeFile(this.camera, this.getCameraType(), "badPixelsFile", file);
            this.camera.remoteSettings.clear();
        }

        public boolean getTakeDarkAfterMeasurement() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "takeDarkAfter", false);
        }

        public void setTakeDarkAfterMeasurement(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "takeDarkAfter", String.valueOf(bl));
        }

        public boolean hasReference() {
            if (this.hasReference == null && this.isConnected()) {
                this.hasReference = Boolean.parseBoolean(TcpManager.getInstance().getCameraProperty(this.camera, "HasReference"));
            }
            if (this.hasReference != null) {
                return this.hasReference;
            }
            return false;
        }

        public int getBaseLineOffset() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "baseLineOffset", 0);
        }

        public void setBaseLineOffset(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "baseLineOffset", "" + n);
        }

        @Override
        public void clear() {
            super.clear();
            this.hasReference = null;
        }

        @Generated
        public String getCustomCameraTypeName() {
            return this.customCameraTypeName;
        }

        @Generated
        public void setCustomCameraTypeName(String string) {
            this.customCameraTypeName = string;
        }
    }

    public class SettingsPanel
    extends JPanel {
        private final JPanel optionsPanel = new JPanel(new GridBagLayout());

        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!PredikteraSimulatorCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, PredikteraSimulatorCamera.this.settings, cameraType -> {}));
                BreezeCheckBox breezeCheckBox = new BreezeCheckBox("Cycle measurements from project group folder", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).isDirectoryData(), bl -> {
                    ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setDirectoryData(bl);
                    this.updateOptionPanel(breezeFrame, settingsPanelCallback);
                });
                breezeCheckBox.setName("usedirectorymeasurements");
                InputFieldHelper.addPanel(this, breezeCheckBox);
                InputFieldHelper.addPanel(this, this.optionsPanel);
                this.updateOptionPanel(breezeFrame, settingsPanelCallback);
            }
            if (!PredikteraSimulatorCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            }
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private void updateOptionPanel(BreezeFrame breezeFrame, final Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.optionsPanel.removeAll();
            if (((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).isDirectoryData()) {
                BreezeComboBoxInputField.Loading<ListItem> loading = new BreezeComboBoxInputField.Loading<ListItem>("Source", listItem -> BreezeProgressDialog.startProgress(breezeFrame, new ProgressAction(this, (ListItem)listItem){
                    final /* synthetic */ ListItem val$item;
                    final /* synthetic */ SettingsPanel this$1;
                    {
                        this.val$item = listItem;
                        this.this$1 = settingsPanel;
                    }

                    @Override
                    public void actionComplete() {
                        settingsPanelCallback.reloadInformation();
                    }

                    @Override
                    public void runAction() {
                        ((PredikteraSimulatorSettings)this.this$1.PredikteraSimulatorCamera.this.settings).setDirectory(this.val$item);
                        settingsPanelCallback.clearReferenceCache();
                    }
                }, "Loading source"), "sources", new BreezeComboBox.LoadingCallback<ListItem>(){

                    @Override
                    public void loadItems(List<ListItem> list) {
                        list.add(ListItem.Automatic);
                        SettingsPanel.this.addSourcesToList(list);
                    }

                    @Override
                    public Object getSelectedItem() {
                        ListItem listItem = ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getDirectory();
                        if (listItem.isAutomatic) {
                            return ListItem.Automatic;
                        }
                        return new ListItem(null, listItem.path);
                    }
                });
                loading.reload();
                loading.setFormat(BreezeInputFieldHelper.Format.TwoRows);
                InputFieldHelper.addPanel(this.optionsPanel, loading);
            } else {
                RawFileInputField rawFileInputField = new RawFileInputField((Component)this, "Dark Reference File", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getDarkRefFile(), textActionEvent -> ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setDarkRefFile(textActionEvent.getText()));
                RawFileInputField rawFileInputField2 = new RawFileInputField((Component)this, "White Reference File", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getWhiteRefFile(), textActionEvent -> ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setWhiteRefFile(textActionEvent.getText()));
                InputFieldHelper.addPanel(this.optionsPanel, new RawFileInputField((Component)this, "Raw File", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getRawFile(), textActionEvent -> {
                    ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setRawFile(textActionEvent.getText());
                    File file = new File(textActionEvent.getText());
                    File file2 = new File(file.getParentFile(), "darkref_measurement.raw");
                    File file3 = new File(file.getParentFile(), "whiteref_measurement.raw");
                    if (file2.exists()) {
                        ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setDarkRefFile(file2.getAbsolutePath());
                        rawFileInputField.setFile(file2);
                    } else {
                        ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setDarkRefFile("");
                        rawFileInputField.setFile(null);
                    }
                    if (file3.exists()) {
                        ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setWhiteRefFile(file3.getAbsolutePath());
                        rawFileInputField2.setFile(file3);
                    } else {
                        ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).setWhiteRefFile("");
                        rawFileInputField2.setFile(null);
                    }
                    settingsPanelCallback.reloadInformation();
                }));
                InputFieldHelper.addPanel(this.optionsPanel, rawFileInputField);
                InputFieldHelper.addPanel(this.optionsPanel, rawFileInputField2);
            }
            this.optionsPanel.revalidate();
            this.optionsPanel.repaint();
        }

        public void addSourcesToList(List<ListItem> list) {
            if (WorkspaceManager.getInstance().getWorkspace() != null && BreezeMasterCache.isInstanceMasterCache()) {
                for (BasicWorkflow basicWorkflow : BreezeMasterCache.getInstance().getStudyList()) {
                    String string = basicWorkflow.getName();
                    int n = 0;
                    int n2 = 0;
                    for (Group group : ((Workflow)basicWorkflow).getChildList()) {
                        Pair<String, Double> pair = this.sourcePath(string, group);
                        list.add(new ListItem((String)pair.getLeft(), group.getFolder().getPath()));
                        n = (int)((double)n + (Double)pair.getRight());
                        ++n2;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(basicWorkflow.getName());
                    if (n > 0) {
                        stringBuilder.append(" - ");
                        stringBuilder.append(NiceDataFormat.toString((double)n));
                        stringBuilder.append(" measurements");
                    }
                    list.add(list.size() - n2, new ListItem(stringBuilder.toString(), basicWorkflow.getFolder().getPath()));
                }
            }
        }

        public Pair<String, Double> sourcePath(String string, Group group) {
            double d = group.getFirstDescriptorValueByName("Measurements");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" / ");
            stringBuilder.append(group.getName());
            if (d > 0.0) {
                stringBuilder.append(" - ");
                stringBuilder.append(NiceDataFormat.toString((double)d));
                stringBuilder.append(" measurements");
            }
            return Pair.of((Object)stringBuilder.toString(), (Object)d);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                this.setName("advanced");
                this.addPanel(new Camera.MirrorLineInputField(PredikteraSimulatorCamera.this.settings));
                this.addPanel(new RgbBandsInputField(breezeFrame, ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getRgbBands(), textActionEvent -> ((PredikteraSimulatorSettings)settingsPanel.PredikteraSimulatorCamera.this.settings).setRgbBands(textActionEvent.getText())));
                this.addPanel(new HySpexCamera.CalibratedReflectanceTargetInputField((Component)breezeFrame, ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getWhiteReferenceTargetFile(), textActionEvent -> settingsPanel.PredikteraSimulatorCamera.this.setWhiteReferenceTargetFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull()), BreezeInputFieldHelper.Format.OneRow));
                CollapsePanel collapsePanel = new CollapsePanel("More settings");
                collapsePanel.addPanel(new BreezeInputField.Number("Base line offset", "Reflectance base line offset. Note. Only for testing of X-ray camera", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getBaseLineOffset(), ""), (TextActionEvent textActionEvent) -> ((PredikteraSimulatorSettings)settingsPanel.PredikteraSimulatorCamera.this.settings).setBaseLineOffset(textActionEvent.getValueInt()));
                collapsePanel.addPanel(new SpecimCamera.SettingsPanel.BadPixelsFileInputFile((Component)breezeFrame, ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getBadPixelsFile(), textActionEvent -> ((PredikteraSimulatorSettings)settingsPanel.PredikteraSimulatorCamera.this.settings).setBadPixelsFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull())));
                collapsePanel.addPanel(new BreezeCheckBoxInputField("Binary header", ((PredikteraSimulatorSettings)PredikteraSimulatorCamera.this.settings).getTakeDarkAfterMeasurement(), bl -> ((PredikteraSimulatorSettings)settingsPanel.PredikteraSimulatorCamera.this.settings).setTakeDarkAfterMeasurement(bl)));
                this.addPanel(collapsePanel);
            }
        }
    }

    public static class ListItem {
        public boolean isAutomatic;
        private final String path;
        private final String name;
        public static ListItem Automatic = new ListItem("Automatic - Selected Project group", "", true);

        public ListItem(String string, String string2) {
            this(string, string2, false);
        }

        ListItem(String string, String string2, boolean bl) {
            this.name = string;
            this.path = string2;
            this.isAutomatic = bl;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            return object instanceof ListItem && ((ListItem)object).path.equals(this.path);
        }

        @Generated
        public boolean isAutomatic() {
            return this.isAutomatic;
        }

        @Generated
        public String getPath() {
            return this.path;
        }
    }

    public static class RawFileInputField
    extends FileInputField {
        private static File cachedPath;

        public RawFileInputField(Component component, String string, String string2, TextActionEvent.TextActionListener textActionListener) {
            super(component, string, string2, textActionListener);
            this.setName(EvinceScriptCommands.removeSpace((String)string).toLowerCase());
            this.getInputField().setLabelWidth(150);
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            FileChooserPanel.addDataFileFilters(jopensaveDialog2, FileChooserPanel.FilterType.HS);
            jopensaveDialog2.setCurrentDirectory(this.getCachedOrDefaultImportDirectory(jopensaveDialog2.getSelectedFile()));
            jopensaveDialog2.addAllSupported();
        }

        @Override
        protected void fileSelected(File file) {
            super.fileSelected(file);
            cachedPath = file;
        }

        private File getCachedOrDefaultImportDirectory(File file) {
            if (file != null && file.exists()) {
                cachedPath = file.getParentFile();
                return cachedPath;
            }
            if (cachedPath == null || !cachedPath.exists()) {
                cachedPath = WorkspaceManager.getInstance().getWorkspace().getPath().toFile();
            }
            return cachedPath;
        }
    }
}

