/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSliderPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class QtechnologyCamera
extends RemoteCamera<QtechnologyCameraSettings> {
    @Override
    public boolean hasShutter() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return "QtechnologyCamera";
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public String getXmlNodeName() {
        return "Qtech";
    }

    @Override
    protected QtechnologyCameraSettings createSettings() {
        return new QtechnologyCameraSettings(this);
    }

    public String toString() {
        return "Qtechnology Camera";
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        QtechnologyCameraSettings qtechnologyCameraSettings = (QtechnologyCameraSettings)this.getSettings();
        informationList.add("IP address", qtechnologyCameraSettings.getHostIp());
        List<String> list = Arrays.asList(qtechnologyCameraSettings.getSpectralRoi().split(";"));
        informationList.add("Spectral ROI", (String)(list.contains("0") ? Collections.frequency(list, "1") + " of " + list.size() + " included" : "All bands included"));
        informationList.add("Spectral binning", (String)(qtechnologyCameraSettings.getBinningSpectral() == 1 ? "None" : qtechnologyCameraSettings.getBinningSpectral() + "X"));
        String string = qtechnologyCameraSettings.getSpatialRoi();
        MinMax minMax = new MinMax(string);
        informationList.add("Horizontal cropping", string.isEmpty() || minMax.max().intValue() - minMax.min().intValue() == ((QtechnologyCameraSettings)this.settings).getMaxHorizontalCrop() ? "All pixels included" : String.format("Start: %d, End: %d", minMax.min().intValue(), minMax.max().intValue()));
        informationList.add("Horizontal binning", (String)(qtechnologyCameraSettings.getBinningSpatial() == 1 ? "None" : qtechnologyCameraSettings.getBinningSpatial() + "X"));
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!QtechnologyCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, QtechnologyCamera.this.settings));
                InputFieldHelper.addPanel(this, new BreezeInputField("Camera IP address", ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getHostIp(), " ", textActionEvent -> ((QtechnologyCameraSettings)qtechnologyCamera.settings).setHostIp(textActionEvent.getText()), BreezeInputFieldHelper.Format.OneRow));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            if (QtechnologyCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, QtechnologyCamera.this.remoteSettings);
            }
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private final Hardware.SettingsPanelCallback callback;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced", true, true);
                this.callback = settingsPanelCallback;
                this.fillPanel(breezeFrame);
            }

            private void fillPanel(BreezeFrame breezeFrame) {
                if (!QtechnologyCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(QtechnologyCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, QtechnologyCamera.this, this.callback));
                    this.addPanel(new BreezeComboBoxInputField<QtechnologyCameraSettings.PixelType>("Pixel format", Arrays.asList(QtechnologyCameraSettings.PixelType.values()), ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getPixelType(), ((QtechnologyCameraSettings)QtechnologyCamera.this.settings)::setPixelType, BreezeInputFieldHelper.Format.OneRow));
                    this.addPanel(new BreezeSpinnerInputPanel("Skip initial frames", "Skip a number of frames when connecting a new data stream to mitigate for initial over saturation of sensor data", 0.0f, 100.0f, 1.0f, ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getSkipInitialFrames(), BreezeInputFieldHelper.Format.OneRow, BreezeSpinner.NumberInputLocation.LEFT, "frames", ((QtechnologyCameraSettings)QtechnologyCamera.this.settings)::setSkipInitialFrames));
                } else {
                    this.addPanel(new SpectralRoiInputField(breezeFrame, QtechnologyCamera.this, string -> {
                        String string2 = string;
                        if (string2.isEmpty()) {
                            string2 = ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getSpectralRoi();
                        }
                        ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).setSpectralRoi(QtechnologyCamera.this.setSpectralROI(string2));
                        this.callback.reloadInformation();
                    }));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(QtechnologyCamera.this.remoteSettings, "BinningVertical", "Vertical binning", this::setBinningVertical, ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getBinningSpectral()));
                    this.addPanel(BreezeSlider.getSliderWithMinAndMaxFromServer(QtechnologyCamera.this.remoteSettings, "BinningHorizontal", "Horizontal binning", this::setBinningHorizontal, ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getBinningSpatial()));
                    BreezeLabel breezeLabel = new BreezeLabel("Horizontal cropping", false, 14);
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 155);
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)breezeLabel, gridBagConstraints);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.fill = 2;
                    TcpManager.DataSettings dataSettings = QtechnologyCamera.this.remoteSettings.getDataSettingsForProperty("HorizontalCrop");
                    MinMax minMax = new MinMax(dataSettings.min().floatValue(), dataSettings.max().floatValue());
                    MinMax minMax3 = this.getSpatialRoi(minMax);
                    ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).setMaxHorizontalCrop(minMax.max().intValue());
                    jPanel.add((Component)new BreezeRangeSliderPanel(dataSettings.min().floatValue(), dataSettings.max().floatValue(), minMax3.min().floatValue(), minMax3.max().floatValue(), 1.0f, minMax2 -> this.setSpatialRoi(minMax2, minMax), BreezeInputFieldHelper.Format.OneRow), gridBagConstraints);
                    this.addPanel(jPanel);
                }
            }

            private MinMax getSpatialRoi(MinMax minMax) {
                String string = ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).getSpatialRoi();
                if (StringUtils.isEmpty((CharSequence)string)) {
                    return minMax;
                }
                return new MinMax(string);
            }

            private MinMax setSpatialRoi(MinMax minMax, MinMax minMax2) {
                String string = minMax.equals(minMax2) ? "" : minMax.formatRange();
                MinMax minMax3 = new MinMax(QtechnologyCamera.this.remoteSettings.setSpatialRoi(string));
                ((QtechnologyCameraSettings)QtechnologyCamera.this.settings).setSpatialRoi(minMax3.formatRange());
                this.callback.reloadInformation();
                return minMax3;
            }

            private void setBinningHorizontal(float f) {
                int n = (int)f;
                int n2 = QtechnologyCamera.this.remoteSettings.setBinningSpatial(n);
                ((QtechnologyCameraSettings)QtechnologyCamera.this.getSettings()).setBinningSpatial(n2);
                this.callback.reloadInformation();
            }

            private void setBinningVertical(float f) {
                int n = (int)f;
                int n2 = QtechnologyCamera.this.remoteSettings.setBinningSpectral(n);
                ((QtechnologyCameraSettings)QtechnologyCamera.this.getSettings()).setBinningSpectral(n2);
                this.callback.reloadInformation();
            }
        }
    }

    public class QtechnologyCameraSettings
    extends RemoteCameraTypeSettingsWithRoi<QtechnologyCameraSettings> {
        private int maxHorizontalCrop;

        public QtechnologyCameraSettings(RemoteCamera<QtechnologyCameraSettings> remoteCamera) {
            super(remoteCamera);
            this.maxHorizontalCrop = 0;
        }

        public String getSpatialRoi() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoi", "");
        }

        public void setSpatialRoi(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spatialRoi", string);
            this.clear();
        }

        public void setSpectralRoi(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
            this.clear();
        }

        public String getSpectralRoi() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1");
        }

        public String getHostIp() {
            return BreezeProperties.getInstance().getCameraTypeProperty(QtechnologyCamera.this, this.getCameraType(), "hostIp", "10.100.10.100");
        }

        public void setHostIp(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(QtechnologyCamera.this, this.getCameraType(), "hostIp", string);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Host", (Object)this.getHostIp()));
            list.add(new Command.Argument("SpectralRoi", (Object)this.getSpectralRoi()));
            list.add(new Command.Argument("SpatialRoi", (Object)this.getSpatialRoi()));
            list.add(new Command.Argument("PixelType", this.getPixelType()));
            list.add(new Command.Argument("SkipInitialSaturatedFrameCount", (Object)Float.valueOf(this.getSkipInitialFrames())));
            return list;
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return List.of(new Command.Argument("Host", (Object)this.getHostIp()));
        }

        public PixelType getPixelType() {
            return PixelType.valueOf(BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "pixelType", PixelType.Short.toString()));
        }

        public void setPixelType(PixelType pixelType) {
            BreezeProperties.getInstance().setCameraTypeProperty(QtechnologyCamera.this, this.getCameraType(), "pixelType", pixelType.toString());
        }

        public void setSkipInitialFrames(Double d) {
            BreezeProperties.getInstance().setCameraTypeProperty(QtechnologyCamera.this, this.getCameraType(), "initialFramesDiscardCount", RtDataFormat.toString(d.intValue()));
        }

        public float getSkipInitialFrames() {
            return BreezeProperties.getInstance().getCameraTypePropertyFloat(QtechnologyCamera.this, this.getCameraType(), "initialFramesDiscardCount", 20.0f);
        }

        @Generated
        public int getMaxHorizontalCrop() {
            return this.maxHorizontalCrop;
        }

        @Generated
        public void setMaxHorizontalCrop(int n) {
            this.maxHorizontalCrop = n;
        }

        public static enum PixelType {
            Byte,
            Short;

        }
    }
}

