/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.InnoSpecCamera;
import se.prediktera.breeze.test.SlowTestCategory;

@Category(value={SlowTestCategory.class})
public class RedEyeCameraTest {
    @Before
    public void setMockInstance() {
        BreezeProperties.getInstance().setTestingInstance(new BreezeProperties.MockBreezeProperties(this){

            @Override
            public String getBreezeRuntimeHost() {
                return "testhost";
            }
        });
    }

    @After
    public void resetMockInstance() {
        BreezeProperties.clearInstance();
    }

    @Test
    public void itReadsFieldOfViewFromBreezePropertiesCameraSpecific() {
        InnoSpecCamera innoSpecCamera = new InnoSpecCamera();
        BreezeProperties.getInstance().setCameraFieldOfView(innoSpecCamera, new FieldOfView(2211.0f));
        MatcherAssert.assertThat((Object)innoSpecCamera.getFieldOfView(), (Matcher)CoreMatchers.is((Object)new FieldOfView(2211.0f)));
    }

    @Test
    public void itSetsFieldOfViewToBreezePropertiesCameraSpecific() {
        InnoSpecCamera innoSpecCamera = new InnoSpecCamera();
        innoSpecCamera.setFieldOfView(new FieldOfView(3245.0f));
        MatcherAssert.assertThat((Object)BreezeProperties.getInstance().getCameraFieldOfView(innoSpecCamera), (Matcher)CoreMatchers.is((Object)new FieldOfView(3245.0f)));
    }

    @Test
    public void itReadsMeasurementLengthFromBreezePropertiesGlobal() {
        InnoSpecCamera innoSpecCamera = new InnoSpecCamera();
        BreezeProperties.getInstance().setMeasureLength(new MeasurementLength(333.0f));
        MatcherAssert.assertThat((Object)innoSpecCamera.getMeasurementLength(), (Matcher)CoreMatchers.is((Object)new MeasurementLength(333.0f)));
    }

    @Test
    public void itSetsMeasurementLengthToBreezePropertiesGlobal() {
        InnoSpecCamera innoSpecCamera = new InnoSpecCamera();
        innoSpecCamera.setMeasureLength(new MeasurementLength(444.0f));
        MatcherAssert.assertThat((Object)BreezeProperties.getInstance().getMeasurementLength(), (Matcher)CoreMatchers.is((Object)new MeasurementLength(444.0f)));
    }
}

