/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.Temperature;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.AbstractCamera;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCameraSettings;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RawHandleFrame;
import se.prediktera.breeze.hardware.camera.capture.RemoteCameraCaptureSession;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public abstract class RemoteCamera<T extends RemoteCameraTypeSettings>
extends AbstractCamera {
    protected final T settings = this.createSettings();
    protected final RemoteCameraSettings remoteSettings = new RemoteCameraSettings(this);
    private File memoryMappedFile;
    private boolean shutterOpened;

    protected abstract T createSettings();

    @Override
    public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
        ((RemoteCameraTypeSettings)this.settings).listCameraNames();
        TcpManager.getInstance().initializeCamera(breezeProgress, this, ((RemoteCameraTypeSettings)this.settings).getCameraType(), ((RemoteCameraTypeSettings)this.settings).getArguments(), () -> this.setConnected(false));
        this.setConnected(true);
        this.remoteSettings.updateCameraWithConfiguredFrameRateAndIntegrationTime(this.isFrameRateAndIntegrationTimeConnected());
        this.memoryMappedFile = this.getMemoryMappedFile();
        if (this.hasShutter()) {
            this.openShutter();
        }
        BreezeProperties.getInstance().increaseSaveIndex();
    }

    @Override
    public boolean isFrameRateAndIntegrationTimeConnected() {
        return false;
    }

    @Override
    public void disconnect(BreezeProgressManager breezeProgressManager) {
        this.remoteSettings.clear();
        ((RemoteCameraTypeSettings)this.settings).clear();
        TcpManager.getInstance().disconnect(breezeProgressManager, this);
        this.setConnected(false);
        BreezeProperties.getInstance().increaseSaveIndex();
    }

    public abstract JComponent getCameraSettingsPanel(BreezeFrame var1, Hardware.SettingsPanelCallback var2);

    @Override
    public void startCapture(FrameCount frameCount, Camera.CaptureCallback captureCallback) {
        this.startCapture(frameCount, captureCallback, this.memoryMappedFile, null);
    }

    private File getMemoryMappedFile() {
        String string;
        if (BreezeProperties.getInstance().isBreezeRuntimeLocal() && BreezeProperties.getInstance().useMemoryMappedFile() && (string = WorkspaceManager.getInstance().getCurrentOrDefaultWorkspacePath()) != null) {
            File file = new File(string, "Data/Temp/");
            try {
                return File.createTempFile("mmf", "data", file);
            }
            catch (IOException iOException) {
                Logg.error((String)"Cannot create memory mapped file", (Throwable)iOException);
            }
        }
        return null;
    }

    public void startCapture(FrameCount frameCount, Camera.CaptureCallback captureCallback, File file, File file2) {
        BufferedTcpStream bufferedTcpStream = new BufferedTcpStream(new RawHandleFrame(this.getDataSize(), this.getBandCount(), this.getWidth(), this.getBandNames(), this.getInterleave(), this.getByteOrder(), ((RemoteCameraTypeSettings)this.settings).isFlipPixels()), BreezeProperties.getInstance().getBreezeRuntimeConnectHost(), BreezeProperties.getInstance().getDataStreamPort(), new BufferedTcpStream.StreamCallback(this){

            @Override
            public void onStop() {
            }

            @Override
            public void onStart() {
            }
        }, file);
        bufferedTcpStream.connect();
        new RemoteCameraCaptureSession(TcpManager.getInstance(), bufferedTcpStream, captureCallback, this.getId(), frameCount, file2, false).runBlocking();
        bufferedTcpStream.disconnect();
    }

    @Override
    public void preCaptureWarmup() {
        TcpManager.getInstance().preCaptureWarmup();
    }

    @Override
    public BandNames getBandNames() {
        return this.remoteSettings.getBandNames();
    }

    public RtInterleave getInterleave() {
        return this.remoteSettings.getInterleave();
    }

    public RtByteOrder getByteOrder() {
        return this.remoteSettings.getByteOrder();
    }

    @Override
    public boolean canChangeLength() {
        return true;
    }

    @Override
    public boolean canChangeView() {
        return true;
    }

    @Override
    public void openShutter() {
        this.shutterOpened = true;
        TcpManager.getInstance().openShutter(this.getId());
    }

    @Override
    public void closeShutter() {
        this.shutterOpened = false;
        TcpManager.getInstance().closeShutter(this.getId());
        ThreadUtil.sleep(BreezeProperties.getInstance().getCameraPropertyInt(this, "shutterDelay", 200));
    }

    @Override
    public boolean isShutterOpened() {
        return this.shutterOpened;
    }

    @Override
    public void setFrameRate(FrameRate frameRate) {
        this.remoteSettings.setFrameRate(frameRate);
    }

    @Override
    public FrameRate getFrameRate() {
        return this.remoteSettings.getFrameRate();
    }

    @Override
    public FrameRate getMaxFrameRate() {
        return this.remoteSettings.getMaxFrameRate();
    }

    public String setSpectralROI(String string) {
        this.remoteSettings.setSpectralROI(string);
        return this.remoteSettings.getSpectralROI();
    }

    public String getSpectralROI() {
        return this.remoteSettings.getSpectralROI();
    }

    public void setSpatialRoi(String string) {
        this.remoteSettings.setSpatialRoi(string);
    }

    public String getSpatialRoi() {
        return this.remoteSettings.getSpatialRoi();
    }

    @Override
    public void setIntegrationTime(IntegrationTime integrationTime) {
        this.remoteSettings.setIntegrationTime(integrationTime);
    }

    @Override
    public IntegrationTime getIntegrationTime() {
        return this.remoteSettings.getIntegrationTime();
    }

    @Override
    public Temperature getTemperature() {
        return this.remoteSettings.getTemperature();
    }

    @Override
    public PixelWidth getWidth() {
        return this.remoteSettings.getWidth();
    }

    @Override
    public BandCount getBandCount() {
        return this.remoteSettings.getBandCount();
    }

    @Override
    public RgbBands getRgbBands() {
        return this.remoteSettings.getRgbBands();
    }

    @Override
    public Integer getReadoutTime() {
        return this.remoteSettings.getReadoutTime();
    }

    @Override
    public MaxSignal getMaxsignal() {
        return this.remoteSettings.getMaxSignal();
    }

    @Override
    public DataSize getDataSize() {
        return this.remoteSettings.getDataSize();
    }

    @Override
    public DrReMatrix getDrReMatrix() {
        return this.remoteSettings.getReMatrix(((RemoteCameraTypeSettings)this.settings).isFlipPixels());
    }

    @Override
    public boolean isFlipped() {
        return ((RemoteCameraTypeSettings)this.settings).isFlipPixels();
    }

    public RemoteCameraSettings getRemoteSettings() {
        return this.remoteSettings;
    }

    @Override
    public LengthValue getOffset() {
        return new LengthValue(((RemoteCameraTypeSettings)this.settings).getOffset());
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return true;
    }

    public void add(InformationPanel.InformationList informationList) {
        informationList.add("Type", this.getFormattedCameraType());
    }

    @Override
    public CameraType getCameraType() {
        return ((RemoteCameraTypeSettings)this.settings).getCameraType();
    }

    public T getSettings() {
        return this.settings;
    }

    public boolean autoChangeState() {
        return false;
    }

    public void changeStateToWhiteReference() {
        if (this.autoChangeState()) {
            TcpManager.getInstance().setCameraProperty((Camera)this, "State", "WhiteReference");
            this.remoteSettings.clear();
        }
    }

    public void changeStateToNormal() {
        if (this.autoChangeState()) {
            TcpManager.getInstance().setCameraProperty((Camera)this, "State", "Normal");
            this.remoteSettings.clear();
        }
    }

    @Override
    public void setFieldOfView(FieldOfView fieldOfView) {
        super.setFieldOfView(fieldOfView);
        if (this.isConnected()) {
            TcpManager.getInstance().setCameraProperty((Camera)this, "FieldOfView", fieldOfView.value);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return HardwareIcon.create(this);
    }

    @Override
    public String getFormattedCameraType() {
        return this.getCameraType().getName();
    }

    public static class HardwareIcon
    extends ImageIcon {
        private static final HashMap<Hardware, HardwareIcon> hashMap = new HashMap();
        public static HashMap<String, String> colorHashMap = new HashMap();

        private HardwareIcon(Hardware hardware) {
            Color color;
            String string = hardware.toString().substring(0, 2).toUpperCase();
            String string2 = colorHashMap.get(string);
            if (string2 == null) {
                color = RtPerfectSpread.generateColor(string.hashCode() * 6);
                colorHashMap.put(string, RtPerfectSpread.getColorToString(color));
                System.err.println("colorHashMap.put(\"" + string + "\", \"" + RtPerfectSpread.getColorToString(color) + "\"); // " + String.valueOf(hardware));
            } else {
                color = RtPerfectSpread.getColorFromString(string2);
            }
            Color color2 = Color.white;
            BufferedImage bufferedImage = new BufferedImage(20, 20, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, 20.0f, 20.0f, 6.0f, 6.0f));
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRoundRect(0, 0, 19, 19, 6, 6);
                graphics2D.setClip(null);
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
                graphics2D.drawRoundRect(0, 0, 19, 19, 6, 6);
            }
            graphics2D.setColor(color2);
            Font font = graphics2D.getFont();
            graphics2D.setFont(new Font(font.getName(), 1, 10));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, 10 - n / 2, 10 + fontMetrics.getHeight() / 4);
            graphics2D.dispose();
            this.setImage(bufferedImage);
        }

        public static HardwareIcon create(Hardware hardware) {
            HardwareIcon hardwareIcon = hashMap.get(hardware);
            if (hardwareIcon == null) {
                hardwareIcon = new HardwareIcon(hardware);
                hashMap.put(hardware, hardwareIcon);
            }
            return hardwareIcon;
        }

        static {
            colorHashMap.put("PR", BreezeColor.colorToHex(BreezeTheme.PREDIKTERA_COLOR));
            colorHashMap.put("HY", BreezeColor.colorToHex(BreezeTheme.HYSPEX_COLOR));
            colorHashMap.put("SP", "#ff4d00");
            colorHashMap.put("IN", "#f49712");
            colorHashMap.put("RE", "#a60037");
            colorHashMap.put("ID", "#008a96");
            colorHashMap.put("DE", "#ff16bc");
            colorHashMap.put("GE", "#54bfda");
            colorHashMap.put("BA", "#0a4981");
            colorHashMap.put("UN", "#982fc0");
            colorHashMap.put("RG", "#1ed79b");
            colorHashMap.put("HA", "#000000");
            colorHashMap.put("VI", "#82c443");
            colorHashMap.put("UM", "#1ed79b");
            colorHashMap.put("QT", "#7bae4e");
            colorHashMap.put("SO", "#2b2a28");
        }
    }
}

