/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.Temperature;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class RemoteCameraSettings {
    private final RemoteCamera camera;
    private IntegrationTime integrationTime;
    private FrameRate frameRate;
    private FrameRate maxFrameRate;
    private PixelWidth pixelWidth;
    private BandCount bandCount;
    private RtInterleave interleave;
    private RtByteOrder byteOrder;
    private DataSize dataSize;
    private MaxSignal maxSignal;
    private BandNames bandNames;
    private Temperature temperature;
    private RgbBands rgbBands;
    private Integer readoutTime;
    private DrReMatrix drReMatrix;
    private String warnings;

    public RemoteCameraSettings(RemoteCamera remoteCamera) {
        this.camera = remoteCamera;
    }

    public void clear() {
        this.integrationTime = null;
        this.frameRate = null;
        this.maxFrameRate = null;
        this.pixelWidth = null;
        this.bandCount = null;
        this.interleave = null;
        this.byteOrder = null;
        this.dataSize = null;
        this.maxSignal = null;
        this.bandNames = null;
        this.rgbBands = null;
        this.readoutTime = null;
        this.drReMatrix = null;
        this.warnings = null;
    }

    protected boolean isConnected() {
        return this.camera.isConnected();
    }

    public IntegrationTime getIntegrationTime() {
        if (this.integrationTime == null) {
            this.integrationTime = new IntegrationTime(this.getCameraPropertyFloat("IntegrationTime"));
        }
        return this.integrationTime;
    }

    public void setIntegrationTime(IntegrationTime integrationTime) {
        TcpManager.getInstance().setCameraProperty((Camera)this.camera, "IntegrationTime", integrationTime.value);
        this.integrationTime = null;
        this.frameRate = null;
        BreezeProperties.getInstance().setCameraProperty(this.camera, "integrationTime", Double.toString(this.getIntegrationTime().value));
        if (this.camera.isFrameRateAndIntegrationTimeConnected()) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "frameRate", Float.toString(this.getFrameRate().value));
        }
    }

    public void updateCameraWithConfiguredFrameRateAndIntegrationTime(boolean bl) {
        this.setFrameRate(new FrameRate(BreezeProperties.getInstance().getCameraPropertyFloat(this.camera, "frameRate", 100)));
        if (bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "integrationTime", Double.toString(this.getIntegrationTime().value));
        } else {
            this.setIntegrationTime(new IntegrationTime(BreezeProperties.getInstance().getCameraPropertyFloat(this.camera, "integrationTime", 1000)));
        }
    }

    public FrameRate getFrameRate() {
        if (this.isConnected()) {
            if (this.frameRate == null) {
                this.frameRate = new FrameRate(this.getCameraPropertyFloat("FrameRate"));
            }
            return this.frameRate;
        }
        return new FrameRate(BreezeProperties.getInstance().getCameraPropertyFloat(this.camera, "frameRate", 100));
    }

    public FrameRate getMaxFrameRate() {
        if (this.isConnected()) {
            if (this.maxFrameRate == null) {
                this.maxFrameRate = new FrameRate(this.getCameraPropertyFloat("MaxFrameRate"));
            }
            return this.maxFrameRate;
        }
        return new FrameRate(2.1474836E9f);
    }

    public void setFrameRate(FrameRate frameRate) {
        this.integrationTime = null;
        this.frameRate = null;
        if (this.isConnected()) {
            this.setCameraProperty("FrameRate", frameRate.value);
            this.frameRate = this.getFrameRate();
        } else {
            this.frameRate = frameRate;
        }
        BreezeProperties.getInstance().setCameraProperty(this.camera, "frameRate", Float.toString(this.frameRate.value));
        if (this.camera.isFrameRateAndIntegrationTimeConnected()) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "integrationTime", Double.toString(this.getIntegrationTime().value));
        }
    }

    public String getSpectralROI() {
        return this.getCameraProperty("SpectralROI");
    }

    public void setSpectralROI(String string) {
        TcpManager.getInstance().setCameraProperty((Camera)this.camera, "SpectralROI", string);
        this.clear();
    }

    public String getSpatialRoi() {
        return this.getCameraProperty("SpatialROI");
    }

    public String setSpatialRoi(String string) {
        CommandReply commandReply = TcpManager.getInstance().setCameraProperty((Camera)this.camera, "SpatialROI", string);
        this.clear();
        return commandReply.getMessage();
    }

    public final int getBinningSpatial() {
        return this.getCameraPropertyInt("BinningSpatial");
    }

    public final int setBinningSpatial(int n) {
        CommandReply commandReply = TcpManager.getInstance().setCameraProperty((Camera)this.camera, "BinningSpatial", n);
        this.clear();
        return RtDataFormat.toNumberInt(commandReply.getMessage());
    }

    public final int getBinningSpectral() {
        return this.getCameraPropertyInt("BinningSpectral");
    }

    public final int setBinningSpectral(int n) {
        CommandReply commandReply = TcpManager.getInstance().setCameraProperty((Camera)this.camera, "BinningSpectral", n);
        this.clear();
        return RtDataFormat.toNumberInt(commandReply.getMessage());
    }

    public final int getPacketSize() {
        return this.getCameraPropertyInt("GevScpsPacketSize");
    }

    public void setCameraProperty(String string, int n) {
        TcpManager.getInstance().setCameraProperty((Camera)this.camera, string, n);
    }

    public void setCameraProperty(String string, double d) {
        TcpManager.getInstance().setCameraProperty((Camera)this.camera, string, d);
    }

    public void setCameraProperty(String string, String string2) {
        TcpManager.getInstance().setCameraProperty((Camera)this.camera, string, string2);
    }

    public PixelWidth getWidth() {
        if (this.pixelWidth == null && this.isConnected()) {
            this.pixelWidth = new PixelWidth((int)this.getCameraPropertyDouble("ImageWidth"));
        }
        return this.pixelWidth;
    }

    public BandCount getBandCount() {
        if (this.bandCount == null) {
            this.bandCount = new BandCount((int)this.getCameraPropertyDouble("ImageHeight"));
        }
        return this.bandCount;
    }

    public RgbBands getRgbBands() {
        if (this.rgbBands == null && this.isConnected()) {
            String string = this.getCameraProperty("RgbBands");
            this.rgbBands = string.length() > 0 ? RgbBands.fromCommaSeparatedString(string) : this.getBandCount().getRgbBands(this.getBandNames());
        }
        return this.rgbBands;
    }

    public Integer getReadoutTime() {
        String string;
        if (this.readoutTime == null && this.isConnected() && (string = this.getCameraProperty("ReadoutTime")).length() > 0) {
            this.readoutTime = RtDataFormat.toNumberInt(string);
        }
        return this.readoutTime;
    }

    public RtInterleave getInterleave() {
        if (this.interleave == null) {
            this.interleave = RtInterleave.fromBreezeRuntime(this.getCameraProperty("Interleave"));
        }
        return this.interleave;
    }

    public RtByteOrder getByteOrder() {
        if (this.byteOrder == null) {
            this.byteOrder = RtByteOrder.fromBreezeRuntime(this.getCameraProperty("ByteOrder"));
        }
        return this.byteOrder;
    }

    public DataSize getDataSize() {
        if (this.dataSize == null) {
            this.dataSize = DataSize.fromBreezeRuntime(this.getCameraProperty("DataSize"));
        }
        return this.dataSize;
    }

    public MaxSignal getMaxSignal() {
        if (this.maxSignal == null) {
            this.maxSignal = new MaxSignal(this.getCameraPropertyFloat("MaxSignal"));
        }
        return this.maxSignal;
    }

    public Temperature getTemperature() {
        if (this.temperature == null) {
            this.temperature = new Temperature(this.getCameraPropertyFloat("Temperature"));
        }
        return this.temperature;
    }

    public BandNames getBandNames() {
        if (this.bandNames == null) {
            this.bandNames = BandNames.fromSemiColonSeparatedWavelengthList(TcpManager.getInstance().getCameraProperty(this.camera, "Wavelengths"));
        }
        return this.bandNames;
    }

    public TcpManager.DataSettings getDataSettingsForProperty(String string) {
        return TcpManager.getInstance().getDataSettingsForProperty(string, this.camera.getId());
    }

    public DrReMatrix getReMatrix(boolean bl) {
        if (this.drReMatrix == null) {
            this.drReMatrix = new DrReMatrix(this.camera);
        }
        return this.drReMatrix;
    }

    public String getWarnings() {
        if (this.warnings == null) {
            this.warnings = TcpManager.getInstance().getCameraProperty(this.camera, "Warnings");
        }
        return this.warnings;
    }

    public double getCameraPropertyDouble(String string) {
        return RtDataFormat.toNumber(this.getCameraProperty(string));
    }

    public float getCameraPropertyFloat(String string) {
        return RtDataFormat.toNumberFloat(this.getCameraProperty(string));
    }

    public int getCameraPropertyInt(String string) {
        return RtDataFormat.toNumberInt(this.getCameraProperty(string));
    }

    public String getCameraProperty(String string) {
        return TcpManager.getInstance().getCameraProperty(this.camera, string);
    }
}

